/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.irrigation;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.v1.misc.IAgriFluidComponent;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.agricraft.tiles.irrigation.TileEntitySprinkler;
import com.infinityraider.infinitylib.utility.WorldHelper;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityChannelValve
extends TileEntityChannel
implements IDebuggable {
    private boolean powered = false;

    @Override
    protected byte classifyConnection(@Nonnull EnumFacing side) {
        Block b = WorldHelper.getBlock((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(side), Block.class).orElse(null);
        IAgriFluidComponent component = WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(side), IAgriFluidComponent.class).orElse(null);
        if (b instanceof BlockLever) {
            return -1;
        }
        if (component == null) {
            return 0;
        }
        if (side.func_176740_k().func_176722_c()) {
            return 1;
        }
        if (component instanceof TileEntitySprinkler) {
            return 2;
        }
        return 0;
    }

    @Override
    protected final void writeChannelNBT(NBTTagCompound tag) {
        tag.func_74757_a("agri_power", this.powered);
    }

    @Override
    protected final void readChannelNBT(NBTTagCompound tag) {
        this.powered = tag.func_74767_n("agri_power");
    }

    public void updatePowerStatus() {
        boolean wasPowered = this.powered;
        boolean bl = this.powered = this.func_145831_w().func_175687_A(this.func_174877_v()) > 0;
        if (this.powered != wasPowered) {
            this.markForUpdate();
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public int acceptFluid(int inputHeight, int inputAmount, boolean partial, boolean simulate) {
        if (!this.powered) {
            return super.acceptFluid(inputHeight, inputAmount, partial, simulate);
        }
        return inputAmount;
    }

    @Override
    public void func_73660_a() {
        if (!this.powered) {
            super.func_73660_a();
        }
    }

    @Override
    public void addClientDebugInfo(Consumer<String> consumer) {
        super.addClientDebugInfo(consumer);
        consumer.accept("VALVE:");
        consumer.accept("  - State: " + (this.isPowered() ? "closed" : "open"));
    }

    @Override
    public void addServerDebugInfo(Consumer<String> consumer) {
        super.addServerDebugInfo(consumer);
        consumer.accept("VALVE:");
        consumer.accept("  - State: " + (this.isPowered() ? "closed" : "open"));
    }

    @Override
    public void addDisplayInfo(@Nonnull Consumer<String> information) {
        super.addDisplayInfo(information);
        String status = AgriCore.getTranslator().translate(this.powered ? "agricraft_tooltip.closed" : "agricraft_tooltip.open");
        information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.state") + ": " + status);
    }
}

