/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.block;

import cofh.core.block.BlockCore;
import cofh.core.block.ItemBlockCore;
import cofh.core.fluid.BlockFluidCore;
import cofh.core.render.IModelRegister;
import cofh.core.render.particle.EntityDropParticleFX;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockOreFluid
extends BlockCore
implements IInitializer,
IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    private static boolean enableBreakFluid = true;
    private static BlockFluidCore[] fluidBlocks = new BlockFluidCore[Type.values().length];
    private static ItemStack[] drops = new ItemStack[Type.values().length];
    public static ItemStack oreClathrateOilSand;
    public static ItemStack oreClathrateOilRedSand;
    public static ItemStack oreClathrateOilShale;
    public static ItemStack oreClathrateRedstone;
    public static ItemStack oreClathrateGlowstone;
    public static ItemStack oreClathrateEnder;

    public BlockOreFluid() {
        super(Material.field_151576_e, "thermalfoundation");
        this.func_149663_c("ore");
        this.func_149647_a(ThermalFoundation.tabCommon);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.CRUDE_OIL_SAND)));
        this.setHarvestLevel("pickaxe", 1);
        this.setHarvestLevel("shovel", 1, this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.CRUDE_OIL_SAND)));
        this.setHarvestLevel("shovel", 1, this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.CRUDE_OIL_RED_SAND)));
        this.setHarvestLevel("shovel", 1, this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.CRUDE_OIL_GRAVEL)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        int meta = ItemHelper.getItemDamage((ItemStack)stack);
        if (meta >= Type.values().length) {
            meta = 0;
        }
        return "tile.thermalfoundation.ore." + Type.values()[meta].func_176610_l() + ".name";
    }

    public EnumRarity getRarity(ItemStack stack) {
        int meta = ItemHelper.getItemDamage((ItemStack)stack);
        if (meta >= Type.values().length) {
            return EnumRarity.COMMON;
        }
        return Type.values()[meta].getRarity();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!enableBreakFluid) {
            return;
        }
        BlockPos north = pos.func_177982_a(0, 0, -1);
        BlockPos south = pos.func_177982_a(0, 0, 1);
        BlockPos west = pos.func_177982_a(-1, 0, 0);
        BlockPos east = pos.func_177982_a(1, 0, 0);
        if (world.func_175623_d(north)) {
            world.func_180501_a(north, fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()].func_176223_P().func_177226_a((IProperty)BlockFluidCore.LEVEL, (Comparable)Integer.valueOf(1)), 3);
        }
        if (world.func_175623_d(south)) {
            world.func_180501_a(south, fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()].func_176223_P().func_177226_a((IProperty)BlockFluidCore.LEVEL, (Comparable)Integer.valueOf(1)), 3);
        }
        if (world.func_175623_d(west)) {
            world.func_180501_a(west, fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()].func_176223_P().func_177226_a((IProperty)BlockFluidCore.LEVEL, (Comparable)Integer.valueOf(1)), 3);
        }
        if (world.func_175623_d(east)) {
            world.func_180501_a(east, fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()].func_176223_P().func_177226_a((IProperty)BlockFluidCore.LEVEL, (Comparable)Integer.valueOf(1)), 3);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        ItemStack stack = player.func_184614_ca();
        if (!enableBreakFluid || player.field_71075_bZ.field_75098_d || willHarvest && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        if (ServerHelper.isServerWorld((World)world)) {
            this.func_176208_a(world, pos, state, player);
        }
        return world.func_180501_a(new BlockPos((Vec3i)pos), fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()].func_176223_P().func_177226_a((IProperty)BlockFluidCore.LEVEL, (Comparable)Integer.valueOf(1)), 3);
    }

    public boolean func_149744_f(IBlockState state) {
        return this.func_176201_c(state) == Type.REDSTONE.getMetadata();
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ((Type)((Object)world.func_180495_p(pos).func_177229_b(VARIANT))).getFlammability();
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        int metadata = this.func_176201_c(state);
        if (metadata >= Type.values().length) {
            return 0;
        }
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        switch (Type.values()[metadata]) {
            case CRUDE_OIL_SAND: 
            case CRUDE_OIL_RED_SAND: 
            case CRUDE_OIL_GRAVEL: {
                return MathHelper.func_76136_a((Random)rand, (int)0, (int)2);
            }
            case REDSTONE: {
                return MathHelper.func_76136_a((Random)rand, (int)1, (int)5);
            }
            case GLOWSTONE: {
                return MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
            }
            case ENDER: {
                return MathHelper.func_76136_a((Random)rand, (int)3, (int)7);
            }
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ((Type)((Object)world.func_180495_p(pos).func_177229_b(VARIANT))).getFlammability() ? 15 : 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ((Type)((Object)world.func_180495_p(pos).func_177229_b(VARIANT))).getFlammability() ? 1 : 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_176201_c(state) == Type.REDSTONE.getMetadata() ? 7 : 0;
    }

    public int quantityDropped(IBlockState state, int fortune, Random rand) {
        return 1 + rand.nextInt(fortune + 1);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        return ((Type)((Object)state.func_177229_b(VARIANT))).getResistance();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)ItemHelper.cloneStack((ItemStack)BlockOreFluid.drops[this.func_180651_a(state)], (int)this.quantityDropped(state, fortune, world instanceof World ? ((World)world).field_73012_v : RANDOM)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double px = (float)pos.func_177958_n() + rand.nextFloat();
        double py = (double)pos.func_177956_o() - 0.05;
        double pz = (float)pos.func_177952_p() + rand.nextFloat();
        BlockFluidCore fluid = fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()];
        int density = fluid.getDensitySafe();
        int densityDir = fluid.getDensityDirSafe();
        if (density < 0) {
            py = (double)pos.func_177956_o() + 1.1;
        }
        if (rand.nextInt(20) == 0 && !world.isSideSolid(pos.func_177982_a(0, densityDir, 0), densityDir == -1 ? EnumFacing.UP : EnumFacing.DOWN) && !world.func_180495_p(pos.func_177982_a(0, densityDir, 0)).func_185904_a().func_76230_c()) {
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, fluid.getParticleRed(), fluid.getParticleGreen(), fluid.getParticleBlue(), densityDir);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)fx);
        }
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch (((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()) {
            case 0: 
            case 5: {
                return SoundType.field_185855_h;
            }
            case 1: {
                return SoundType.field_185849_b;
            }
        }
        return SoundType.field_185851_d;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name + "_fluid", "type=" + Type.values()[i].func_176610_l()));
        }
    }

    public boolean preInit() {
        this.setRegistryName("ore_fluid");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCore itemBlock = new ItemBlockCore((BlockCore)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        this.config();
        oreClathrateOilSand = new ItemStack((Block)this, 1, Type.CRUDE_OIL_SAND.getMetadata());
        oreClathrateOilShale = new ItemStack((Block)this, 1, Type.CRUDE_OIL_GRAVEL.getMetadata());
        oreClathrateRedstone = new ItemStack((Block)this, 1, Type.REDSTONE.getMetadata());
        oreClathrateGlowstone = new ItemStack((Block)this, 1, Type.GLOWSTONE.getMetadata());
        oreClathrateEnder = new ItemStack((Block)this, 1, Type.ENDER.getMetadata());
        oreClathrateOilRedSand = new ItemStack((Block)this, 1, Type.CRUDE_OIL_RED_SAND.getMetadata());
        ItemHelper.registerWithHandlers((String)"oreClathrateOilSand", (ItemStack)oreClathrateOilSand);
        ItemHelper.registerWithHandlers((String)"oreClathrateOilShale", (ItemStack)oreClathrateOilShale);
        ItemHelper.registerWithHandlers((String)"oreClathrateRedstone", (ItemStack)oreClathrateRedstone);
        ItemHelper.registerWithHandlers((String)"oreClathrateGlowstone", (ItemStack)oreClathrateGlowstone);
        ItemHelper.registerWithHandlers((String)"oreClathrateEnder", (ItemStack)oreClathrateEnder);
        ItemHelper.registerWithHandlers((String)"oreClathrateOilSand", (ItemStack)oreClathrateOilRedSand);
        ThermalFoundation.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        BlockOreFluid.fluidBlocks[Type.CRUDE_OIL_SAND.getMetadata()] = TFFluids.blockFluidCrudeOil;
        BlockOreFluid.fluidBlocks[Type.CRUDE_OIL_GRAVEL.getMetadata()] = TFFluids.blockFluidCrudeOil;
        BlockOreFluid.fluidBlocks[Type.REDSTONE.getMetadata()] = TFFluids.blockFluidRedstone;
        BlockOreFluid.fluidBlocks[Type.GLOWSTONE.getMetadata()] = TFFluids.blockFluidGlowstone;
        BlockOreFluid.fluidBlocks[Type.ENDER.getMetadata()] = TFFluids.blockFluidEnder;
        BlockOreFluid.fluidBlocks[Type.CRUDE_OIL_RED_SAND.getMetadata()] = TFFluids.blockFluidCrudeOil;
        BlockOreFluid.drops[Type.CRUDE_OIL_SAND.getMetadata()] = ItemMaterial.crystalCrudeOil;
        BlockOreFluid.drops[Type.CRUDE_OIL_GRAVEL.getMetadata()] = ItemMaterial.crystalCrudeOil;
        BlockOreFluid.drops[Type.REDSTONE.getMetadata()] = ItemMaterial.crystalRedstone;
        BlockOreFluid.drops[Type.GLOWSTONE.getMetadata()] = ItemMaterial.crystalGlowstone;
        BlockOreFluid.drops[Type.ENDER.getMetadata()] = ItemMaterial.crystalEnder;
        BlockOreFluid.drops[Type.CRUDE_OIL_RED_SAND.getMetadata()] = ItemMaterial.crystalCrudeOil;
        return true;
    }

    public void config() {
        String category = "Block.OreFluid";
        String comment = "If TRUE, Clathrates will create fluid when broken.";
        enableBreakFluid = ThermalFoundation.CONFIG.get(category, "FluidOnBreaking", enableBreakFluid, comment);
    }

    public static enum Type implements IStringSerializable
    {
        CRUDE_OIL_SAND(0, "crude_oil_sand", 0, 0.5f, 2.0f, true, EnumRarity.COMMON),
        CRUDE_OIL_GRAVEL(1, "crude_oil_gravel", 0, 0.6f, 2.5f, true, EnumRarity.COMMON),
        REDSTONE(2, "redstone", 7, 5.0f, 3.0f, false, EnumRarity.UNCOMMON),
        GLOWSTONE(3, "glowstone", 15, 0.4f, 2.0f, false, EnumRarity.UNCOMMON),
        ENDER(4, "ender", 3, 3.0f, 9.0f, false, EnumRarity.RARE),
        CRUDE_OIL_RED_SAND(5, "crude_oil_red_sand", 0, 0.5f, 2.0f, true, EnumRarity.COMMON);

        private final int metadata;
        private final String name;
        private final int light;
        private final float hardness;
        private final float resistance;
        private final boolean flammable;
        private final EnumRarity rarity;

        private Type(int metadata, String name, int light, float hardness, float resistance, boolean flammable, EnumRarity rarity) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
            this.hardness = hardness;
            this.resistance = resistance;
            this.flammable = flammable;
            this.rarity = rarity;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }

        public float getHardness() {
            return this.hardness;
        }

        public float getResistance() {
            return this.resistance;
        }

        public boolean getFlammability() {
            return this.flammable;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }
    }
}

