/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import pegbeard.dungeontactics.blocks.tileentities.DTBarrelTile;
import pegbeard.dungeontactics.handlers.DTCreativeTab;

public class DTBarrel
extends BlockContainer {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    public static final PropertyEnum<EnumType> PLACER = PropertyEnum.func_177709_a((String)"placer", EnumType.class);

    public DTBarrel(String name, Material material, float hardness, float resistance) {
        super(material);
        this.setRegistryName("dungeontactics", name);
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149647_a(DTCreativeTab.DT_BLOCKS_TAB);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PLACER, (Comparable)((Object)EnumType.WORLD_BARREL)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        if (placer != null) {
            world.func_180501_a(pos, state.func_177226_a(PLACER, (Comparable)((Object)EnumType.PLAYER_BARREL)), 2);
        }
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof DTBarrelTile) {
            ((DTBarrelTile)tileentity).func_190575_a(stack.func_82833_r());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        EnumType placer = EnumType.byMetadata(this.func_176201_c(state));
        if (placer == EnumType.WORLD_BARREL && world.field_73012_v.nextInt(4) == 0) {
            float yaw = world.field_73012_v.nextFloat() * 360.0f;
            EntityChicken chika = new EntityChicken(world);
            chika.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, yaw, 0.0f);
            chika.field_70759_as = chika.field_70177_z;
            chika.field_70761_aq = chika.field_70177_z;
            world.func_72838_d((Entity)chika);
        } else {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                world.func_175666_e(pos, (Block)this);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumType placer = (EnumType)((Object)state.func_177229_b(PLACER));
        if (placer == EnumType.PLAYER_BARREL) {
            if (world.field_72995_K) {
                return true;
            }
            ILockableContainer ilockablecontainer = this.getLockableContainer(world, pos);
            if (ilockablecontainer != null) {
                player.func_71007_a((IInventory)ilockablecontainer);
                player.func_71029_a(StatList.field_188063_ac);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ILockableContainer getLockableContainer(World world, BlockPos pos) {
        return this.getContainer(world, pos, false);
    }

    @Nullable
    public ILockableContainer getContainer(World world, BlockPos pos, boolean allowBlocking) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof DTBarrelTile)) {
            return null;
        }
        DTBarrelTile ilockablecontainer = (DTBarrelTile)tileentity;
        if (!allowBlocking && this.isBlocked(world, pos)) {
            return null;
        }
        return ilockablecontainer;
    }

    private boolean isBlocked(World world, BlockPos pos) {
        return this.isBelowSolidBlock(world, pos);
    }

    private boolean isBelowSolidBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)this.getLockableContainer(world, pos));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new DTBarrelTile();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PLACER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PLACER, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(PLACER))).getMetadata();
    }

    public static enum EnumType implements IStringSerializable
    {
        PLAYER_BARREL(0, "player", "default"),
        WORLD_BARREL(1, "world", "dungeon");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int meta, String name, String unlocalisedName) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalisedName;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType dtbarrel$enumtype;
                EnumType.META_LOOKUP[dtbarrel$enumtype.getMetadata()] = dtbarrel$enumtype = enumTypeArray[i];
            }
        }
    }
}

