/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.handlers;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockStem;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import pegbeard.dungeontactics.DungeonTactics;
import pegbeard.dungeontactics.blocks.DTFlower;
import pegbeard.dungeontactics.entities.DTEntityTowerGuardian;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTEffects;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.DTLoots;
import pegbeard.dungeontactics.handlers.IExtendedReach;
import pegbeard.dungeontactics.items.DTBattleAxe;
import pegbeard.dungeontactics.items.DTHammer;
import pegbeard.dungeontactics.items.DTShield;

public class DTEventHandler {
    protected static Random eventRand;

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        IBlockState state = event.getWorld().func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block != null && DTConfigHandler.configuration.get("1-Feature", "Quick Ladder Climb", true).getBoolean(true) && player.func_184614_ca().func_190926_b() && block instanceof BlockLadder) {
            int height = 64;
            String dir = null;
            BlockPos newPos = pos;
            if (event.getWorld().func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLadder) {
                dir = "up";
            } else if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockLadder) {
                dir = "down";
            }
            if (dir != null) {
                for (int i = 0; i < height; ++i) {
                    if (dir == "up" && event.getWorld().func_180495_p(pos.func_177981_b(i)).func_177230_c() instanceof BlockLadder) {
                        newPos = new BlockPos((Vec3i)pos.func_177981_b(i).func_177977_b());
                        continue;
                    }
                    if (dir != "down" || !(event.getWorld().func_180495_p(pos.func_177979_c(i)).func_177230_c() instanceof BlockLadder)) break;
                    newPos = new BlockPos((Vec3i)pos.func_177979_c(i));
                }
            }
            if (newPos != pos) {
                player.func_70634_a((double)((float)newPos.func_177958_n() + 0.5f), (double)((float)newPos.func_177956_o() + 0.5f), (double)((float)newPos.func_177952_p() + 0.5f));
                player.func_184185_a(SoundEvents.field_187653_cW, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityChicken chicken;
        if (event.getEntity().func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemShears && target instanceof EntityChicken && !(chicken = (EntityChicken)target).func_70631_g_() && chicken.field_70172_ad <= 0) {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            chicken.func_145778_a(Items.field_151008_G, 1 + fortune, chicken.func_70047_e());
            if (!player.func_184812_l_()) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                chicken.func_70097_a(DamageSource.field_76377_j, 1.0f);
            }
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151057_cb && player.func_70005_c_().equals("PegBeard")) {
            if (target instanceof EntityParrot) {
                EntityParrot parrot = (EntityParrot)target;
                if (!parrot.field_70128_L && !parrot.func_70631_g_() && "Pigeon".equals(stack.func_82833_r())) {
                    player.func_191521_c(new ItemStack(DTItems.PEG_HAMMER));
                }
            }
            if (target instanceof EntityPig) {
                EntityPig pig = (EntityPig)target;
                if (!pig.field_70128_L && !pig.func_70631_g_() && "Battle Pig".equals(stack.func_82833_r())) {
                    player.func_191521_c(new ItemStack(DTItems.PEG_HAMMER));
                }
            }
            if (target instanceof EntityChicken) {
                chicken = (EntityChicken)target;
                if (!chicken.field_70128_L && !chicken.func_70631_g_() && "Sebastian".equals(stack.func_82833_r())) {
                    player.func_191521_c(new ItemStack(DTItems.PEG_HAMMER));
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).func_70644_a(MobEffects.field_76441_p) && DTConfigHandler.configuration.get("1-Feature", "Invisiblity Removes Armour", true).getBoolean(true) && !player.func_130014_f_().field_72995_K) {
            for (int a = 0; a < 4; ++a) {
                ItemStack armour = ItemStack.field_190927_a;
                if (a == 0 && !player.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
                    armour = player.func_184582_a(EntityEquipmentSlot.HEAD);
                }
                if (a == 1 && !player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b()) {
                    armour = player.func_184582_a(EntityEquipmentSlot.CHEST);
                }
                if (a == 2 && !player.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b()) {
                    armour = player.func_184582_a(EntityEquipmentSlot.LEGS);
                }
                if (a == 3 && !player.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b()) {
                    armour = player.func_184582_a(EntityEquipmentSlot.FEET);
                }
                if (armour.func_190926_b() || !player.field_71071_by.func_70441_a(armour.func_77946_l())) continue;
                player.field_71071_by.func_184437_d(armour);
            }
        }
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        EntityLivingBase attacker;
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        if (source.func_76346_g() instanceof EntityLivingBase && !(attacker = (EntityLivingBase)source.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && attacker.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IExtendedReach) {
            double reach = ((IExtendedReach)attacker.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getReach();
            if (attacker.func_70068_e((Entity)event.getEntityLiving()) > reach * reach) {
                event.setCanceled(true);
                return;
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack activeItemStack = player.func_184607_cu();
            if (damage > 0.0f && activeItemStack != null && activeItemStack.func_77973_b() instanceof DTShield) {
                if (!(source != DamageSource.field_82728_o && source != DamageSource.field_82729_p || player.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b())) {
                    player.func_184582_a(EntityEquipmentSlot.HEAD).func_77972_a((int)(damage * 4.0f + player.field_70170_p.field_73012_v.nextFloat() * damage * 2.0f), (EntityLivingBase)player);
                    damage *= 0.75f;
                }
                int i = 1 + MathHelper.func_76141_d((float)damage);
                activeItemStack.func_77972_a(i, (EntityLivingBase)player);
                if (activeItemStack.func_190926_b()) {
                    EnumHand enumhand = player.func_184600_cs();
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)activeItemStack, (EnumHand)enumhand);
                    if (enumhand == EnumHand.MAIN_HAND) {
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    } else {
                        player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                    }
                    activeItemStack = ItemStack.field_190927_a;
                    player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() != null) {
            EntityLivingBase attacker;
            if (DTConfigHandler.configuration.get("1-Feature", "Chained Creeper Explosions", true).getBoolean(true) && (event.getEntityLiving().func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL || event.getEntityLiving().func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) && event.getSource().func_94541_c() && event.getEntityLiving() instanceof EntityCreeper && !event.getEntityLiving().field_70128_L) {
                event.setAmount(0.0f);
                EntityCreeper creeper = (EntityCreeper)event.getEntityLiving();
                creeper.func_146079_cb();
            }
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                ItemStack stack = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
                if (event.getSource() != DamageSource.field_76380_i) {
                    ItemStack phylactery;
                    int k;
                    float a = event.getAmount();
                    float damage = CombatRules.func_189427_a((float)a, (float)player.func_70658_aO(), (float)((float)player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
                    if (player.func_70644_a(MobEffects.field_76429_m)) {
                        int i = (player.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
                        int j = 25 - i;
                        float f = damage * (float)j;
                        damage = f / 25.0f;
                    }
                    if (damage > 0.0f && (k = EnchantmentHelper.func_77508_a((Iterable)player.func_184193_aE(), (DamageSource)event.getSource())) > 0) {
                        damage = CombatRules.func_188401_b((float)damage, (float)k);
                    }
                    if (damage >= event.getEntityLiving().func_110143_aJ() && player.field_71071_by.func_70431_c(phylactery = new ItemStack(DTItems.PHYLACTERY)) && player.field_71068_ca >= 5) {
                        event.setAmount(0.0f);
                        player.func_82242_a(-5);
                        player.func_70691_i(player.func_110138_aP());
                        player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 60, 0));
                        player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187855_gD, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                            if (itemstack.func_190926_b() || itemstack.func_77973_b() != DTItems.PHYLACTERY) continue;
                            player.field_71071_by.func_70304_b(i);
                            break;
                        }
                    }
                    if (!stack.func_190926_b() && stack.func_77973_b() == DTItems.PEG_HAMMER && event.getSource().func_94541_c()) {
                        event.setCanceled(true);
                    }
                }
            }
            if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase && (attacker = (EntityLivingBase)event.getSource().func_76346_g()) != null && event.getSource().func_76346_g() == attacker && !attacker.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                int feather;
                int fade;
                int ailment;
                int tangle;
                int cinder;
                int bark;
                int bramble;
                int sanguine;
                int runed;
                int lifestealer;
                boolean berserker;
                EntityLivingBase target = event.getEntityLiving();
                ItemStack weapon = attacker.func_184586_b(EnumHand.MAIN_HAND);
                boolean bl = berserker = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.BERSERK, (ItemStack)weapon) > 0;
                if (berserker) {
                    float d = 6.0f;
                    float ac = attacker.func_70658_aO();
                    if (ac > 0.0f) {
                        int i = 0;
                        while ((float)i < ac) {
                            d -= 0.5f;
                            ++i;
                        }
                        if (d < -1.0f) {
                            d = -1.0f;
                        }
                    }
                    if (d >= -1.0f) {
                        d = event.getAmount() + d;
                    }
                    event.setAmount(d);
                }
                if ((lifestealer = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.LIFESTEAL, (ItemStack)weapon)) > 0) {
                    int i = 4 - lifestealer;
                    if (i < 1) {
                        i = 1;
                    }
                    attacker.func_70691_i(event.getAmount() / (float)i);
                }
                if ((runed = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.RUNED, (ItemStack)weapon)) > 0) {
                    float ed = event.getAmount();
                    float pd = 0.0f;
                    float md = 0.0f;
                    int r = 4;
                    if (runed == 2) {
                        r = 2;
                    }
                    if (runed == 3) {
                        pd = ed / (float)r;
                        md = ed - pd;
                    } else {
                        md = ed / (float)r;
                        pd = ed - md;
                    }
                    event.setAmount(pd);
                    if (target.func_110143_aJ() > 0.0f && !target.field_70128_L && target != null) {
                        target.field_70172_ad = 0;
                        target.func_70097_a(DamageSource.field_76376_m, md);
                    }
                }
                if ((sanguine = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONSANGUINE, (ItemStack)weapon)) > 0) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 10, sanguine));
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)weapon);
                    if (enchantments.containsKey(DTEffects.POISONSANGUINE)) {
                        if (sanguine - 1 == 0) {
                            enchantments.remove(DTEffects.POISONSANGUINE);
                        } else {
                            enchantments.replace(DTEffects.POISONSANGUINE, sanguine - 1);
                        }
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)weapon);
                    }
                }
                if ((bramble = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONBRAMBLE, (ItemStack)weapon)) > 0) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 10, bramble));
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)weapon);
                    if (enchantments.containsKey(DTEffects.POISONBRAMBLE)) {
                        if (bramble - 1 == 0) {
                            enchantments.remove(DTEffects.POISONBRAMBLE);
                        } else {
                            enchantments.replace(DTEffects.POISONBRAMBLE, bramble - 1);
                        }
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)weapon);
                    }
                }
                if ((bark = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONBARK, (ItemStack)weapon)) > 0) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 60, bark));
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)weapon);
                    if (enchantments.containsKey(DTEffects.POISONBARK)) {
                        if (bark - 1 == 0) {
                            enchantments.remove(DTEffects.POISONBARK);
                        } else {
                            enchantments.replace(DTEffects.POISONBARK, bark - 1);
                        }
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)weapon);
                    }
                }
                if ((cinder = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONCINDER, (ItemStack)weapon)) > 0) {
                    target.func_70015_d(6);
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)weapon);
                    if (enchantments.containsKey(DTEffects.POISONCINDER)) {
                        if (cinder - 1 == 0) {
                            enchantments.remove(DTEffects.POISONCINDER);
                        } else {
                            enchantments.replace(DTEffects.POISONCINDER, cinder - 1);
                        }
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)weapon);
                    }
                }
                if ((tangle = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONTANGLE, (ItemStack)weapon)) > 0) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, tangle));
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)weapon);
                    if (enchantments.containsKey(DTEffects.POISONTANGLE)) {
                        if (tangle - 1 == 0) {
                            enchantments.remove(DTEffects.POISONTANGLE);
                        } else {
                            enchantments.replace(DTEffects.POISONTANGLE, tangle - 1);
                        }
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)weapon);
                    }
                }
                if ((ailment = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONAILMENT, (ItemStack)weapon)) > 0) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60, ailment));
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)weapon);
                    if (enchantments.containsKey(DTEffects.POISONAILMENT)) {
                        if (ailment - 1 == 0) {
                            enchantments.remove(DTEffects.POISONAILMENT);
                        } else {
                            enchantments.replace(DTEffects.POISONAILMENT, ailment - 1);
                        }
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)weapon);
                    }
                }
                if ((fade = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONFADE, (ItemStack)weapon)) > 0 && !target.field_70170_p.field_72995_K) {
                    Map enchantments;
                    double d0 = target.field_70165_t;
                    double d1 = target.field_70163_u;
                    double d2 = target.field_70161_v;
                    for (int i = 0; i < 16; ++i) {
                        double d3 = target.field_70165_t + (target.func_70681_au().nextDouble() - 0.5) * 16.0;
                        double d4 = MathHelper.func_151237_a((double)(target.field_70163_u + (double)(target.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(target.field_70170_p.func_72940_L() - 1));
                        double d5 = target.field_70161_v + (target.func_70681_au().nextDouble() - 0.5) * 16.0;
                        if (target.func_184218_aH()) {
                            target.func_184210_p();
                        }
                        if (target.func_184207_aI()) {
                            target.func_184226_ay();
                        }
                        if (!target.func_184595_k(d3, d4, d5)) continue;
                        target.field_70170_p.func_184148_a((EntityPlayer)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        target.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                        break;
                    }
                    if ((enchantments = EnchantmentHelper.func_82781_a((ItemStack)weapon)).containsKey(DTEffects.POISONFADE)) {
                        if (fade - 1 == 0) {
                            enchantments.remove(DTEffects.POISONFADE);
                        } else {
                            enchantments.replace(DTEffects.POISONFADE, fade - 1);
                        }
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)weapon);
                    }
                }
                if ((feather = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONFEATHER, (ItemStack)weapon)) > 0) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 60, feather));
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)weapon);
                    if (enchantments.containsKey(DTEffects.POISONFEATHER)) {
                        if (feather - 1 == 0) {
                            enchantments.remove(DTEffects.POISONFEATHER);
                        } else {
                            enchantments.replace(DTEffects.POISONFEATHER, feather - 1);
                        }
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)weapon);
                    }
                }
            }
            if (event.getEntityLiving().func_70660_b(DTEffects.CRYO) != null) {
                float amp = event.getEntityLiving().func_70660_b(DTEffects.CRYO).func_76458_c();
                float damage = event.getAmount();
                if (amp > 0.0f && damage > 0.0f && (damage *= 1.0f + amp / 2.0f) > 0.0f) {
                    event.setAmount(damage);
                }
            }
        }
    }

    @SubscribeEvent
    public void repairAtAnvil(AnvilRepairEvent event) {
        Map enchantments;
        if (!event.getItemResult().func_190926_b() && (enchantments = EnchantmentHelper.func_82781_a((ItemStack)event.getItemResult())).containsKey(DTEffects.DUCTTAPED)) {
            enchantments.remove(DTEffects.DUCTTAPED);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)event.getItemResult());
        }
    }

    @SubscribeEvent
    public void onItemPickUp(EntityItemPickupEvent event) {
        if (event.getItem().func_92059_d().func_77973_b() == DTItems.HEART_DROP) {
            EntityPlayer player = event.getEntityPlayer();
            int count = event.getItem().func_92059_d().func_190916_E();
            player.func_130014_f_().func_184133_a((EntityPlayer)null, player.func_180425_c(), SoundEvents.field_187734_u, SoundCategory.PLAYERS, 0.2f, 1.0f / (eventRand.nextFloat() * 0.4f + 1.2f));
            event.setCanceled(true);
            block0: for (int i = 0; i < count; ++i) {
                if (!player.func_130014_f_().field_72995_K && player.field_71071_by.func_70431_c(new ItemStack(Items.field_151069_bo))) {
                    for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
                        ItemStack itemstack = player.field_71071_by.func_70301_a(j);
                        if (itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151069_bo) continue;
                        player.field_71071_by.func_70298_a(j, 1);
                        player.func_70099_a(new ItemStack(DTItems.HEART_JAR), 1.0f);
                        continue block0;
                    }
                    continue;
                }
                event.getEntityPlayer().func_70691_i(2.0f);
            }
            event.getItem().func_70106_y();
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (DTConfigHandler.configuration.get("1-Feature", "Quick Change Armour", true).getBoolean(true)) {
            EntityPlayer player = event.getEntityPlayer();
            if (!player.func_130014_f_().field_72995_K) {
                EntityEquipmentSlot slot;
                ItemStack stack2;
                EnumHand hand = event.getHand();
                ItemStack stack1 = event.getItemStack();
                if ((stack1.func_77973_b() instanceof ItemArmor || stack1.func_77973_b() instanceof ISpecialArmor || EntityLiving.func_184640_d((ItemStack)player.func_184586_b(hand)) == EntityEquipmentSlot.HEAD || EntityLiving.func_184640_d((ItemStack)player.func_184586_b(hand)) == EntityEquipmentSlot.CHEST || EntityLiving.func_184640_d((ItemStack)player.func_184586_b(hand)) == EntityEquipmentSlot.LEGS || EntityLiving.func_184640_d((ItemStack)player.func_184586_b(hand)) == EntityEquipmentSlot.FEET) && !(stack2 = player.func_184582_a(slot = EntityLiving.func_184640_d((ItemStack)stack1))).func_190926_b()) {
                    player.func_184201_a(slot, stack1.func_77946_l());
                    player.func_184611_a(hand, stack2.func_77946_l());
                }
            }
        }
    }

    @SubscribeEvent
    public void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        ItemStack item;
        if ((!event.getEntityLiving().func_130014_f_().func_82736_K().func_82766_b("naturalRegeneration") || event.getEntityLiving().func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL || event.getEntityLiving().func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) && (item = event.getItem()).func_77973_b() instanceof ItemFood) {
            float h = 0.3f * (float)((ItemFood)item.func_77973_b()).func_150905_g(event.getItem());
            event.getEntityLiving().func_70691_i(h);
        }
    }

    @SubscribeEvent
    public void onUseBonemeal(BonemealEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getBlock();
        Block block = state.func_177230_c();
        if (!event.getWorld().field_72995_K) {
            int age;
            Block flower;
            BlockPos newPos;
            int l;
            if (block instanceof DTFlower) {
                if (eventRand.nextInt(5) == 0) {
                    ItemStack flowerStack = new ItemStack(block.func_185473_a(world, pos, state).func_77973_b());
                    EntityItem flower2 = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, flowerStack);
                    world.func_72838_d((Entity)flower2);
                    event.setResult(Event.Result.ALLOW);
                }
                for (l = 0; l < 32; ++l) {
                    newPos = pos.func_177982_a(eventRand.nextInt(5) - eventRand.nextInt(5), eventRand.nextInt(3) - eventRand.nextInt(3), eventRand.nextInt(5) - eventRand.nextInt(5));
                    flower = this.getFlower();
                    if (!world.func_175623_d(newPos) || newPos.func_177956_o() >= 255 || !((DTFlower)flower).func_180671_f(world, newPos, flower.func_176223_P())) continue;
                    world.func_180501_a(newPos, flower.func_176223_P(), 2);
                }
                event.setResult(Event.Result.ALLOW);
            }
            if (block == Blocks.field_150341_Y) {
                for (l = 0; l < 32; ++l) {
                    newPos = pos.func_177982_a(eventRand.nextInt(5) - eventRand.nextInt(5), eventRand.nextInt(3) - eventRand.nextInt(3), eventRand.nextInt(5) - eventRand.nextInt(5));
                    flower = this.getFlower();
                    if (!world.func_175623_d(newPos) || newPos.func_177956_o() >= 255 || !((DTFlower)flower).func_180671_f(world, newPos, flower.func_176223_P())) continue;
                    world.func_180501_a(newPos, flower.func_176223_P(), 2);
                }
                event.setResult(Event.Result.ALLOW);
            }
            if (block == Blocks.field_150391_bh) {
                for (l = 0; l < 32; ++l) {
                    BlockBush shroom;
                    newPos = pos.func_177982_a(eventRand.nextInt(5) - eventRand.nextInt(5), eventRand.nextInt(3) - eventRand.nextInt(3), eventRand.nextInt(5) - eventRand.nextInt(5));
                    BlockBush blockBush = shroom = eventRand.nextInt(2) == 0 ? Blocks.field_150337_Q : Blocks.field_150338_P;
                    if (!world.func_175623_d(newPos) || !(world.func_180495_p(newPos.func_177977_b()) instanceof BlockMycelium) || newPos.func_177956_o() >= 255 || !shroom.func_180671_f(world, newPos, shroom.func_176223_P())) continue;
                    world.func_180501_a(newPos, shroom.func_176223_P(), 2);
                }
                event.setResult(Event.Result.ALLOW);
            }
            if (block == Blocks.field_150434_aF) {
                DTEventHandler.growCactusOrSugarcane(world, pos, state, block, BlockCactus.field_176587_a, 8);
                event.setResult(Event.Result.ALLOW);
            }
            if (block == Blocks.field_150436_aH) {
                DTEventHandler.growCactusOrSugarcane(world, pos, state, block, BlockReed.field_176355_a, 8);
                event.setResult(Event.Result.ALLOW);
            }
            if ((block == Blocks.field_150394_bc || block == Blocks.field_150393_bb) && (Integer)state.func_177229_b((IProperty)BlockStem.field_176484_a) == 7) {
                block.func_180650_b(world, pos, state, eventRand);
                event.setResult(Event.Result.ALLOW);
            }
            if (block == Blocks.field_150388_bm && (age = ((Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a)).intValue()) < 3) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(age + 1)), 2);
                event.setResult(Event.Result.ALLOW);
            }
            if (block == Blocks.field_185766_cS && (age = ((Integer)state.func_177229_b((IProperty)BlockChorusFlower.field_185607_a)).intValue()) < 5) {
                block.func_180650_b(world, event.getPos(), state, eventRand);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    protected static void growCactusOrSugarcane(World world, BlockPos pos, IBlockState state, Block block, PropertyInteger ageProperty, int stages) {
        while (world.func_180495_p(pos.func_177984_a()).func_177230_c() == block) {
            pos = pos.func_177984_a();
        }
        state = state.func_177226_a((IProperty)ageProperty, (Comparable)Integer.valueOf(Math.min((Integer)state.func_177229_b((IProperty)ageProperty) + stages - 1, 15)));
        world.func_180501_a(pos, state, 4);
        block.func_180650_b(world, pos, state, eventRand);
    }

    public Block getFlower() {
        switch (eventRand.nextInt(9)) {
            case 0: {
                return DTBlocks.FLOWER_SANGUINE;
            }
            case 1: {
                return DTBlocks.FLOWER_BRAMBLE;
            }
            case 2: {
                return DTBlocks.FLOWER_BARK;
            }
            case 3: {
                return DTBlocks.FLOWER_CINDER;
            }
            case 4: {
                return DTBlocks.FLOWER_TANGLE;
            }
            case 5: {
                return DTBlocks.FLOWER_AILMENT;
            }
            case 6: {
                return DTBlocks.FLOWER_FADE;
            }
            case 7: {
                return DTBlocks.FLOWER_FEATHER;
            }
            case 8: {
                return DTBlocks.FLOWER_XP;
            }
        }
        return DTBlocks.FLOWER_BRAMBLE;
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        boolean config = DTConfigHandler.configuration.get("1-Feature", "Give Weapons to Mobs", true).getBoolean(true);
        if (config && !(event.getEntity() instanceof DTEntityTowerGuardian)) {
            eventRand = new Random();
            int i = eventRand.nextInt(100);
            if (event.getEntity() instanceof EntityZombie && !(event.getEntity() instanceof EntityPigZombie)) {
                EntityZombie zombie = (EntityZombie)event.getEntity();
                if (zombie.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151040_l) {
                    if (i < 30) {
                        zombie.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.IRON_HAMMER));
                    }
                    if (i > 30 && i < 50) {
                        zombie.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.IRON_BATTLEAXE));
                    }
                }
                if (i > 50 && i < 60) {
                    zombie.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(DTItems.IRON_SHIELD));
                }
            }
            if (event.getEntity() instanceof AbstractSkeleton) {
                AbstractSkeleton skeleton = (AbstractSkeleton)event.getEntity();
                if (skeleton instanceof EntitySkeleton || skeleton instanceof EntityStray && skeleton.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151031_f) {
                    if (i < 20) {
                        if (i < 10) {
                            skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.IRON_KNIFE));
                        } else {
                            skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.IRON_GLAIVE));
                        }
                    }
                    if (i > 20 && i < 30) {
                        skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.IRON_CUTLASS));
                        if (i > 20 && i < 24) {
                            skeleton.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(DTItems.STONE_SHIELD));
                        }
                    }
                }
                if (skeleton instanceof EntityWitherSkeleton && skeleton.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151052_q) {
                    if (i < 40) {
                        if (i < 20) {
                            skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.STONE_GLAIVE));
                        } else {
                            skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.STONE_BATTLEAXE));
                        }
                    }
                    if (i > 40 && i < 50) {
                        skeleton.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(DTItems.STONE_SHIELD));
                    }
                }
            }
            if (event.getEntity() instanceof EntityPigZombie) {
                EntityPigZombie pigman = (EntityPigZombie)event.getEntity();
                if (pigman.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151010_B) {
                    if (i < 25) {
                        pigman.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.GOLDEN_HAMMER));
                    }
                    if (i > 25 && i < 40) {
                        pigman.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(DTItems.GOLDEN_CUTLASS));
                    }
                }
                if (i > 35 && i < 45) {
                    pigman.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(DTItems.GOLDEN_SHIELD));
                }
            }
        }
    }

    public ItemStack getLoot(ResourceLocation pool, EntityLivingBase entity) {
        LootContext.Builder build = new LootContext.Builder((WorldServer)entity.func_130014_f_());
        for (ItemStack stack : entity.func_130014_f_().func_184146_ak().func_186521_a(pool).func_186462_a(entity.func_130014_f_().field_73012_v, build.func_186471_a())) {
            if (stack.func_190926_b()) continue;
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EnumDifficulty difficulty = event.getEntityLiving().func_130014_f_().func_175659_aa();
        boolean canDrop = event.getEntityLiving().func_130014_f_().func_82736_K().func_82766_b("doMobLoot");
        int heartConfig = DTConfigHandler.configuration.get("1-Feature", "Heart Drops", 20).getInt(20);
        int lootbagsConfig = DTConfigHandler.configuration.get("1-Feature", "Loot Bag Drops", 10).getInt(10);
        int bonecharmsConfig = DTConfigHandler.configuration.get("1-Feature", "Bone Charm Drops", 10).getInt(10);
        List list = event.getEntityLiving().func_130014_f_().func_175674_a((Entity)event.getEntityLiving(), event.getEntityLiving().func_174813_aQ(), EntitySelectors.func_188442_a((Entity)event.getEntityLiving()));
        int cram = event.getEntityLiving().func_130014_f_().func_82736_K().func_180263_c("maxEntityCramming");
        eventRand = new Random();
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && canDrop && (float)list.size() < (float)cram / 1.5f && !(event.getEntityLiving() instanceof DTEntityTowerGuardian) && event.isRecentlyHit()) {
            ItemStack loot;
            if (event.getEntityLiving() instanceof EntityLivingBase) {
                EntityLivingBase attacker;
                ItemStack weapon;
                if (event.getSource().func_76346_g() instanceof EntityLivingBase && !(weapon = (attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_184582_a(EntityEquipmentSlot.MAINHAND)).func_190926_b()) {
                    ItemStack skull = ItemStack.field_190927_a;
                    if (weapon.func_77973_b() instanceof ItemAxe) {
                        skull = this.getSkullDrop(event.getEntityLiving(), 5);
                    }
                    if (weapon.func_77973_b() instanceof DTBattleAxe) {
                        skull = this.getSkullDrop(event.getEntityLiving(), 3);
                    }
                    if (!skull.func_190926_b()) {
                        event.getEntityLiving().func_70099_a(skull, event.getEntityLiving().func_70047_e());
                    }
                }
                if (eventRand.nextInt(100) < heartConfig / 2) {
                    if (difficulty != EnumDifficulty.EASY) {
                        event.getEntityLiving().func_70099_a(new ItemStack(DTItems.HEART_DROP), 1.0f);
                    }
                }
                if (DTConfigHandler.configuration.get("1-Feature", "Seasonal Events", true).getBoolean(true)) {
                    ItemStack bag = ItemStack.field_190927_a;
                    if (DungeonTactics.samhain) {
                        bag = new ItemStack(DTItems.BAG_SAMHAIN);
                    }
                    if (DungeonTactics.solstice) {
                        bag = new ItemStack(DTItems.BAG_SOLSTICE);
                    }
                    if (!bag.func_190926_b() && eventRand.nextInt(100) < lootbagsConfig * 2) {
                        event.getEntityLiving().func_70099_a(bag, 1.0f);
                    }
                }
            }
            if (event.getEntityLiving() instanceof EntityMob) {
                if (eventRand.nextInt(100) < heartConfig) {
                    if (difficulty != EnumDifficulty.EASY) {
                        event.getEntityLiving().func_70099_a(new ItemStack(DTItems.HEART_DROP), (float)(eventRand.nextInt(1) + 1));
                    }
                }
                if (eventRand.nextInt(100) < lootbagsConfig && !(loot = this.getLoot(DTLoots.BAGS_LIST, event.getEntityLiving())).func_190926_b()) {
                    event.getEntityLiving().func_70099_a(loot, 1.0f);
                }
            }
            if (event.getEntityLiving() instanceof EntityWither || event.getEntityLiving() instanceof EntityDragon || event.getEntityLiving() instanceof EntityGuardian) {
                if (heartConfig != 0) {
                    event.getEntityLiving().func_70099_a(new ItemStack(DTItems.HEART_DROP), (float)(3 + eventRand.nextInt(3)));
                    event.getEntityLiving().func_70099_a(new ItemStack(DTItems.HEART_JAR), (float)eventRand.nextInt(3));
                    event.getEntityLiving().func_70099_a(new ItemStack(DTItems.HEART_GOLDEN), (float)eventRand.nextInt(2));
                }
                if (eventRand.nextInt(100) < lootbagsConfig * 2 && !(loot = this.getLoot(DTLoots.BAGS_LIST, event.getEntityLiving())).func_190926_b()) {
                    event.getEntityLiving().func_70099_a(loot, 1.0f);
                }
                if (eventRand.nextInt(100) < bonecharmsConfig && !(loot = this.getLoot(DTLoots.TOMES_LIST, event.getEntityLiving())).func_190926_b()) {
                    event.getEntityLiving().func_70099_a(loot, 1.0f);
                }
                if (event.getEntityLiving() instanceof EntityWither) {
                    if (eventRand.nextInt(100) < bonecharmsConfig && !(loot = this.getLoot(DTLoots.CHARMS_LIST, event.getEntityLiving())).func_190926_b()) {
                        event.getEntityLiving().func_70099_a(loot, 1.0f);
                    }
                    if (eventRand.nextInt(100) < bonecharmsConfig) {
                        event.getEntityLiving().func_70099_a(new ItemStack(DTItems.PHYLACTERY), 1.0f);
                    }
                }
            }
        }
    }

    public ItemStack getSkullDrop(EntityLivingBase entity, int chance) {
        if (eventRand.nextInt(chance) == 0) {
            if (entity instanceof EntitySkeleton) {
                return new ItemStack(Items.field_151144_bL, 1, 0);
            }
            if (entity instanceof EntityWitherSkeleton) {
                return new ItemStack(Items.field_151144_bL, 1, 1);
            }
            if (entity instanceof EntityZombie) {
                return new ItemStack(Items.field_151144_bL, 1, 2);
            }
            if (entity instanceof EntityCreeper) {
                return new ItemStack(Items.field_151144_bL, 1, 4);
            }
            if (entity instanceof EntityPlayer) {
                ItemStack skull = new ItemStack(Items.field_151144_bL, 1, 3);
                NBTTagCompound owner = new NBTTagCompound();
                owner.func_74778_a("SkullOwner", ((EntityPlayer)entity).getDisplayNameString());
                skull.func_77982_d(owner);
                return skull;
            }
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        IBlockState state;
        if (event.getPlayer() != null && (state = event.getState()).func_177230_c() == Blocks.field_150414_aQ) {
            BlockCake cake = (BlockCake)state.func_177230_c();
            if ((Integer)event.getState().func_177229_b((IProperty)BlockCake.field_176589_a) == 0) {
                EntityItem cakeDrop = new EntityItem(event.getWorld(), (double)((float)event.getPos().func_177958_n() + 0.5f), (double)((float)event.getPos().func_177956_o() + 0.5f), (double)((float)event.getPos().func_177952_p() + 0.5f), new ItemStack(Items.field_151105_aU, 1));
                event.getWorld().func_72838_d((Entity)cakeDrop);
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        int count;
        ItemStack tool = ItemStack.field_190927_a;
        if (event.isSilkTouching()) {
            return;
        }
        if (event.getDrops().isEmpty()) {
            return;
        }
        if (DTConfigHandler.configuration.get("1-Feature", "Ore Clusters", true).getBoolean(true)) {
            count = this.randomCount(event.getDrops().size(), event.getFortuneLevel(), event.getWorld());
            if (event.getState().func_177230_c().func_180660_a(event.getState().func_177230_c().func_176223_P(), eventRand, 0) == ItemBlock.func_150898_a((Block)event.getState().func_177230_c()) && !event.getDrops().isEmpty()) {
                ListIterator<ItemStack> dropList = event.getDrops().listIterator();
                while (dropList.hasNext()) {
                    int i;
                    ItemStack drop = (ItemStack)dropList.next();
                    if (drop.func_190926_b()) continue;
                    ItemStack cluster = ItemStack.field_190927_a;
                    NonNullList ironList = OreDictionary.getOres((String)"oreIron");
                    NonNullList goldList = OreDictionary.getOres((String)"oreGold");
                    NonNullList tinList = OreDictionary.getOres((String)"oreTin");
                    NonNullList copperList = OreDictionary.getOres((String)"oreCopper");
                    NonNullList aluminiumList = OreDictionary.getOres((String)"oreAluminium");
                    NonNullList aluminumList = OreDictionary.getOres((String)"oreAluminum");
                    NonNullList bauxiteList = OreDictionary.getOres((String)"oreBauxite");
                    NonNullList nickelList = OreDictionary.getOres((String)"oreNickel");
                    NonNullList leadList = OreDictionary.getOres((String)"oreLead");
                    NonNullList silverList = OreDictionary.getOres((String)"oreSilver");
                    NonNullList platinumList = OreDictionary.getOres((String)"orePlatinum");
                    NonNullList sheldoniteList = OreDictionary.getOres((String)"oreSheldonite");
                    NonNullList tungstenList = OreDictionary.getOres((String)"oreTungsten");
                    NonNullList titaniumList = OreDictionary.getOres((String)"oreTitanium");
                    if (!ironList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < ironList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)ironList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_IRON);
                        }
                    }
                    if (!goldList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < goldList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)goldList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_GOLD);
                        }
                    }
                    if (!tinList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < tinList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)tinList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_TIN);
                        }
                    }
                    if (!copperList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < copperList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)copperList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_COPPER);
                        }
                    }
                    if (!aluminiumList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < aluminiumList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)aluminiumList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_ALUMINIUM);
                        }
                    }
                    if (!aluminumList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < aluminumList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)aluminumList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_ALUMINIUM);
                        }
                    }
                    if (!bauxiteList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < bauxiteList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)bauxiteList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_ALUMINIUM);
                        }
                    }
                    if (!nickelList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < nickelList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)nickelList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_NICKEL);
                        }
                    }
                    if (!leadList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < leadList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)leadList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_LEAD);
                        }
                    }
                    if (!silverList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < silverList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)silverList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_SILVER);
                        }
                    }
                    if (!platinumList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < platinumList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)platinumList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_PLATINUM);
                        }
                    }
                    if (!sheldoniteList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < sheldoniteList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)sheldoniteList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_PLATINUM);
                        }
                    }
                    if (!tungstenList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < tungstenList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)tungstenList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_TUNGSTEN);
                        }
                    }
                    if (!titaniumList.isEmpty() && cluster.func_190926_b()) {
                        for (i = 0; i < titaniumList.size(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)titaniumList.get(i)), (ItemStack)drop, (boolean)true)) continue;
                            cluster = new ItemStack(DTItems.CLUSTER_TITANIUM);
                        }
                    }
                    if (cluster.func_77973_b().getRegistryName() == null || cluster.func_190926_b()) continue;
                    cluster.func_190920_e(count);
                    dropList.set(cluster);
                }
            }
        }
        if (event.getHarvester() != null) {
            boolean smelting;
            count = this.randomCount(event.getDrops().size(), event.getFortuneLevel(), event.getWorld());
            Block block = event.getState().func_177230_c();
            tool = event.getHarvester().func_184614_ca();
            ListIterator<ItemStack> dropList = event.getDrops().listIterator();
            boolean bl = smelting = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.SMELTING, (ItemStack)tool) > 0;
            if (!tool.func_190926_b()) {
                if (tool.func_77973_b() instanceof DTHammer) {
                    count = this.randomCount(event.getDrops().size(), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)tool), event.getWorld());
                    smelting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)tool) > 0;
                    int chance = eventRand.nextInt(100);
                    while (dropList.hasNext()) {
                        NonNullList oreList;
                        dropList.next();
                        if (event.getState().func_177230_c() == Blocks.field_150347_e) {
                            dropList.set(new ItemStack(Item.func_150898_a((Block)Blocks.field_150351_n), 1));
                            if (chance < 70) {
                                dropList.add(new ItemStack(Items.field_151145_ak, 1));
                            }
                        }
                        if (event.getState().func_177230_c() != Blocks.field_150351_n) continue;
                        if (DTConfigHandler.configuration.get("1-Feature", "Use Crushing Loot Table", false).getBoolean(false)) {
                            dropList.set(new ItemStack(Item.func_150898_a((Block)Blocks.field_150354_m), 1));
                            LootContext.Builder build = new LootContext.Builder((WorldServer)event.getWorld());
                            for (ItemStack stack : event.getWorld().func_184146_ak().func_186521_a(DTLoots.CRUSHING_LOOT).func_186462_a(event.getWorld().field_73012_v, build.func_186471_a())) {
                                if (stack.func_190926_b()) continue;
                                dropList.add(stack.func_77946_l());
                            }
                            continue;
                        }
                        dropList.set(new ItemStack(Item.func_150898_a((Block)Blocks.field_150354_m), 1));
                        if (chance < 50) {
                            dropList.add(new ItemStack(Items.field_151145_ak, count));
                        }
                        if (chance >= 45 && chance < 80) {
                            dropList.add(new ItemStack(Items.field_151137_ax, count));
                        }
                        if (chance < 70) continue;
                        chance = eventRand.nextInt(3);
                        if (chance == 0 && !(oreList = OreDictionary.getOres((String)"ingotTin")).isEmpty()) {
                            dropList.add(new ItemStack(DTItems.CLUSTER_TIN, count));
                        }
                        if (chance == 1) {
                            oreList = OreDictionary.getOres((String)"ingotCopper");
                            if (oreList.isEmpty()) continue;
                            dropList.add(new ItemStack(DTItems.CLUSTER_COPPER, count));
                            continue;
                        }
                        dropList.add(new ItemStack(DTItems.CLUSTER_IRON, count));
                    }
                }
                while (dropList.hasPrevious()) {
                    dropList.previous();
                }
                if ((tool.func_77973_b() instanceof ItemTool || tool.func_77973_b() instanceof DTHammer) && !event.getDrops().isEmpty() && smelting) {
                    while (dropList.hasNext()) {
                        ItemStack drop = (ItemStack)dropList.next();
                        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(drop);
                        if (smelted.func_190926_b()) continue;
                        smelted = smelted.func_77946_l();
                        dropList.set(smelted);
                        float baseExp = FurnaceRecipes.func_77602_a().func_151398_b(smelted);
                        float bonusExp = baseExp * (float)count;
                        if (bonusExp >= 1.0f) {
                            event.getState().func_177230_c().func_180637_b(event.getWorld(), event.getPos(), (int)bonusExp);
                        }
                        if (drop.func_77973_b() == Item.func_150898_a((Block)block) || drop.func_77973_b() == Item.func_150898_a((Block)block) || drop.func_77973_b() instanceof ItemBlock && block.func_149688_o(event.getState()) != Material.field_151575_d) {
                            count = 1;
                        }
                        if (count > 8) {
                            count = 8;
                        }
                        smelted.func_190920_e(count);
                        event.getHarvester().func_130014_f_().func_184133_a(null, event.getHarvester().func_180425_c(), SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.2f, 1.0f / (eventRand.nextFloat() * 0.4f + 1.2f));
                    }
                }
            }
        }
    }

    private int randomCount(int baseCount, int fortuneLevel, World world) {
        if (fortuneLevel > 0) {
            int j = eventRand.nextInt(fortuneLevel + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return baseCount * (j + 1);
        }
        return baseCount;
    }
}

