/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items.books;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.DungeonTactics;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTCreativeTab;

public class DTDungeonpediaBook1
extends ItemWrittenBook {
    public DTDungeonpediaBook1(String name) {
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(DTCreativeTab.DT_TAB);
        ItemStack book = new ItemStack(Items.field_151099_bA);
        this.populatePages(book);
    }

    private void populatePages(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77982_d(tag);
        NBTTagList bookPages = new NBTTagList();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("pages")) {
            stack.func_190919_e("pages");
        }
        tag.func_74782_a("pages", (NBTBase)bookPages);
        if (DTConfigHandler.configuration.get("1-Feature", "Seasonal Events", true).getBoolean(true) && DungeonTactics.fools) {
            tag.func_74778_a("author", "\u00ef\u00bf\u00bdkMoomin");
            tag.func_74778_a("title", "Super Useful Guidebook");
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Book of All\n\n\u00ef\u00bf\u00bdl     Knowledge\n\n\u00ef\u00bf\u00bdl     Volume \u00ef\u00bf\u00bdk999\""));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThis immense collection of books contains all knowledge of life, there-after, and the universe.\""));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdkIf you can read this, you are cheating ;) Happy April Fools Day abcd efg hijk lmnop qrs tuv wxy and z 42\u00ef\u00bf\u00bdr.....\n\n*The ink has run and the words are completely illegible.*\""));
            return;
        }
        tag.func_74778_a("author", "Some probably-dead guy");
        tag.func_74778_a("title", "Dungeonpedia");
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl   Dungeonpedia\n\n\u00ef\u00bf\u00bdl     Volume 1\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThis volume contains information and tips for an aspiring Dungeoneer.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Gilded and Jewelled Equipment\n\nBy applying precious materials to your iron equipment, you can maintain it's effectiveness while gaining the benefits of the additional material(s).\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"Gilded items will have increased enchantability and jewelled items will also have increased effectiveness. Aside from being more receptive of enchantments, gilded and jewelled armour sets are able to absorb a portion of magical damage.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl  Studded Armour\n\nThis is a cheaper upgrade from leather that provides the armour toughness effect. The dense material is good defence against explosions.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl  Plate Armour\n\nDue to the use of less resources in it's crafting, this armour provides lower surface area than traditional armours, but it is suprisingly effective at glancing even heavy blows off of the wearer.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl   Flight Goggles\n\u00ef\u00bf\u00bdl and Rocket Pants\n\nWho ever made these was probably just messing around and clearly has little concern for personal safety. When the gunpowder is ignited, the rockets will increase the wearers jump height to almost deadly heights.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nIt is possible to glide, by burning any remaining fumes, if the wearer has a pair of flight goggles equipped.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl   Bounce Boots\n\nSelf explanatory. You fall, they bounce. Hopefully with you still in them. If you fall like a rock, the impact will still hurt, but if you fall like a feather you may not feel the landing at all.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl   Magic Tether\n\nA piece of rope, wrapped in space and tangled by the void. If one focusses while using this item it will violently pull them through space to a safe place. A lack of focus is likely to not take you far.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Phylactery\n\nContaining the power of a fraction of a soul, this abhorrent machination of twisted minds is able to capture the soul of the one who holds it and force it back into their body, unnaturally healing them in the process.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl       Bag of\n\u00ef\u00bf\u00bdl      Hoarding\n\nCarrying an ender chest it just silly. Put it in a bag and you don't even have to put it down to open it.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Ducttape\n\nIt holds the universe and everything else together. Apply it to the item in your other hand and it will hold that together too, as long as there is something left to hold together.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Heart Drops\n\nWhen defeated, creatures have a chance to drop concentrated life essence, which will be absorbed on contact and heal the one who touches it. Can be collected in a bottle.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Loot Bags\n\nStollen, lost, discarded, looted. Who knows where these bags of random stuff come from, but finders keepers.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl  Survival Rations\n\nYou'd be surprised what you are willing to eat when you are starving. Rotten flesh is not the best, but it can be made edible... Well, almost.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Potion Fish\n\nSpilled potions of dead adventurers have to drain away somewhere. Sometimes that somewhere is waull of water, sometimes that water has fish. Over the years... Lets just say, a lot of people have died and these fish taste great.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Lanterns\n\nWhile the Iron Lantern is only a light source, the Magic Lantern, while lit, will banish hostile creatures that enter it's reach. Can be extinguished with an empty hand, and lit with a flint and steel\""));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77978_p() == null) {
            this.populatePages(itemstack);
        }
        if (!world.field_72995_K) {
            this.resolveContents(itemstack, player);
        }
        if (world.field_72995_K) {
            DungeonTactics.INSTANCE.openDungeonBook(player, itemstack, false);
        }
        player.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public static boolean validBookTagContents(NBTTagCompound nbt) {
        if (!ItemWritableBook.func_150930_a((NBTTagCompound)nbt)) {
            return false;
        }
        if (!nbt.func_150297_b("title", 8)) {
            return false;
        }
        String s = nbt.func_74779_i("title");
        return s != null && s.length() <= 32 ? nbt.func_150297_b("author", 8) : false;
    }

    public static int getGeneration(ItemStack book) {
        return book.func_77978_p().func_74762_e("generation");
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbttagcompound;
        String s;
        if (stack.func_77942_o() && !StringUtils.func_151246_b((String)(s = (nbttagcompound = stack.func_77978_p()).func_74779_i("title")))) {
            return s;
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbttagcompound = stack.func_77978_p();
            String s = nbttagcompound.func_74779_i("author");
            if (!StringUtils.func_151246_b((String)s)) {
                tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"book.byAuthor", (Object[])new Object[]{s}));
            }
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)("book.generation." + nbttagcompound.func_74762_e("generation"))));
        }
    }

    private void resolveContents(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbttagcompound;
        if (stack.func_77978_p() != null && !(nbttagcompound = stack.func_77978_p()).func_74767_n("resolved")) {
            nbttagcompound.func_74757_a("resolved", true);
            if (DTDungeonpediaBook1.validBookTagContents(nbttagcompound)) {
                NBTTagList nbttaglist = nbttagcompound.func_150295_c("pages", 8);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    ITextComponent itextcomponent;
                    String s = nbttaglist.func_150307_f(i);
                    try {
                        itextcomponent = ITextComponent.Serializer.func_186877_b((String)s);
                        itextcomponent = TextComponentUtils.func_179985_a((ICommandSender)player, (ITextComponent)itextcomponent, (Entity)player);
                    }
                    catch (Exception var9) {
                        itextcomponent = new TextComponentString(s);
                    }
                    nbttaglist.func_150304_a(i, (NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent)));
                }
                nbttagcompound.func_74782_a("pages", (NBTBase)nbttaglist);
                if (player instanceof EntityPlayerMP && player.func_184614_ca() == stack) {
                    Slot slot = player.field_71070_bA.func_75147_a((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c);
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(0, slot.field_75222_d, stack));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

