/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items.unique;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.items.DTPotshot;

public class DTBackfireCannon
extends DTPotshot {
    public DTBackfireCannon(String name) {
        super(name);
        this.func_77656_e(1000);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity == null) {
                    return 0.0f;
                }
                return entity.func_184607_cu().func_77973_b() != DTItems.BACKFIRE_CANNON ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public String func_77653_i(ItemStack stack) {
        return TextFormatting.DARK_AQUA + super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return material.func_77969_a(new ItemStack(Items.field_151062_by)) || super.func_82789_a(stack, material);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add("Flame");
        tooltip.add("Infinity");
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)player.func_184586_b(hand), (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        this.fireTheCannon(stack, world, entityLiving, 0);
        return stack;
    }

    @Override
    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        this.fireTheCannon(stack, world, entityLiving, timeLeft);
    }

    public void fireTheCannon(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (world.field_72995_K) {
            this.doParticles(world, entityLiving.func_180425_c());
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (boolean)true)) < 0) {
                return;
            }
            if (!world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                float yaw = player.field_70177_z;
                float pitch = player.field_70125_A;
                float f1 = -2.0f;
                double motionX = -MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * f1;
                double motionY = -MathHelper.func_76126_a((float)(pitch / 180.0f * (float)Math.PI)) * f1;
                double motionZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * f1;
                AxisAlignedBB axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
                List list = world.func_72872_a(EntityLivingBase.class, axisalignedbb);
                if (!list.isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list) {
                        double d0;
                        if (entitylivingbase.func_70045_F() || entitylivingbase.func_70028_i((Entity)player) || !((d0 = player.func_70068_e((Entity)entitylivingbase)) < 16.0)) continue;
                        double d1 = 4.0 - Math.sqrt(d0) / 4.0;
                        double j = d1 * 60.5;
                        int x = (int)(j / 10.0) / 5;
                        entitylivingbase.func_70015_d(x * 2);
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76440_q, x * 10, 0));
                        if (field_77697_d.nextInt(50) == 0) {
                            x = 100;
                        }
                        entitylivingbase.func_70097_a(DamageSource.field_76372_a, (float)(5 + x + field_77697_d.nextInt(5)));
                    }
                }
                player.field_70159_w = motionX;
                player.field_70181_x = motionY;
                player.field_70179_y = motionZ;
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)player)));
            }
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187715_dR, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 15);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, BlockPos pos) {
        double d0 = 0.0625;
        for (int i = 0; i < 20; ++i) {
            double d1 = (float)pos.func_177958_n() + (float)field_77697_d.nextInt(3) - (float)field_77697_d.nextInt(3);
            double d2 = (float)pos.func_177956_o() + field_77697_d.nextFloat();
            double d3 = (float)pos.func_177952_p() + (float)field_77697_d.nextInt(3) - (float)field_77697_d.nextInt(3);
            if (field_77697_d.nextInt() <= 0) {
                world.func_175688_a(EnumParticleTypes.FLAME, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
                continue;
            }
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

