/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.bamboo;

import erebus.ModTabs;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBambooTorch
extends Block {
    public static final PropertyEnum<EnumBlockTorchHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumBlockTorchHalf.class);
    protected static final AxisAlignedBB TORCH_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockBambooTorch() {
        super(Material.field_151575_d);
        this.func_149711_c(0.0f);
        this.func_149715_a(0.9f);
        this.func_149647_a(ModTabs.BLOCKS);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return TORCH_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockTorchHalf.UPPER)), 2);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() == null || !world.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        if (state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos.func_177977_b())) {
            return false;
        }
        return state.func_185904_a().func_76230_c();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.dropTorchIfCantStay(world, state, pos);
    }

    protected boolean dropTorchIfCantStay(World world, IBlockState state, BlockPos pos) {
        if (world.func_175623_d(pos.func_177977_b())) {
            world.func_175698_g(pos);
            if (state.func_177229_b(HALF) == EnumBlockTorchHalf.UPPER) {
                this.func_176226_b(world, pos, state, 0);
            }
            return false;
        }
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b(HALF) == EnumBlockTorchHalf.UPPER) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (player.field_71075_bZ.field_75098_d) {
                    world.func_175698_g(pos.func_177977_b());
                } else {
                    world.func_175655_b(pos.func_177977_b(), true);
                    if (world.field_72995_K) {
                        world.func_175698_g(pos.func_177977_b());
                    }
                }
            }
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
            this.func_176226_b(world, pos, state.func_177226_a(HALF, (Comparable)((Object)EnumBlockTorchHalf.UPPER)), 0);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b(HALF) == EnumBlockTorchHalf.LOWER) {
            return Items.field_190931_a;
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockTorchHalf.UPPER)) : this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockTorchHalf.LOWER));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate;
        if (state.func_177229_b(HALF) == EnumBlockTorchHalf.UPPER && (iblockstate = world.func_180495_p(pos.func_177977_b())).func_177230_c() == this) {
            return state;
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(HALF) == EnumBlockTorchHalf.UPPER ? 8 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state.func_177229_b(HALF) == EnumBlockTorchHalf.UPPER) {
            double d0 = (float)pos.func_177958_n() + 0.4375f;
            double d1 = (float)pos.func_177956_o() + 1.0625f;
            double d2 = (float)pos.func_177952_p() + 0.4375f;
            double d3 = (float)pos.func_177958_n() + 0.5625f;
            double d4 = (float)pos.func_177952_p() + 0.5625f;
            double d5 = (float)pos.func_177958_n() + 0.5f;
            double d6 = (float)pos.func_177956_o() + 1.25f;
            double d7 = (float)pos.func_177952_p() + 0.5f;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d4, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d4, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d3, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d3, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d3, d1, d4, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d3, d1, d4, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d5, d6, d7, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d5, d6, d7, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static enum EnumBlockTorchHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

