/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.blocks.BlockGlowGemInactive;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGlowGemActive
extends Block
implements ModBlocks.IHasCustomItem {
    public static final PropertyEnum<EnumGemDirection> TYPE = PropertyEnum.func_177709_a((String)"type", EnumGemDirection.class);

    public BlockGlowGemActive() {
        super(Material.field_151592_s);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumGemDirection.DOWN_NORTH)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        float widthMin = 0.0f;
        float heightMin = 0.0f;
        float depthMin = 0.0f;
        float widthMax = 0.0f;
        float heightMax = 0.0f;
        float depthMax = 0.0f;
        switch ((EnumGemDirection)((Object)state.func_177229_b(TYPE))) {
            case SOUTH: {
                widthMin = 0.125f;
                heightMin = 0.1875f;
                depthMin = 0.8125f;
                widthMax = 0.125f;
                heightMax = 0.1875f;
                depthMax = 0.0f;
                break;
            }
            case NORTH: {
                widthMin = 0.125f;
                heightMin = 0.1875f;
                depthMin = 0.0f;
                widthMax = 0.125f;
                heightMax = 0.1875f;
                depthMax = 0.8125f;
                break;
            }
            case EAST: {
                widthMin = 0.8125f;
                heightMin = 0.1875f;
                depthMin = 0.125f;
                widthMax = 0.0f;
                heightMax = 0.1875f;
                depthMax = 0.125f;
                break;
            }
            case WEST: {
                widthMin = 0.0f;
                heightMin = 0.1875f;
                depthMin = 0.125f;
                widthMax = 0.8125f;
                heightMax = 0.1875f;
                depthMax = 0.125f;
                break;
            }
            case UP_NORTH: {
                widthMin = 0.125f;
                heightMin = 0.8125f;
                depthMin = 0.1875f;
                widthMax = 0.125f;
                heightMax = 0.0f;
                depthMax = 0.1875f;
                break;
            }
            case UP_EAST: {
                widthMin = 0.1875f;
                heightMin = 0.8125f;
                depthMin = 0.125f;
                widthMax = 0.1875f;
                heightMax = 0.0f;
                depthMax = 0.125f;
                break;
            }
            case UP_SOUTH: {
                widthMin = 0.125f;
                heightMin = 0.8125f;
                depthMin = 0.1875f;
                widthMax = 0.125f;
                heightMax = 0.0f;
                depthMax = 0.1875f;
                break;
            }
            case UP_WEST: {
                widthMin = 0.1875f;
                heightMin = 0.8125f;
                depthMin = 0.125f;
                widthMax = 0.1875f;
                heightMax = 0.0f;
                depthMax = 0.125f;
                break;
            }
            case DOWN_NORTH: {
                widthMin = 0.125f;
                heightMin = 0.0f;
                depthMin = 0.1875f;
                widthMax = 0.125f;
                heightMax = 0.8125f;
                depthMax = 0.1875f;
                break;
            }
            case DOWN_EAST: {
                widthMin = 0.1875f;
                heightMin = 0.0f;
                depthMin = 0.125f;
                widthMax = 0.1875f;
                heightMax = 0.8125f;
                depthMax = 0.125f;
                break;
            }
            case DOWN_SOUTH: {
                widthMin = 0.125f;
                heightMin = 0.0f;
                depthMin = 0.1875f;
                widthMax = 0.125f;
                heightMax = 0.8125f;
                depthMax = 0.1875f;
                break;
            }
            case DOWN_WEST: {
                widthMin = 0.1875f;
                heightMin = 0.0f;
                depthMin = 0.125f;
                widthMax = 0.1875f;
                heightMax = 0.8125f;
                depthMax = 0.125f;
            }
        }
        return new AxisAlignedBB((double)(0.0f + widthMin), (double)(0.0f + heightMin), (double)(0.0f + depthMin), (double)(1.0f - widthMax), (double)(1.0f - heightMax), (double)(1.0f - depthMax));
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumGemDirection newFacing = (EnumGemDirection)((Object)state.func_177229_b(TYPE));
        boolean flag = false;
        if ((newFacing == EnumGemDirection.UP_NORTH || newFacing == EnumGemDirection.UP_EAST || newFacing == EnumGemDirection.UP_SOUTH || newFacing == EnumGemDirection.UP_WEST) && world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
            flag = true;
        }
        if ((newFacing == EnumGemDirection.DOWN_NORTH || newFacing == EnumGemDirection.DOWN_EAST || newFacing == EnumGemDirection.DOWN_SOUTH || newFacing == EnumGemDirection.DOWN_WEST) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.NORTH && world.isSideSolid(pos.func_177972_a(EnumFacing.NORTH), EnumFacing.NORTH)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.SOUTH && world.isSideSolid(pos.func_177972_a(EnumFacing.SOUTH), EnumFacing.SOUTH)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.WEST && world.isSideSolid(pos.func_177972_a(EnumFacing.WEST), EnumFacing.WEST)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.EAST && world.isSideSolid(pos.func_177972_a(EnumFacing.EAST), EnumFacing.EAST)) {
            flag = true;
        }
        if (!flag) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        IBlockState activeState = ModBlocks.GLOW_GEM_INACTIVE.func_176223_P().func_177226_a((IProperty)BlockGlowGemInactive.TYPE, state.func_177229_b(TYPE));
        world.func_180501_a(pos, activeState, 3);
        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
        return true;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return BlockGlowGemActive.canPlaceBlock(world, pos, side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockGlowGemActive.canPlaceBlock(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World world, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = world.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)world, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        return world.func_175677_d(blockpos, true) && block.func_149662_c(iblockstate) && flag;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int direction = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumGemDirection newFacing = EnumGemDirection.DOWN_NORTH;
        if (facing == EnumFacing.UP) {
            switch (direction) {
                case 0: {
                    newFacing = EnumGemDirection.DOWN_SOUTH;
                    break;
                }
                case 1: {
                    newFacing = EnumGemDirection.DOWN_EAST;
                    break;
                }
                case 2: {
                    newFacing = EnumGemDirection.DOWN_NORTH;
                    break;
                }
                case 3: {
                    newFacing = EnumGemDirection.DOWN_WEST;
                }
            }
        } else if (facing == EnumFacing.DOWN) {
            switch (direction) {
                case 0: {
                    newFacing = EnumGemDirection.UP_SOUTH;
                    break;
                }
                case 1: {
                    newFacing = EnumGemDirection.UP_EAST;
                    break;
                }
                case 2: {
                    newFacing = EnumGemDirection.UP_NORTH;
                    break;
                }
                case 3: {
                    newFacing = EnumGemDirection.UP_WEST;
                }
            }
        } else {
            switch (facing) {
                case SOUTH: {
                    newFacing = EnumGemDirection.NORTH;
                    break;
                }
                case EAST: {
                    newFacing = EnumGemDirection.WEST;
                    break;
                }
                case NORTH: {
                    newFacing = EnumGemDirection.SOUTH;
                    break;
                }
                case WEST: {
                    newFacing = EnumGemDirection.EAST;
                }
            }
        }
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)newFacing));
    }

    public int func_180651_a(IBlockState state) {
        return EnumGemDirection.DOWN_NORTH.ordinal();
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.BLOCKS) {
            list.add((Object)new ItemStack((Block)this, 1, EnumGemDirection.DOWN_NORTH.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumGemDirection.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumGemDirection type = (EnumGemDirection)((Object)state.func_177229_b(TYPE));
        return type.ordinal();
    }

    @Override
    public ItemBlock getItemBlock() {
        ItemBlock GLOW_GEM_ITEM = new ItemBlock(this){

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
                list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.erebus.glowgem", new Object[0]).func_150254_d());
            }
        };
        return GLOW_GEM_ITEM;
    }

    public static enum EnumGemDirection implements IErebusEnum
    {
        DOWN_NORTH,
        DOWN_SOUTH,
        DOWN_WEST,
        DOWN_EAST,
        UP_NORTH,
        UP_SOUTH,
        UP_WEST,
        UP_EAST,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModBlocks.GLOW_GEM_ACTIVE, size, this.ordinal());
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

