/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.blocks.EnumWood;
import erebus.items.block.ItemBlockEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWallPlantsCultivated
extends Block
implements IShearable,
ModBlocks.IHasCustomItem,
ModBlocks.ISubBlocksBlock {
    public static final PropertyEnum<EnumWallPlantCultivatedType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumWallPlantCultivatedType.class);
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.8, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.2, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.2);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8, 1.0, 1.0, 1.0);

    public BlockWallPlantsCultivated() {
        super(Material.field_151585_k);
        this.func_149711_c(0.2f);
        this.func_149675_a(true);
        this.func_149647_a(ModTabs.PLANTS);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOSS_DOWN_CULTIVATED)));
    }

    public int func_149738_a(World world) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.PLANTS) {
            list.add((Object)new ItemStack((Block)this, 1, EnumWallPlantCultivatedType.MOSS_DOWN_CULTIVATED.ordinal()));
            list.add((Object)new ItemStack((Block)this, 1, EnumWallPlantCultivatedType.MOULD_DOWN_CULTIVATED.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumWallPlantCultivatedType type = (EnumWallPlantCultivatedType)((Object)state.func_177229_b(TYPE));
        return type.ordinal();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumWallPlantCultivatedType)((Object)state.func_177229_b(TYPE))) {
            default: {
                return EAST_AABB;
            }
            case MOSS_WEST_CULTIVATED: {
                return WEST_AABB;
            }
            case MOSS_SOUTH_CULTIVATED: {
                return SOUTH_AABB;
            }
            case MOSS_NORTH_CULTIVATED: {
                return NORTH_AABB;
            }
            case MOSS_UP_CULTIVATED: {
                return UP_AABB;
            }
            case MOSS_DOWN_CULTIVATED: {
                return DOWN_AABB;
            }
            case MOULD_EAST_CULTIVATED: {
                return EAST_AABB;
            }
            case MOULD_WEST_CULTIVATED: {
                return WEST_AABB;
            }
            case MOULD_SOUTH_CULTIVATED: {
                return SOUTH_AABB;
            }
            case MOULD_NORTH_CULTIVATED: {
                return NORTH_AABB;
            }
            case MOULD_UP_CULTIVATED: {
                return UP_AABB;
            }
            case MOULD_DOWN_CULTIVATED: 
        }
        return DOWN_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    private boolean canPlaceAt(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockPos = pos.func_177972_a(facing.func_176734_d());
        boolean flag = facing.func_176740_k().func_176722_c();
        return flag && world.isSideSolid(blockPos, facing, true) && this.canPlaceOn(world, blockPos) || (facing.equals((Object)EnumFacing.DOWN) || facing.equals((Object)EnumFacing.UP)) && this.canPlaceOn(world, blockPos);
    }

    private boolean canPlaceOn(World world, BlockPos pos) {
        return this.isValidBlock(world.func_180495_p(pos).func_177230_c());
    }

    private boolean isValidBlock(Block block) {
        return block == EnumWood.ROTTEN.getLog();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (meta <= 5) {
            if (facing.equals((Object)EnumFacing.UP) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
                meta = 0;
            }
            if (facing.equals((Object)EnumFacing.DOWN) && world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
                meta = 1;
            }
            if (facing.equals((Object)EnumFacing.SOUTH) && world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH)) {
                meta = 2;
            }
            if (facing.equals((Object)EnumFacing.NORTH) && world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH)) {
                meta = 3;
            }
            if (facing.equals((Object)EnumFacing.EAST) && world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST)) {
                meta = 4;
            }
            if (facing.equals((Object)EnumFacing.WEST) && world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST)) {
                meta = 5;
            }
        } else if (meta > 5) {
            if (facing.equals((Object)EnumFacing.UP) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
                meta = 6;
            }
            if (facing.equals((Object)EnumFacing.DOWN) && world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
                meta = 7;
            }
            if (facing.equals((Object)EnumFacing.SOUTH) && world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH)) {
                meta = 8;
            }
            if (facing.equals((Object)EnumFacing.NORTH) && world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH)) {
                meta = 9;
            }
            if (facing.equals((Object)EnumFacing.EAST) && world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST)) {
                meta = 10;
            }
            if (facing.equals((Object)EnumFacing.WEST) && world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST)) {
                meta = 11;
            }
        }
        return this.func_176203_a(meta);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.field_72995_K) {
            return;
        }
        EnumWallPlantCultivatedType type = (EnumWallPlantCultivatedType)((Object)state.func_177229_b(TYPE));
        boolean flag = false;
        if ((type.equals(EnumWallPlantCultivatedType.MOSS_DOWN_CULTIVATED) || type.equals(EnumWallPlantCultivatedType.MOULD_DOWN_CULTIVATED)) && world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
            flag = true;
        }
        if ((type.equals(EnumWallPlantCultivatedType.MOSS_UP_CULTIVATED) || type.equals(EnumWallPlantCultivatedType.MOULD_UP_CULTIVATED)) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            flag = true;
        }
        if ((type.equals(EnumWallPlantCultivatedType.MOSS_NORTH_CULTIVATED) || type.equals(EnumWallPlantCultivatedType.MOULD_NORTH_CULTIVATED)) && world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH)) {
            flag = true;
        }
        if ((type.equals(EnumWallPlantCultivatedType.MOSS_SOUTH_CULTIVATED) || type.equals(EnumWallPlantCultivatedType.MOULD_SOUTH_CULTIVATED)) && world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH)) {
            flag = true;
        }
        if ((type.equals(EnumWallPlantCultivatedType.MOSS_WEST_CULTIVATED) || type.equals(EnumWallPlantCultivatedType.MOULD_WEST_CULTIVATED)) && world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST)) {
            flag = true;
        }
        if ((type.equals(EnumWallPlantCultivatedType.MOSS_EAST_CULTIVATED) || type.equals(EnumWallPlantCultivatedType.MOULD_EAST_CULTIVATED)) && world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST)) {
            flag = true;
        }
        if (!flag && !world.field_72995_K) {
            world.func_180498_a(null, 2001, pos, Block.func_149682_b((Block)world.func_180495_p(pos).func_177230_c()) + world.func_180495_p(pos).func_177230_c().func_176201_c(state) << 12);
            world.func_175698_g(pos);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int typeMeta = ((EnumWallPlantCultivatedType)((Object)state.func_177229_b(TYPE))).ordinal();
        return new ItemStack(Item.func_150898_a((Block)this), 1, typeMeta <= 5 ? EnumWallPlantCultivatedType.MOSS_DOWN_CULTIVATED.ordinal() : EnumWallPlantCultivatedType.MOULD_DOWN_CULTIVATED.ordinal());
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        EnumWallPlantCultivatedType type = (EnumWallPlantCultivatedType)((Object)world.func_180495_p(pos).func_177229_b(TYPE));
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        switch (type) {
            case MOSS_EAST_CULTIVATED: 
            case MOSS_WEST_CULTIVATED: 
            case MOSS_SOUTH_CULTIVATED: 
            case MOSS_NORTH_CULTIVATED: 
            case MOSS_UP_CULTIVATED: 
            case MOSS_DOWN_CULTIVATED: {
                ret.add(new ItemStack((Block)this, 1, EnumWallPlantCultivatedType.MOSS_DOWN_CULTIVATED.ordinal()));
                break;
            }
            case MOULD_EAST_CULTIVATED: 
            case MOULD_WEST_CULTIVATED: 
            case MOULD_SOUTH_CULTIVATED: 
            case MOULD_NORTH_CULTIVATED: 
            case MOULD_UP_CULTIVATED: 
            case MOULD_DOWN_CULTIVATED: {
                ret.add(new ItemStack((Block)this, 1, EnumWallPlantCultivatedType.MOULD_DOWN_CULTIVATED.ordinal()));
                break;
            }
            default: {
                ret.add(new ItemStack((Block)this, 1, EnumWallPlantCultivatedType.MOSS_DOWN_CULTIVATED.ordinal()));
            }
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        EnumWallPlantCultivatedType type = (EnumWallPlantCultivatedType)((Object)world.func_180495_p(pos).func_177229_b(TYPE));
        int attempt = 0;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (rand.nextInt(2) == 0) {
            block31: {
                int zz;
                int yy;
                int radius = 4;
                int distance = 5;
                int xx = x - radius;
                block20: while (true) {
                    if (xx > x + radius) {
                        xx = x + rand.nextInt(3) - 1;
                        if (world.func_175623_d(new BlockPos(xx, yy = y + rand.nextInt(3) - 1, zz = z + rand.nextInt(3) - 1))) {
                            break;
                        }
                        break block31;
                    }
                    zz = z - radius;
                    while (true) {
                        if (zz <= z + radius) {
                        } else {
                            ++xx;
                            continue block20;
                        }
                        for (yy = y - radius; yy <= y + radius; ++yy) {
                            if (world.func_180495_p(new BlockPos(xx, zz, yy)) != this || --distance > 0) continue;
                            return;
                        }
                        ++zz;
                    }
                    break;
                }
                block23: for (attempt = 0; attempt < 6; ++attempt) {
                    int offset = 1;
                    int randomiseSide = rand.nextInt(6);
                    switch (type) {
                        case MOSS_EAST_CULTIVATED: 
                        case MOSS_WEST_CULTIVATED: 
                        case MOSS_SOUTH_CULTIVATED: 
                        case MOSS_NORTH_CULTIVATED: 
                        case MOSS_UP_CULTIVATED: 
                        case MOSS_DOWN_CULTIVATED: {
                            switch (randomiseSide) {
                                case 0: {
                                    if (!world.isSideSolid(new BlockPos(xx, yy + offset, zz), EnumFacing.DOWN) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx, yy + offset, zz)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOSS_DOWN_CULTIVATED)), 2);
                                    break;
                                }
                                case 1: {
                                    if (!world.isSideSolid(new BlockPos(xx, yy - offset, zz), EnumFacing.UP) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx, yy - offset, zz)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOSS_UP_CULTIVATED)), 2);
                                    break;
                                }
                                case 2: {
                                    if (!world.isSideSolid(new BlockPos(xx, yy, zz + offset), EnumFacing.NORTH) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx, yy, zz + offset)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOSS_NORTH_CULTIVATED)), 2);
                                    break;
                                }
                                case 3: {
                                    if (!world.isSideSolid(new BlockPos(xx, yy, zz - offset), EnumFacing.SOUTH) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx, yy, zz - offset)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOSS_SOUTH_CULTIVATED)), 2);
                                    break;
                                }
                                case 4: {
                                    if (!world.isSideSolid(new BlockPos(xx + offset, yy, zz), EnumFacing.WEST) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx + offset, yy, zz)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOSS_WEST_CULTIVATED)), 2);
                                    break;
                                }
                                case 5: {
                                    if (!world.isSideSolid(new BlockPos(xx - offset, yy, zz), EnumFacing.EAST) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx - offset, yy, zz)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOSS_EAST_CULTIVATED)), 2);
                                    break;
                                }
                            }
                            continue block23;
                        }
                        case MOULD_EAST_CULTIVATED: 
                        case MOULD_WEST_CULTIVATED: 
                        case MOULD_SOUTH_CULTIVATED: 
                        case MOULD_NORTH_CULTIVATED: 
                        case MOULD_UP_CULTIVATED: 
                        case MOULD_DOWN_CULTIVATED: {
                            switch (randomiseSide) {
                                case 0: {
                                    if (!world.isSideSolid(new BlockPos(xx, yy + offset, zz), EnumFacing.DOWN) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx, yy + offset, zz)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOULD_DOWN_CULTIVATED)), 2);
                                    break;
                                }
                                case 1: {
                                    if (!world.isSideSolid(new BlockPos(xx, yy - offset, zz), EnumFacing.UP) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx, yy - offset, zz)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOULD_UP_CULTIVATED)), 2);
                                    break;
                                }
                                case 2: {
                                    if (!world.isSideSolid(new BlockPos(xx, yy, zz + offset), EnumFacing.NORTH) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx, yy, zz + offset)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOULD_NORTH_CULTIVATED)), 2);
                                    break;
                                }
                                case 3: {
                                    if (!world.isSideSolid(new BlockPos(xx, yy, zz - offset), EnumFacing.SOUTH) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx, yy, zz - offset)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOULD_SOUTH_CULTIVATED)), 2);
                                    break;
                                }
                                case 4: {
                                    if (!world.isSideSolid(new BlockPos(xx + offset, yy, zz), EnumFacing.WEST) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx + offset, yy, zz)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOULD_WEST_CULTIVATED)), 2);
                                    break;
                                }
                                case 5: {
                                    if (!world.isSideSolid(new BlockPos(xx - offset, yy, zz), EnumFacing.EAST) || !this.isValidBlock(world.func_180495_p(new BlockPos(xx - offset, yy, zz)).func_177230_c())) break;
                                    world.func_180501_a(new BlockPos(xx, yy, zz), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumWallPlantCultivatedType.MOULD_EAST_CULTIVATED)), 2);
                                }
                            }
                            continue block23;
                        }
                    }
                }
            }
            if (rand.nextInt(25) == 0) {
                world.func_175698_g(pos);
            }
        }
    }

    @Override
    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        for (EnumWallPlantCultivatedType type : EnumWallPlantCultivatedType.values()) {
            models.add(type.func_176610_l());
        }
        return models;
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create(this, EnumWallPlantCultivatedType.class);
    }

    public static enum EnumWallPlantCultivatedType implements IErebusEnum
    {
        MOSS_UP_CULTIVATED,
        MOSS_DOWN_CULTIVATED,
        MOSS_SOUTH_CULTIVATED,
        MOSS_NORTH_CULTIVATED,
        MOSS_EAST_CULTIVATED,
        MOSS_WEST_CULTIVATED,
        MOULD_UP_CULTIVATED,
        MOULD_DOWN_CULTIVATED,
        MOULD_SOUTH_CULTIVATED,
        MOULD_NORTH_CULTIVATED,
        MOULD_EAST_CULTIVATED,
        MOULD_WEST_CULTIVATED;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModBlocks.WALL_PLANTS_CULTIVATED, size, this.ordinal());
        }
    }
}

