/*
 * Decompiled with CFR 0.152.
 */
package erebus.core.handler.configs;

import erebus.Erebus;
import erebus.preserved.PreservableEntityRegistry;
import erebus.world.biomes.decorators.data.OreSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    private File configFolder;
    public Configuration config;
    public int erebusDimensionID;
    public int portalCooldown;
    public int mobAttackDamageMultiplier;
    public int mobHealthMultipier;
    public byte beetleLarvaEating = 0;
    public boolean spawnPortalMobs;
    public boolean bombardierBlockDestroy;
    public boolean randomNames;
    public boolean playCustomSongs;
    public boolean graveMarker;
    public boolean bioluminescence;
    public boolean glowshrooms;
    public boolean generateVents;
    public boolean allowRespawning;
    public boolean netherWidows;
    public boolean biomeFogColours;
    public static boolean smoothBedrock;
    public static String[] WOA_BLACKLISTED_BLOCKS;
    public boolean disableThaumcraft = false;
    public boolean disableFMP = false;
    public final String[] usedCategories = new String[]{"general", "Biomes", "Ores", "Integration", "Mob Modifiers", "Wand of Animation"};

    public void loadConfig(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        this.configFolder = configFile.getParentFile();
        this.config = new Configuration(configFile);
        this.config.load();
        this.syncConfigs();
    }

    private void syncConfigs() {
        this.readEntityDimensionsFile();
        this.erebusDimensionID = this.config.get("general", "Dimension ID of The Erebus", 66, "There doesn't appear to be a limit on dimension IDs, but try to keep it low").getInt(66);
        this.portalCooldown = this.config.get("general", "Number of seconds before the portal is usable again.", 5).getInt(5);
        this.allowRespawning = this.config.get("general", "Should player re-spawn in dimension", false).getBoolean(false);
        this.beetleLarvaEating = (byte)this.config.get("general", "Beetle larva eating settings", 0, "0 = only wooden blocks except tile entities & logs, 1 = only wooden blocks except logs, 2 = anything", 0, 2).getInt(0);
        this.bombardierBlockDestroy = this.config.get("general", "Bombardier Beetle Block destruction", true, "This will not stop block destruction for player attacks only collided with blocks!").getBoolean(true);
        this.randomNames = this.config.get("general", "Random mob names", true).getBoolean(true);
        this.playCustomSongs = this.config.get("general", "Play erebus songs", true).getBoolean(true);
        this.graveMarker = this.config.get("general", "Block O' Bones Inventory Save", true).getBoolean(true);
        this.biomeFogColours = this.config.get("general", "Coloured Biome Fogs", true).getBoolean(true);
        this.bioluminescence = this.config.get("general", "Glowing bugs emit light", true).getBoolean(true);
        this.glowshrooms = this.config.get("general", "Add Glowshrooms to World generation", true).getBoolean(true);
        this.generateVents = this.config.get("general", "Generate natural swap vents", true).getBoolean(true);
        this.netherWidows = this.config.get("general", "Spawn Black Widows in Nether", true).getBoolean(true);
        smoothBedrock = this.config.get("general", "Erebus Generates with Flat Bedrock Layers", false).getBoolean(false);
        this.mobAttackDamageMultiplier = this.config.get("Mob Modifiers", "Mob Attack Damage Multipier", 1).getInt(1);
        this.mobHealthMultipier = this.config.get("Mob Modifiers", "Mob Health Multiplier", 1).getInt(1);
        WOA_BLACKLISTED_BLOCKS = this.config.getStringList("Blocks ignored by Wand", "Wand of Animation", new String[]{"minecraft:obsidian"}, "For Sanity");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public void initOreConfigs() {
        for (OreSettings.OreType oretype : OreSettings.OreType.values()) {
            oretype.setEnabled(this.config.get("Ores", "Generate " + oretype.toString().toLowerCase(), oretype.isEnabled()).getBoolean(oretype.isEnabled()));
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private void readEntityDimensionsFile() {
        File file = new File(this.configFolder, "ErebusEntityDimensions.cfg");
        BufferedReader br = new BufferedReader(new InputStreamReader(Erebus.class.getResourceAsStream("/assets/erebus/default_entity_sizes.cfg")));
        if (!file.exists()) {
            PreservableEntityRegistry.INSTANCE.readFile(br, true);
            PreservableEntityRegistry.INSTANCE.writeConfigFile(file);
        } else {
            try {
                PreservableEntityRegistry.INSTANCE.readFile(br, true);
                PreservableEntityRegistry.INSTANCE.readFile(new BufferedReader(new FileReader(file)), false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("erebus".equals(event.getModID())) {
            this.syncConfigs();
            this.initOreConfigs();
        }
    }
}

