/*
 * Decompiled with CFR 0.152.
 */
package erebus.core.helper;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    private static final String[] orePrefixes = new String[]{"dust", "ingot", "ore", "block", "gem", "nugget", "shard", "plate", "gear", "stickWood"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rightClickItemAt(World world, BlockPos pos, EnumHand hand, EnumFacing side, ItemStack stack) {
        if (world.field_72995_K || stack.func_190926_b() || stack.func_77973_b() == null) {
            return false;
        }
        EntityPlayer player = Utils.getPlayer(world);
        player.func_174820_d(0, stack);
        try {
            boolean bl = stack.func_77973_b().func_180614_a(player, world, pos, hand, side, 0.0f, 0.0f, 0.0f) != null;
            return bl;
        }
        finally {
            player.func_174820_d(0, ItemStack.field_190927_a);
        }
    }

    public static EntityPlayer getPlayer(World world) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return null;
        }
        return FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("erebus".getBytes()), "[erebus]"));
    }

    public static final int getFlowerMetadata(Object obj) {
        int meta = -1;
        if (obj instanceof ItemStack) {
            meta = ((ItemStack)obj).func_77952_i();
        } else if (obj instanceof Integer) {
            meta = (Integer)obj;
        }
        if (meta >= 2 && meta <= 8 || meta == 14) {
            ++meta;
        } else if (meta >= 9 && meta <= 13) {
            meta += 2;
        }
        return meta;
    }

    public static final void breakBlockWithParticles(World world, BlockPos pos, IBlockState state) {
        Utils.playBreakParticles(world, pos, state);
        world.func_175698_g(pos);
    }

    public static final void breakBlockWithParticles(World world, BlockPos pos) {
        Utils.breakBlockWithParticles(world, pos, world.func_180495_p(pos));
    }

    public static void playBreakParticles(World world, BlockPos pos, IBlockState state) {
        world.func_180498_a(null, 2001, pos, Block.func_149682_b((Block)state.func_177230_c()));
    }

    public static void playBreakParticles(World world, BlockPos pos) {
        world.func_180498_a(null, 2001, pos, Block.func_149682_b((Block)world.func_180495_p(pos).func_177230_c()) + (world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos)) << 12));
    }

    public static final void dropStack(World world, BlockPos pos, ItemStack is) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, is);
            entityitem.func_174867_a(10);
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static final int getColour(int R, int G, int B) {
        return new Color(R, G, B).getRGB() & 0xFFFFFF;
    }

    public static final <T> T getTileEntity(IBlockAccess world, BlockPos pos, Class<T> cls) {
        TileEntity tile = world.func_175625_s(pos);
        if (!cls.isInstance(tile)) {
            return null;
        }
        return (T)tile;
    }

    public static void dropStackNoRandom(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K && !stack.func_190926_b() && world.func_82736_K().func_82766_b("doTileDrops")) {
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, stack);
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            entityItem.func_174867_a(10);
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static int[] getSlotsFromSide(IInventory iinventory, EnumFacing side) {
        if (iinventory == null) {
            return null;
        }
        if (iinventory instanceof ISidedInventory) {
            return ((ISidedInventory)iinventory).func_180463_a(side);
        }
        int[] slots = new int[iinventory.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public static ItemStack extractFromInventory(IInventory iinventory, EnumFacing side) {
        return Utils.extractFromInventory(iinventory, side, 1);
    }

    public static ItemStack extractFromInventory(IInventory iinventory, EnumFacing side, int maxStackSize) {
        IInventory invt = Utils.getInventory(iinventory);
        return Utils.extractFromSlots(invt, side, maxStackSize, Utils.getSlotsFromSide(invt, side));
    }

    private static ItemStack extractFromSlots(IInventory iinventory, EnumFacing side, int maxStackSize, int[] slots) {
        for (int slot : slots) {
            ItemStack invtStack = iinventory.func_70301_a(slot);
            if (invtStack.func_190926_b() || iinventory instanceof ISidedInventory && !((ISidedInventory)iinventory).func_180461_b(slot, invtStack, side)) continue;
            ItemStack copy = invtStack.func_77946_l();
            if (maxStackSize <= 0) {
                iinventory.func_70299_a(slot, ItemStack.field_190927_a);
            } else {
                int amount = Math.min(maxStackSize, invtStack.func_190916_E());
                invtStack.func_190918_g(amount);
                copy.func_190920_e(amount);
                if (invtStack.func_190926_b()) {
                    iinventory.func_70299_a(slot, ItemStack.field_190927_a);
                }
            }
            return copy;
        }
        return null;
    }

    public static boolean addEntitytoInventory(IInventory iinventoryTo, EntityItem entity) {
        if (entity == null) {
            return false;
        }
        boolean flag = Utils.addItemStackToInventory(iinventoryTo, entity.func_92059_d());
        if (flag) {
            entity.func_70106_y();
        } else if (entity.func_92059_d().func_190926_b()) {
            entity.func_70106_y();
        }
        return flag;
    }

    public static boolean addItemStackToInventory(IInventory iinventoryTo, ItemStack stack) {
        return Utils.addItemStackToInventory(iinventoryTo, stack, EnumFacing.DOWN);
    }

    public static boolean addItemStackToInventory(IInventory iinventoryTo, ItemStack stack, EnumFacing side) {
        if (iinventoryTo == null) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        IInventory invtTo = Utils.getInventory(iinventoryTo);
        return Utils.addToSlots(invtTo, stack, side, Utils.getSlotsFromSide(invtTo, side));
    }

    private static boolean addToSlots(IInventory iinventory, ItemStack stack, EnumFacing side, int[] slots) {
        for (int slot : slots) {
            if (!(iinventory instanceof ISidedInventory) ? !iinventory.func_94041_b(slot, stack) : !((ISidedInventory)iinventory).func_180462_a(slot, stack, side)) continue;
            if (iinventory.func_70301_a(slot).func_190926_b()) {
                iinventory.func_70299_a(slot, stack.func_77946_l());
                stack.func_190920_e(0);
                return true;
            }
            ItemStack invtStack = iinventory.func_70301_a(slot);
            if (invtStack.func_190916_E() >= Math.min(invtStack.func_77976_d(), iinventory.func_70297_j_()) || !Utils.areStacksTheSame(invtStack, stack, false)) continue;
            invtStack.func_190917_f(stack.func_190916_E());
            if (invtStack.func_190916_E() > invtStack.func_77976_d()) {
                stack.func_190920_e(invtStack.func_77976_d() - invtStack.func_190916_E());
                invtStack.func_190920_e(invtStack.func_77976_d());
            } else {
                stack.func_190920_e(0);
            }
            return true;
        }
        return false;
    }

    public static boolean areStacksSameOre(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        if (Utils.areStacksTheSame(stack1, stack2, false)) {
            return true;
        }
        List<String> ores1 = Utils.getOreNames(stack1);
        List<String> ores2 = Utils.getOreNames(stack2);
        if (ores1.isEmpty() || ores2.isEmpty()) {
            return false;
        }
        for (String ore2 : ores2) {
            if (!ores1.contains(ore2)) continue;
            return Utils.isIntercheageableOreName(ore2);
        }
        return false;
    }

    private static boolean isIntercheageableOreName(String name) {
        for (String prefix : orePrefixes) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)id));
        }
        return list;
    }

    public static boolean isItemOre(ItemStack stack, String ore) {
        int oreID = OreDictionary.getOreID((String)ore);
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (id != oreID) continue;
            return true;
        }
        return false;
    }

    public static boolean areStacksTheSame(ItemStack stack1, ItemStack stack2, boolean matchSize) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        if (!(stack1.func_77973_b() != stack2.func_77973_b() || stack1.func_77952_i() != stack2.func_77952_i() && !Utils.isWildcard(stack1.func_77952_i()) && !Utils.isWildcard(stack2.func_77952_i()) || matchSize && stack1.func_190916_E() != stack2.func_190916_E())) {
            if (stack1.func_77942_o() && stack2.func_77942_o()) {
                return stack1.func_77978_p().equals((Object)stack2.func_77978_p());
            }
            return stack1.func_77942_o() == stack2.func_77942_o();
        }
        return false;
    }

    private static boolean isWildcard(int meta) {
        return meta == Short.MAX_VALUE;
    }

    public static IInventory getInventory(IInventory inventory) {
        if (inventory instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inventory;
            TileEntityChest adjacent = null;
            if (chest.field_145991_k != null) {
                adjacent = chest.field_145991_k;
            }
            if (chest.field_145991_k != null) {
                adjacent = chest.field_145991_k;
            }
            if (chest.field_145990_j != null) {
                adjacent = chest.field_145990_j;
            }
            if (chest.field_145992_i != null) {
                adjacent = chest.field_145992_i;
            }
            if (chest.field_145988_l != null) {
                adjacent = chest.field_145988_l;
            }
            if (adjacent != null) {
                return new InventoryLargeChest("", (ILockableContainer)inventory, (ILockableContainer)adjacent);
            }
        }
        return inventory;
    }

    public static void dropInventoryContents(TileEntity tile) {
        if (tile == null || !(tile instanceof IInventory)) {
            return;
        }
        IInventory iinventory = (IInventory)tile;
        for (int i = 0; i < iinventory.func_70302_i_(); ++i) {
            ItemStack stack = iinventory.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() == null || stack.func_190916_E() <= 0) continue;
            Utils.dropStack(tile.func_145831_w(), tile.func_174877_v(), stack.func_77946_l());
            iinventory.func_70299_a(i, ItemStack.field_190927_a);
        }
        tile.func_70296_d();
    }

    public static boolean inventoryContains(IInventory iinventory, ItemStack stack, boolean ignoreSize) {
        return Utils.inventoryContains(iinventory, stack, ignoreSize, Utils.getSlotsFromSide(iinventory, EnumFacing.DOWN));
    }

    public static boolean inventoryContains(IInventory iinventory, ItemStack stack, boolean ignoreSize, int ... slots) {
        if (stack.func_190926_b()) {
            return false;
        }
        iinventory = Utils.getInventory(iinventory);
        int totalSize = 0;
        for (int slot : slots) {
            ItemStack invtStack = iinventory.func_70301_a(slot);
            if (Utils.areStacksTheSame(invtStack, stack, false)) {
                if (ignoreSize) {
                    return true;
                }
                totalSize += invtStack.func_190916_E();
            }
            if (totalSize < stack.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public static boolean deleteFromInventory(IInventory iinventory, EnumFacing side, ItemStack stack) {
        return Utils.deleteFromSlots(iinventory, stack, Utils.getSlotsFromSide(iinventory, side));
    }

    public static boolean deleteFromSlots(IInventory iinventory, ItemStack stack, int ... slots) {
        if (!Utils.inventoryContains(iinventory = Utils.getInventory(iinventory), stack, false)) {
            return false;
        }
        int totalDel = 0;
        for (int slot : slots) {
            ItemStack invtStack = iinventory.func_70301_a(slot);
            if (Utils.areStacksTheSame(invtStack, stack, false) || Utils.areStacksSameOre(invtStack, stack)) {
                if (invtStack.func_190916_E() >= stack.func_190916_E()) {
                    invtStack.func_190918_g(stack.func_77976_d() - invtStack.func_190916_E());
                    if (invtStack.func_190916_E() <= 0) {
                        iinventory.func_70299_a(slot, Utils.getContainer(stack));
                    }
                    return true;
                }
                totalDel += invtStack.func_190916_E();
                iinventory.func_70299_a(slot, Utils.getContainer(stack));
            }
            if (totalDel != stack.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getContainer(ItemStack stack) {
        return stack.func_77973_b().hasContainerItem(stack) ? stack.func_77973_b().getContainerItem(stack) : ItemStack.field_190927_a;
    }

    public static final LinkedHashMap<Short, Short> getEnchantments(ItemStack stack) {
        NBTTagList list;
        LinkedHashMap<Short, Short> map = new LinkedHashMap<Short, Short>();
        NBTTagList nBTTagList = list = stack.func_77973_b() == Items.field_151134_bR ? stack.func_77986_q() : stack.func_77986_q();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                map.put(tag.func_74765_d("id"), tag.func_74765_d("lvl"));
            }
        }
        return map;
    }
}

