/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.ai.EntityAIErebusAttackMelee;
import erebus.entity.ai.FlyingMoveHelper;
import erebus.entity.ai.PathNavigateFlying;
import erebus.items.ItemMaterials;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityLocust
extends EntityMob {
    public boolean canJump = true;

    public EntityLocust(World world) {
        super(world);
        this.func_70105_a(2.0f, 1.0f);
        this.field_70765_h = new FlyingMoveHelper((EntityCreature)this);
        this.field_70138_W = 1.0f;
        this.field_70747_aH = 0.05f;
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIErebusAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIRandomJumpWhenIdle(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIFlyingWander(this, 0.75, 10));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 100.0 : 100.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 4.0 : 4.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateFlying((EntityLiving)this, world);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.LOCUST_SOUND;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.LOCUST_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int chance = this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(1 + looting);
        for (int amount = 0; amount < chance; ++amount) {
            this.func_70099_a(new ItemStack(ModItems.MATERIALS, amount, ItemMaterials.EnumErebusMaterialsType.ELASTIC_FIBRE.ordinal()), 0.0f);
        }
    }

    public boolean randJump() {
        return this.field_70146_Z.nextInt(50) == 0;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.75;
        this.setCanJump(false);
    }

    public void setCanJump(boolean ableToJump) {
        this.canJump = ableToJump;
    }

    public void func_70636_d() {
        this.field_70181_x = this.func_70605_aq().func_75640_a() && this.field_70181_x < 0.0 ? (this.field_70181_x *= 0.2) : (this.field_70181_x *= 0.75);
        if (this.func_70090_H()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.32);
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            if (super.func_70652_k(entity) && entity instanceof EntityLivingBase) {
                int duration = 0;
                if (this.func_130014_f_().func_175659_aa().ordinal() > EnumDifficulty.EASY.ordinal()) {
                    if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL) {
                        duration = 8;
                    } else if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) {
                        duration = 15;
                    }
                }
                if (duration > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public class AIRandomJumpWhenIdle
    extends EntityAIBase {
        private final EntityLocust locust;
        private int idleTime;

        public AIRandomJumpWhenIdle(EntityLocust locustIn) {
            this.func_75248_a(3);
            this.locust = locustIn;
        }

        public boolean func_75250_a() {
            return this.locust.func_70681_au().nextFloat() < 0.02f && this.locust.field_70122_E && this.locust.canJump;
        }

        public boolean func_75253_b() {
            return this.idleTime >= 0;
        }

        public void func_75249_e() {
            this.locust.func_70664_aZ();
            this.idleTime = 20 + this.locust.func_70681_au().nextInt(20);
        }

        public void func_75246_d() {
            if (this.locust.field_70122_E && !this.locust.canJump) {
                this.locust.setCanJump(true);
            }
            --this.idleTime;
        }
    }

    public class AIFlyingWander
    extends EntityAIWander {
        private final EntityLocust locust;

        public AIFlyingWander(EntityLocust locustIn, double speedIn, int chance) {
            super((EntityCreature)locustIn, speedIn, chance);
            this.func_75248_a(1);
            this.locust = locustIn;
        }

        @Nullable
        protected Vec3d func_190864_f() {
            return RandomPositionGenerator.func_75463_a((EntityCreature)this.locust, (int)32, (int)32);
        }
    }
}

