/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import erebus.blocks.BlockUmberFurnace;
import erebus.inventory.ContainerUmberFurnace;
import erebus.tileentity.TileEntityBasicInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityUmberFurnace
extends TileEntityBasicInventory
implements ITickable {
    private final FluidTank tank = new FluidTank(16000);
    private final int BUCKET_SLOT = 0;
    private final int SMELT_SLOT = 1;
    private final int FUEL_SLOT = 2;
    private final int RESULT_SLOT = 3;
    private final int COOK_TIME_BASE = 200;
    private int cookTime = 200;
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int furnaceCookTime;
    private int prevFurnaceCookTime;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileEntityUmberFurnace() {
        super(4, "container.umberFurnace");
        this.tank.setFluid(new FluidStack(FluidRegistry.LAVA, 0));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public ItemStack fillTankWithBucket(ItemStack bucket) {
        if (this.tank.getFluidAmount() <= this.tank.getCapacity() - 1000 && FluidUtil.getFluidHandler((ItemStack)bucket) != null && FluidUtil.getFluidContained((ItemStack)bucket) != null && FluidUtil.getFluidContained((ItemStack)bucket).getFluid() == FluidRegistry.LAVA && bucket.func_190916_E() == 1) {
            this.tank.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
            IFluidHandlerItem cap = (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            cap.drain(new FluidStack(FluidUtil.getFluidContained((ItemStack)bucket), 1000), true);
            return FluidUtil.getFluidHandler((ItemStack)bucket).getContainer().func_77946_l();
        }
        return bucket;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.prevFurnaceCookTime = this.furnaceCookTime;
            return;
        }
        this.getInventory().set(0, (Object)this.fillTankWithBucket((ItemStack)this.getInventory().get(0)));
        this.cookTime = 200 - (int)(160.0f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()));
        boolean isBurning = this.furnaceBurnTime > 0;
        boolean isDirty = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.func_145831_w().field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)this.getInventory().get(2)));
                if (this.furnaceBurnTime > 0) {
                    isDirty = true;
                    if (!((ItemStack)this.getInventory().get(2)).func_190926_b()) {
                        ((ItemStack)this.getInventory().get(2)).func_190918_g(1);
                        if (((ItemStack)this.getInventory().get(2)).func_190916_E() == 0) {
                            this.getInventory().set(2, (Object)((ItemStack)this.getInventory().get(2)).func_77973_b().getContainerItem((ItemStack)this.getInventory().get(2)));
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime >= this.cookTime) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    isDirty = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (isBurning != this.furnaceBurnTime > 0) {
                isDirty = true;
                BlockUmberFurnace.setState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (isDirty) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (((ItemStack)this.getInventory().get(1)).func_190926_b()) {
            return false;
        }
        ItemStack is = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.getInventory().get(1));
        if (is.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.getInventory().get(3)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.getInventory().get(3)).func_77969_a(is)) {
            return false;
        }
        int result = ((ItemStack)this.getInventory().get(3)).func_190916_E() + is.func_190916_E();
        return result <= this.func_70297_j_() && result <= is.func_77976_d();
    }

    private void smeltItem() {
        if (this.canSmelt()) {
            ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.getInventory().get(1));
            if (((ItemStack)this.getInventory().get(3)).func_190926_b()) {
                this.getInventory().set(3, (Object)stack.func_77946_l());
            } else if (((ItemStack)this.getInventory().get(3)).func_77969_a(stack)) {
                ((ItemStack)this.getInventory().get(3)).func_190917_f(stack.func_190916_E());
            }
            this.tank.drain(100, true);
            ((ItemStack)this.getInventory().get(1)).func_190918_g(1);
            if (((ItemStack)this.getInventory().get(1)).func_190916_E() <= 0) {
                this.getInventory().set(1, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 ? FluidUtil.getFluidHandler((ItemStack)is) != null : (slot == 2 ? TileEntityFurnace.func_145954_b((ItemStack)is) : (slot == 1 ? !FurnaceRecipes.func_77602_a().func_151395_a(is).func_190926_b() : false));
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[2];
            nArray2[0] = 3;
            nArray = nArray2;
            nArray2[1] = 0;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 2;
            nArray = nArray3;
            nArray3[2] = 1;
        }
        return nArray;
    }

    public boolean func_180461_b(int slot, ItemStack is, EnumFacing direction) {
        return slot == 0 ? FluidUtil.getFluidHandler((ItemStack)is) != null : true;
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing direction) {
        return this.func_94041_b(slot, itemstack);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    @Override
    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            FluidTank myTanks = this.tank;
            return (T)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return TileEntityUmberFurnace.this.tank.getTankProperties();
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (resource == null || resource.getFluid() != FluidRegistry.LAVA) {
                        return 0;
                    }
                    return TileEntityUmberFurnace.this.tank.fill(resource, doFill);
                }

                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    FluidStack ret = TileEntityUmberFurnace.this.tank.drain(resource, doDrain);
                    if (ret != null && ret.amount != 0) {
                        return ret;
                    }
                    return null;
                }

                public FluidStack drain(int maxDrain, boolean doDrain) {
                    FluidStack ret = TileEntityUmberFurnace.this.tank.drain(maxDrain, doDrain);
                    if (ret != null && ret.amount != 0) {
                        return ret;
                    }
                    return null;
                }
            };
        }
        return super.getCapability(capability, facing);
    }

    public int getScaledFluidAmount(float scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().amount / (float)this.tank.getCapacity() * scale) : 0;
    }

    public String getFluidAmount() {
        return this.tank.getFluidAmount() + " mB";
    }

    public void getGUIData(int id, int value) {
        switch (id) {
            case 1: {
                if (this.tank.getFluid() == null) {
                    this.tank.setFluid(new FluidStack(FluidRegistry.LAVA, value));
                    break;
                }
                this.tank.getFluid().amount = value;
                break;
            }
            case 2: {
                this.furnaceBurnTime = value;
                break;
            }
            case 3: {
                this.furnaceCookTime = value;
                break;
            }
            case 4: {
                this.cookTime = value;
                break;
            }
            case 5: {
                this.currentItemBurnTime = value;
            }
        }
    }

    public void sendGUIData(ContainerUmberFurnace furnace, IContainerListener listener) {
        listener.func_71112_a((Container)furnace, 1, this.tank.getFluid() != null ? this.tank.getFluid().amount : 0);
        listener.func_71112_a((Container)furnace, 2, this.furnaceBurnTime);
        listener.func_71112_a((Container)furnace, 3, this.furnaceCookTime);
        listener.func_71112_a((Container)furnace, 4, this.cookTime);
        listener.func_71112_a((Container)furnace, 5, this.currentItemBurnTime);
    }

    @SideOnly(value=Side.CLIENT)
    public float getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.cookTime;
        }
        return (float)(this.furnaceBurnTime * scale) / (float)this.currentItemBurnTime;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCookProgressScaled(int scale) {
        return (float)(this.furnaceCookTime * scale) / (float)this.cookTime;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPrevCookProgressScaled(int scale) {
        return (float)(this.prevFurnaceCookTime * scale) / (float)this.cookTime;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tank.readFromNBT(data);
        this.currentItemBurnTime = data.func_74762_e("currentItemBurnTime");
        this.furnaceBurnTime = data.func_74762_e("furnaceBurnTime");
        this.furnaceCookTime = data.func_74762_e("furnaceCookTime");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.tank.writeToNBT(data);
        data.func_74768_a("currentItemBurnTime", this.currentItemBurnTime);
        data.func_74768_a("furnaceBurnTime", this.furnaceBurnTime);
        data.func_74768_a("furnaceCookTime", this.furnaceCookTime);
        return data;
    }
}

