/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.plant;

import erebus.blocks.EnumWood;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBamboo
extends WorldGenerator {
    private int bambooAmount = -1;
    private boolean checkForWater = true;
    private boolean isFarmed = false;

    public WorldGenBamboo(int bambooAmount, boolean checkForWater) {
        this.bambooAmount = bambooAmount;
        this.checkForWater = checkForWater;
        this.isFarmed = false;
    }

    public WorldGenBamboo(boolean isFarmed, boolean checkForWater) {
        this.checkForWater = checkForWater;
        this.isFarmed = isFarmed;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.checkForWater) {
            boolean canSpawn = false;
            for (int waterAttempt = 0; waterAttempt < 40; ++waterAttempt) {
                if (world.func_180495_p(new BlockPos(x + rand.nextInt(8) - rand.nextInt(8), y + rand.nextInt(3) - rand.nextInt(6), z + rand.nextInt(8) - rand.nextInt(8))).func_185904_a() != Material.field_151586_h) continue;
                canSpawn = true;
                break;
            }
            if (!canSpawn) {
                return false;
            }
        }
        if (!this.isFarmed) {
            int bambooPlaced = 0;
            block1: for (int attempt = 0; attempt < this.bambooAmount * 2 && bambooPlaced < this.bambooAmount; ++attempt) {
                int xx = x + rand.nextInt(8) - rand.nextInt(8);
                int zz = z + rand.nextInt(8) - rand.nextInt(8);
                for (int yy = y - 4; yy <= y + 4; ++yy) {
                    if (!world.func_175623_d(new BlockPos(xx, yy, zz)) || world.func_180495_p(new BlockPos(xx, yy - 1, zz)) != Blocks.field_150349_c.func_176223_P()) continue;
                    world.func_175656_a(new BlockPos(xx, yy, zz), EnumWood.BAMBOO.getLog().func_176223_P());
                    int bambooHeight = rand.nextInt(6) + 4;
                    for (int bambooY = 1; bambooY < bambooHeight && world.func_175623_d(new BlockPos(xx, yy + bambooY, zz)); ++bambooY) {
                        world.func_175656_a(new BlockPos(xx, yy + bambooY, zz), EnumWood.BAMBOO.getLog().func_176223_P());
                    }
                    ++bambooPlaced;
                    continue block1;
                }
            }
        } else {
            int bambooHeight = rand.nextInt(6) + 4;
            for (int bambooY = 0; bambooY < bambooHeight && world.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + bambooY, pos.func_177952_p())); ++bambooY) {
                world.func_180501_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + bambooY, pos.func_177952_p()), EnumWood.BAMBOO.getLog().func_176223_P(), 3);
            }
        }
        return true;
    }
}

