/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.plant;

import erebus.ModBlocks;
import erebus.blocks.BlockGiantFlower;
import erebus.blocks.BlockStigma;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenGiantFlowers
extends WorldGenerator {
    private int primaryPetalColor = -1;
    private int secondaryPetalColor = -1;
    private static final int[] offsetX = new int[]{-1, 1, 0, 0};
    private static final int[] offsetZ = new int[]{0, 0, -1, 1};

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int b;
        int a;
        int yy;
        int zz;
        int xx;
        int yy2;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        StemShape stemShape = StemShape.values()[rand.nextInt(StemShape.values().length)];
        PetalShape petalShape = PetalShape.values()[rand.nextInt(PetalShape.values().length)];
        int stemHeight = rand.nextInt(6) + 2;
        if (this.primaryPetalColor == -1) {
            this.primaryPetalColor = rand.nextInt(13);
        }
        if (this.secondaryPetalColor == -1) {
            this.secondaryPetalColor = petalShape.canHaveSecondaryColor && rand.nextInt(8) == 0 ? rand.nextInt(13) : this.primaryPetalColor;
        }
        for (yy2 = y + 2; yy2 <= y + stemHeight; ++yy2) {
            if (world.func_175623_d(new BlockPos(x, yy2, z))) continue;
            return false;
        }
        for (xx = x - stemShape.rad; xx <= x + stemShape.rad; ++xx) {
            for (zz = z - stemShape.rad; zz <= z + stemShape.rad; ++zz) {
                for (yy = y; yy <= y + stemShape.height; ++yy) {
                    if (world.func_175623_d(new BlockPos(xx, yy, zz))) continue;
                    return false;
                }
                if (!world.func_175623_d(new BlockPos(xx, y - 1, zz))) continue;
                return false;
            }
        }
        for (xx = x - petalShape.rad; xx <= x + petalShape.rad; ++xx) {
            for (zz = z - petalShape.rad; zz <= z + petalShape.rad; ++zz) {
                for (yy = y + stemHeight + 1; yy <= y + stemHeight + 1 + petalShape.height; ++yy) {
                    if (world.func_175623_d(new BlockPos(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        switch (stemShape) {
            case SMALL_X: {
                for (a = 0; a < 2; ++a) {
                    for (b = 0; b < 2; ++b) {
                        world.func_180501_a(new BlockPos(x - 1 + a * 2, y, z - 1 + b * 2), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                    }
                }
                break;
            }
            case SMALL_PLUS: {
                for (a = 0; a < 4; ++a) {
                    world.func_180501_a(new BlockPos(x + offsetX[a], y, z + offsetZ[a]), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                }
                break;
            }
            case LARGE_PLUS: {
                for (a = 0; a < 4; ++a) {
                    world.func_180501_a(new BlockPos(x + offsetX[a] * 2, y, z + offsetZ[a] * 2), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                    world.func_180501_a(new BlockPos(x + offsetX[a], y + 1, z + offsetZ[a]), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                }
                break;
            }
        }
        for (yy2 = y; yy2 <= y + stemHeight; ++yy2) {
            world.func_180501_a(new BlockPos(x, yy2, z), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
        }
        y += stemHeight + 1;
        switch (petalShape) {
            case DENSE_HEMISPHERE: {
                int b2;
                int a2;
                world.func_180501_a(new BlockPos(x, y, z), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                for (a = 0; a < 4; ++a) {
                    world.func_180501_a(new BlockPos(x + offsetX[a], y, z + offsetZ[a]), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                    world.func_180501_a(new BlockPos(x + offsetX[a] * 2, y + 1, z + offsetZ[a] * 2), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                    if (rand.nextInt(3) != 0) continue;
                    world.func_180501_a(new BlockPos(x + offsetX[a] * 3, y + 2, z + offsetZ[a] * 3), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                }
                for (xx = x - 1; xx <= x + 1; ++xx) {
                    for (zz = z - 1; zz <= z + 1; ++zz) {
                        world.func_180501_a(new BlockPos(xx, y + 1, zz), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                    }
                }
                for (a = 0; a < 3; ++a) {
                    for (b = 0; b < 2; ++b) {
                        world.func_180501_a(new BlockPos(x - 2 + b * 4, y + 2, z - 1 + a), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                        world.func_180501_a(new BlockPos(x - 1 + a, y + 2, z - 2 + b * 4), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                    }
                    world.func_180501_a(new BlockPos(x - 1 + a, y + 2, z), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                }
                for (a = 0; a < 2; ++a) {
                    world.func_180501_a(new BlockPos(x, y + 2, z - 1 + a * 2), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                }
                if (rand.nextInt(10) == 0) {
                    world.func_180501_a(new BlockPos(x, y + 3, z), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.EXPLODING_STIGMA)), 2);
                } else {
                    world.func_180501_a(new BlockPos(x, y + 3, z), ModBlocks.GIANT_FLOWER_STIGMA.func_176223_P().func_177226_a(BlockStigma.TYPE, (Comparable)((Object)BlockStigma.EnumType.values()[petalShape.canHaveSecondaryColor ? 14 : this.primaryPetalColor])), 3);
                }
                for (a = 0; a < 3; ++a) {
                    for (b = 0; b < 2; ++b) {
                        world.func_180501_a(new BlockPos(x - 3 + b * 6, y + 3, z - 1 + a), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                        world.func_180501_a(new BlockPos(x - 1 + a, y + 3, z - 3 + b * 6), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                    }
                }
                for (a = -1; a <= 1; ++a) {
                    for (b = -1; b <= 1; ++b) {
                        if (a == 0 && b == 0) continue;
                        world.func_180501_a(new BlockPos(x + a * 2, y + 3, z + b * 2), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                    }
                }
                boolean petalFormation = rand.nextBoolean();
                for (a2 = 0; a2 < 2; ++a2) {
                    for (b2 = 0; b2 < 2; ++b2) {
                        if (petalFormation) {
                            world.func_180501_a(new BlockPos(x - 3 + a2 * 6, y + 4, z - 1 + b2 * 2), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                            world.func_180501_a(new BlockPos(x - 1 + a2 * 2, y + 4, z - 3 + b2 * 6), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                            continue;
                        }
                        world.func_180501_a(new BlockPos(x - 2 + a2 * 4, y + 4, z - 2 + b2 * 4), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                        world.func_180501_a(new BlockPos(x + offsetX[a2 * 2 + b2] * 3, y + 4, z + offsetZ[a2 * 2 + b2] * 3), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                    }
                }
                break;
            }
            case DISPERSE_HEMISPHERE: {
                int b2;
                int a2;
                world.func_180501_a(new BlockPos(x, y, z), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                if (rand.nextInt(10) == 0) {
                    world.func_180501_a(new BlockPos(x, y + 1, z), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.EXPLODING_STIGMA)), 2);
                } else {
                    world.func_180501_a(new BlockPos(x, y + 1, z), ModBlocks.GIANT_FLOWER_STIGMA.func_176223_P().func_177226_a(BlockStigma.TYPE, (Comparable)((Object)BlockStigma.EnumType.values()[petalShape.canHaveSecondaryColor ? 14 : this.primaryPetalColor])), 3);
                }
                for (a2 = 0; a2 < 4; ++a2) {
                    for (b2 = 1; b2 <= 3; ++b2) {
                        world.func_180501_a(new BlockPos(x + offsetX[a2] * b2, y + b2 - 1, z + offsetZ[a2] * b2), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.secondaryPetalColor])), 2);
                    }
                }
                for (a2 = 0; a2 < 2; ++a2) {
                    for (b2 = 0; b2 < 2; ++b2) {
                        world.func_180501_a(new BlockPos(x - 1 + a2 * 2, y + 1, z - 1 + b2 * 2), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                        world.func_180501_a(new BlockPos(x - 2 + a2 * 4, y + 2, z - 2 + b2 * 4), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                    }
                }
                break;
            }
            case UMBRELLA: {
                int a2;
                world.func_180501_a(new BlockPos(x, y, z), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                for (a2 = 0; a2 < 4; ++a2) {
                    world.func_180501_a(new BlockPos(x + offsetX[a2], y, z + offsetZ[a2]), ModBlocks.GIANT_FLOWER.func_176223_P(), 2);
                }
                world.func_180501_a(new BlockPos(x, y + 1, z), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                if (rand.nextInt(10) == 0) {
                    world.func_180501_a(new BlockPos(x, y + 2, z), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.EXPLODING_STIGMA)), 2);
                } else {
                    world.func_180501_a(new BlockPos(x, y + 2, z), ModBlocks.GIANT_FLOWER_STIGMA.func_176223_P().func_177226_a(BlockStigma.TYPE, (Comparable)((Object)BlockStigma.EnumType.values()[petalShape.canHaveSecondaryColor ? 14 : this.primaryPetalColor])), 3);
                }
                for (a2 = 0; a2 < 3; ++a2) {
                    world.func_180501_a(new BlockPos(x - 3 + a2, y + 1, z), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                    world.func_180501_a(new BlockPos(x + 3 - a2, y + 1, z), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                    world.func_180501_a(new BlockPos(x, y + 1, z - 3 + a2), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                    world.func_180501_a(new BlockPos(x, y + 1, z + 3 - a2), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                }
                boolean reversedUmbrella = rand.nextInt(3) == 0;
                for (int a3 = 0; a3 < 2; ++a3) {
                    for (int b3 = 0; b3 < 2; ++b3) {
                        world.func_180501_a(new BlockPos(x - 1 + a3 * 2, y + 1, z - 1 + b3 * 2), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.secondaryPetalColor])), 2);
                        world.func_180501_a(new BlockPos(x - 2 + a3 * 4, y + 1, z - 2 + b3 * 4), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.secondaryPetalColor])), 2);
                        world.func_180501_a(new BlockPos(x - 3 + a3 * 6, y + (reversedUmbrella ? 2 : 0), z - 3 + b3 * 6), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.secondaryPetalColor])), 2);
                        world.func_180501_a(new BlockPos(x + offsetX[a3 * 2 + b3] * 4, y + (reversedUmbrella ? 2 : 0), z + offsetZ[a3 * 2 + b3] * 4), ModBlocks.GIANT_FLOWER.func_176223_P().func_177226_a(BlockGiantFlower.TYPE, (Comparable)((Object)BlockGiantFlower.EnumType.values()[this.primaryPetalColor])), 2);
                    }
                }
                break;
            }
        }
        this.secondaryPetalColor = -1;
        this.primaryPetalColor = -1;
        return true;
    }

    public void setFlowerColor(int color) {
        this.setFlowerColor(color, color);
    }

    public void setFlowerColor(int primary, int secondary) {
        this.primaryPetalColor = primary;
        this.secondaryPetalColor = secondary;
    }

    private static enum PetalShape {
        DENSE_HEMISPHERE(3, 5, false),
        DISPERSE_HEMISPHERE(3, 3, true),
        UMBRELLA(4, 3, true);

        final byte rad;
        final byte height;
        final boolean canHaveSecondaryColor;

        private PetalShape(int rad, int height, boolean canHaveSecondaryColor) {
            this.rad = (byte)rad;
            this.height = (byte)height;
            this.canHaveSecondaryColor = canHaveSecondaryColor;
        }
    }

    private static enum StemShape {
        SMALL_X(1, 1),
        SMALL_PLUS(1, 1),
        LARGE_PLUS(2, 2);

        final byte rad;
        final byte height;

        private StemShape(int rad, int height) {
            this.rad = (byte)rad;
            this.height = (byte)height;
        }
    }
}

