/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.plant;

import erebus.ModBlocks;
import erebus.blocks.BlockErebusMushroomHuge;
import erebus.core.helper.MathUtil;
import erebus.world.feature.WorldGenErebus;
import erebus.world.feature.util.OldForgeDirection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;

public class WorldGenGiantMushrooms
extends WorldGenErebus {
    private static final int stalkMeta = 10;
    private static final int bulbFullMeta = 14;
    public static final int[] offsetX = new int[]{0, -1, 0, 1};
    public static final int[] offsetZ = new int[]{1, 0, -1, 0};
    private MushroomType mushroomType = MushroomType.DARK_CAPPED;
    private final List<BlockPos> bulbs = new ArrayList<BlockPos>();

    public void setMushroomType(MushroomType type) {
        this.mushroomType = type;
    }

    @Override
    protected boolean generate(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.bulbs.clear();
        Block mushroom = this.mushroomType.block;
        boolean res = false;
        switch (this.mushroomType) {
            case DARK_CAPPED: {
                res = this.genBulbCapped(x, y, z, mushroom);
                break;
            }
            case KAIZERS_FINGERS: {
                res = this.genKaizersFingers(x, y, z, mushroom);
                break;
            }
            case DUTCH_CAP: {
                res = this.genDutchCap(x - 1, y, z, mushroom);
                break;
            }
            case GRANDMAS_SHOES: {
                res = this.genGrandmasShoes(x - 1, y, z, mushroom);
                break;
            }
            case SARCASTIC_CZECH: {
                res = this.genSarcasticCzech(x - 1, y, z, mushroom);
            }
        }
        if (res) {
            this.generateBulbs(x, z, mushroom);
            return true;
        }
        return false;
    }

    private boolean genBulbCapped(int x, int y, int z, Block mushroom) {
        int stalkHeight;
        int sideHeight = 1 + this.rand.nextInt((stalkHeight = 3 + this.rand.nextInt(3 + this.rand.nextInt(2))) > 3 ? 3 : 2);
        if (!this.checkAirCube(x, y, z, x, y + stalkHeight - sideHeight, z) || !this.checkAirCube(x - 2, y + stalkHeight - sideHeight + 1, z - 2, x + 2, y + stalkHeight + 1, z + 2)) {
            return false;
        }
        this.setBlockPillar(x, z, y, y + stalkHeight, mushroom, 10);
        y += stalkHeight + 1;
        for (int px = -1; px <= 1; ++px) {
            for (int pz = -1; pz <= 1; ++pz) {
                this.bulbs.add(new BlockPos(x + px, y, z + pz));
            }
        }
        for (int py = 1; py <= sideHeight; ++py) {
            for (int off = -1; off <= 1; ++off) {
                this.bulbs.add(new BlockPos(x + 2, y - py, z + off));
                this.bulbs.add(new BlockPos(x - 2, y - py, z + off));
                this.bulbs.add(new BlockPos(x + off, y - py, z + 2));
                this.bulbs.add(new BlockPos(x + off, y - py, z - 2));
            }
        }
        return true;
    }

    private boolean genKaizersFingers(int x, int y, int z, Block mushroom) {
        int mainShroomHeight = 4 + this.rand.nextInt(4);
        if (!(this.checkAirCube(x - 1, y + 3, z - 1, x + 1, y + mainShroomHeight + 1, z + 1) && this.checkAirCube(x - 4, y, z - 4, x + 4, y + 2, z + 4) && this.checkSolidCube(x - 4, y - 1, z - 4, x + 4, y - 1, z + 4))) {
            return false;
        }
        int sidesPlaced = 0;
        for (int py = 0; py <= mainShroomHeight; ++py) {
            this.setBlock(x, y + py, z, mushroom, 10);
            if (py < 2 || py >= mainShroomHeight - 1 || this.rand.nextInt(4 + sidesPlaced * 2) != 0) continue;
            int dir = this.rand.nextInt(4);
            this.setBlock(x + offsetX[dir], y + py, z + offsetZ[dir], mushroom, 14);
            ++sidesPlaced;
        }
        this.bulbs.add(new BlockPos(x, y + mainShroomHeight + 1, z));
        for (int a = 0; a < 4; ++a) {
            this.bulbs.add(new BlockPos(x + offsetX[a], y + mainShroomHeight, z + offsetZ[a]));
        }
        ArrayList<BlockPos> connectList = new ArrayList<BlockPos>();
        connectList.add(new BlockPos(x, y - 1, z));
        for (int smallShroomAttempt = 0; smallShroomAttempt < 4 + this.rand.nextInt(7); ++smallShroomAttempt) {
            int zz;
            int xx = x + this.rand.nextInt(4) - this.rand.nextInt(4);
            if (!this.isAir(xx, y, zz = z + this.rand.nextInt(4) - this.rand.nextInt(4)) || !this.isAir(xx - 1, y, zz) || !this.isAir(xx + 1, y, zz) || !this.isAir(xx, y, zz - 1) || !this.isAir(xx, y, zz + 1)) continue;
            int smallShroomHeight = this.rand.nextBoolean() ? 1 : 1 + this.rand.nextInt(2);
            this.setBlockPillar(xx, zz, y, y + smallShroomHeight - 1, mushroom, 10);
            this.setBlock(xx, y + smallShroomHeight, zz, mushroom, 14);
            connectList.add(new BlockPos(xx, y - 1, zz));
        }
        int coordAmt = connectList.size();
        for (int connectionAttempt = 0; connectionAttempt < 48; ++connectionAttempt) {
            double dist;
            BlockPos coords2;
            BlockPos coords1 = (BlockPos)connectList.get(this.rand.nextInt(coordAmt));
            BlockPos blockPos = coords2 = this.rand.nextInt(3) != 0 ? (BlockPos)connectList.get(0) : (BlockPos)connectList.get(this.rand.nextInt(coordAmt));
            if (coords1 == coords2 || (dist = MathUtil.distance(coords1.func_177958_n() - coords2.func_177958_n(), coords1.func_177952_p() - coords2.func_177952_p())) < 1.0) continue;
            int dir = this.rand.nextInt(4);
            int xx = coords1.func_177958_n() + offsetX[dir];
            int zz = coords1.func_177952_p() + offsetZ[dir];
            if (!(MathUtil.distance(xx - coords2.func_177958_n(), zz - coords2.func_177952_p()) < dist)) continue;
            this.setBlock(xx, y - 1, zz, mushroom, 10);
            if (this.rand.nextInt(16) == 0) {
                this.setBlock(xx, y, zz, mushroom, 10);
            }
            coords1.func_177982_a(offsetX[dir], 0, offsetZ[dir]);
        }
        return true;
    }

    private boolean genDutchCap(int x, int y, int z, Block mushroom) {
        int height = 9 + this.rand.nextInt(8);
        if (!(this.checkAirCube(x - 2, y, z - 2, x + 3, y + 4, z + 3) && this.checkAirCube(x - 3, y + 5, z - 3, x + 5, y + height + 1, z + 5) && this.checkAirCube(x - 4, y + height + 2, z - 4, x + 7, y + height + 4, z + 7) && this.checkSolidCube(x - 2, y - 1, z - 2, x + 3, y - 1, z + 3))) {
            return false;
        }
        for (int a = 0; a < 2; ++a) {
            for (int b = 0; b < 2; ++b) {
                this.setBlockPillar(x - 1 + 3 * a, z + b, y, y + 1, mushroom, 10);
                this.setBlockPillar(x + b, z - 1 + 3 * a, y, y + 1, mushroom, 10);
                this.setBlock(x - 1 + 3 * a, y, z - 1 + 3 * b, mushroom, 10);
                this.setBlock(x - 2 + 5 * a, y, z + b, mushroom, 10);
                this.setBlock(x + b, y, z - 2 + 5 * a, mushroom, 10);
            }
        }
        this.setBlockCube(x, y, z, x + 1, y + height, z + 1, mushroom, 10);
        for (int py = 4; py <= height; ++py) {
            boolean isTop;
            boolean bl = isTop = py >= height - 1;
            if (this.rand.nextInt(3) != 0 && !isTop) continue;
            for (int attempt = 0; attempt < (isTop ? 2 : 1); ++attempt) {
                int b;
                int a;
                int branchAddX = 0;
                int branchAddZ = 0;
                for (int branchAttempt = 0; branchAttempt < 12 && branchAddX == 0 && branchAddZ == 0; ++branchAttempt) {
                    branchAddX = this.rand.nextInt(3) != 0 ? 0 : this.rand.nextInt(3) - 1;
                    branchAddZ = this.rand.nextInt(3) != 0 ? 0 : this.rand.nextInt(3) - 1;
                }
                if (branchAddX == 0 && branchAddZ == 0 || !this.checkAirCube(x + branchAddX * 2, y + py - 2, z + branchAddZ * 2, x + branchAddX * 2 + 1, y + py, z + branchAddZ * 2 + 1)) continue;
                int branchSize = isTop ? 3 + this.rand.nextInt(2) : 2 + this.rand.nextInt(2 + this.rand.nextInt(2));
                for (int branch = 1; branch <= branchSize; ++branch) {
                    this.setBlockRect(x + branchAddX * branch, z + branchAddZ * branch, x + branchAddX * branch + 1, z + branchAddZ * branch + 1, y + py - 1 + branch, mushroom, 10);
                    if (!isTop) continue;
                    this.setBlockRect(x + branchAddX * branch, z + branchAddZ * branch, x + branchAddX * branch + 1, z + branchAddZ * branch + 1, y + py + branch, mushroom, 10);
                }
                int branchTopX = x + branchAddX * branchSize;
                int branchTopY = y + py + branchSize;
                int branchTopZ = z + branchAddZ * branchSize;
                if (isTop) {
                    this.setBlockRect(branchTopX, branchTopZ, branchTopX + 1, branchTopZ + 1, branchTopY + 1, mushroom, 10);
                    branchTopY += 2;
                    for (a = 0; a < 2; ++a) {
                        for (b = 0; b < 2; ++b) {
                            if (this.isAir(branchTopX + a, branchTopY, branchTopZ + b)) {
                                this.setBlock(branchTopX + a, branchTopY, branchTopZ + b, mushroom, 14);
                            }
                            if (this.isAir(branchTopX - 1 + 3 * a, branchTopY - 1, branchTopZ + b)) {
                                this.setBlock(branchTopX - 1 + 3 * a, branchTopY - 1, branchTopZ + b, mushroom, 14);
                            }
                            if (this.isAir(branchTopX + b, branchTopY - 1, branchTopZ - 1 + 3 * a)) {
                                this.setBlock(branchTopX + b, branchTopY - 1, branchTopZ - 1 + 3 * a, mushroom, 14);
                            }
                            if (this.isAir(branchTopX - 1 + 3 * a, branchTopY - 2, branchTopZ - 1 + 3 * b)) {
                                this.setBlock(branchTopX - 1 + 3 * a, branchTopY - 2, branchTopZ - 1 + 3 * b, mushroom, 14);
                            }
                            if (this.isAir(branchTopX - 2 + 5 * a, branchTopY - 2, branchTopZ + b)) {
                                this.setBlock(branchTopX - 2 + 5 * a, branchTopY - 2, branchTopZ + b, mushroom, 14);
                            }
                            if (!this.isAir(branchTopX + b, branchTopY - 2, branchTopZ - 2 + 5 * a)) continue;
                            this.setBlock(branchTopX + b, branchTopY - 2, branchTopZ - 2 + 5 * a, mushroom, 14);
                        }
                    }
                    continue;
                }
                for (a = 0; a < 2; ++a) {
                    for (b = 0; b < 2; ++b) {
                        if (this.isAir(branchTopX + a, branchTopY, branchTopZ + b)) {
                            this.setBlock(branchTopX + a, branchTopY, branchTopZ + b, mushroom, 14);
                        }
                        if (this.isAir(branchTopX - 1 + 3 * a, branchTopY - 1, branchTopZ + b)) {
                            this.setBlock(branchTopX - 1 + 3 * a, branchTopY - 1, branchTopZ + b, mushroom, 14);
                        }
                        if (!this.isAir(branchTopX + b, branchTopY - 1, branchTopZ - 1 + 3 * a)) continue;
                        this.setBlock(branchTopX + b, branchTopY - 1, branchTopZ - 1 + 3 * a, mushroom, 14);
                    }
                }
            }
        }
        return true;
    }

    private boolean genGrandmasShoes(int x, int y, int z, Block mushroom) {
        int b;
        int a;
        int splitOffZ;
        int height = 5 + this.rand.nextInt(8);
        int splits = this.rand.nextInt(height > 8 ? 3 : 2);
        int splitSize = splits == 0 ? height : (int)Math.ceil((float)height / (1.0f + (float)splits));
        int splitDir = splits != 0 ? this.rand.nextInt(4) : -1;
        int splitOffX = splitDir == -1 ? 0 : offsetX[splitDir];
        int n = splitOffZ = splitDir == -1 ? 0 : offsetZ[splitDir];
        if (!(this.checkAirCube(x - 1, y, z - 1, x + 2, y + height - 2, z + 2) && this.checkAirCube(x - 3 + splitOffX, z - 3 + splitOffZ, y + height - 1, x + 3 + splitOffX, y + height + 1, z + 3 + splitOffZ) && this.checkSolidCube(x - 1, y - 1, z - 1, x + 3, y - 1, z + 3))) {
            return false;
        }
        for (a = 0; a < 2; ++a) {
            for (b = 0; b < 2; ++b) {
                this.setBlockRect(x - 1 + 3 * b, z, x - 1 + 3 * b, z + 1, y, mushroom, 10);
                this.setBlockRect(x, z - 1 + 3 * b, x + 1, z - 1 + 3 * b, y, mushroom, 10);
            }
        }
        int split = splitSize;
        for (int py = 0; py <= height; ++py) {
            this.setBlockRect(x, z, x + 1, z + 1, y + py, mushroom, 10);
            if (--split >= 0 || py >= height) continue;
            x += splitOffX;
            z += splitOffZ;
            split = splitSize - 1;
        }
        for (a = 0; a < 2; ++a) {
            for (b = 0; b < 2; ++b) {
                this.bulbs.add(new BlockPos(x + a, y + height + 1, z + b));
                this.bulbs.add(new BlockPos(x - 1 + 3 * a, y + height + 1, z + b));
                this.bulbs.add(new BlockPos(x + b, y + height + 1, z - 1 + 3 * a));
                this.setBlock(x - 1 + 3 * a, y + height, z - 1 + 3 * b, mushroom, 5);
                this.bulbs.add(new BlockPos(x - 2 + 5 * a, y + height - 1, z - 2 + 5 * b));
            }
            for (b = 0; b < 4; ++b) {
                this.bulbs.add(new BlockPos(x - 2 + 5 * a, y + height, z - 1 + b));
                this.bulbs.add(new BlockPos(x - 1 + b, y + height, z - 2 + 5 * a));
                this.bulbs.add(new BlockPos(x - 3 + 7 * a, y + height - 1, z - 1 + b));
                this.bulbs.add(new BlockPos(x - 1 + b, y + height - 1, z - 3 + 7 * a));
            }
        }
        return true;
    }

    private boolean genSarcasticCzech(int x, int y, int z, Block mushroom) {
        int height = 2 + this.rand.nextInt(3);
        int armLength = 4 + this.rand.nextInt(3);
        if (!this.checkAirCube(x, y, z, x, y + height, z) || !this.checkAirCube(x - armLength, y + height, z - armLength, x + armLength, y + height + 1, z + armLength)) {
            return false;
        }
        this.setBlockPillar(x, z, y, y + height, mushroom, 10);
        this.setBlockPillar(x + 1, z, y, y + height, mushroom, 10);
        this.setBlockPillar(x, z + 1, y, y + height, mushroom, 10);
        this.setBlockPillar(x + 1, z + 1, y, y + height, mushroom, 10);
        y += height;
        for (OldForgeDirection[] dirs : new OldForgeDirection[][]{{OldForgeDirection.EAST, OldForgeDirection.SOUTH}, {OldForgeDirection.EAST, OldForgeDirection.NORTH}, {OldForgeDirection.WEST, OldForgeDirection.SOUTH}, {OldForgeDirection.WEST, OldForgeDirection.NORTH}}) {
            int i;
            int xx = x + dirs[0].offsetX;
            int yy = y;
            int zz = z + dirs[0].offsetZ;
            for (i = 0; i < armLength; ++i) {
                if (i % 2 == 0) {
                    ++yy;
                } else {
                    OldForgeDirection dir = dirs[this.rand.nextInt(dirs.length)];
                    xx += dir.offsetX;
                    zz += dir.offsetZ;
                }
                this.setBlock(xx, yy, zz, mushroom, 10);
            }
            this.setBlock(xx, yy + 1, zz, mushroom, 14);
            for (i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    this.setBlock(xx + i, yy, zz + j, mushroom, 14);
                }
            }
        }
        this.setBlockRect(x, z, x + 1, z + 1, y + 1, mushroom, 14);
        this.setBlockRect(x - 1, z - 1, x + 2, z + 2, y, mushroom, 14);
        return true;
    }

    private void generateBulbs(int centerX, int centerZ, Block mushroom) {
        for (BlockPos bulb : this.bulbs) {
            this.setBlock(bulb.func_177958_n(), bulb.func_177956_o(), bulb.func_177952_p(), mushroom);
        }
        for (BlockPos bulb : this.bulbs) {
            this.setMetadata(bulb.func_177958_n(), bulb.func_177956_o(), bulb.func_177952_p(), this.getBulbMetadata(centerX, centerZ, bulb));
        }
        this.bulbs.clear();
    }

    private int getBulbMetadata(int centerX, int centerZ, BlockPos bulb) {
        boolean posX = this.getBlock(bulb.func_177958_n() + 1, bulb.func_177956_o(), bulb.func_177952_p()) instanceof BlockErebusMushroomHuge;
        boolean negX = this.getBlock(bulb.func_177958_n() - 1, bulb.func_177956_o(), bulb.func_177952_p()) instanceof BlockErebusMushroomHuge;
        boolean posZ = this.getBlock(bulb.func_177958_n(), bulb.func_177956_o(), bulb.func_177952_p() + 1) instanceof BlockErebusMushroomHuge;
        boolean negZ = this.getBlock(bulb.func_177958_n(), bulb.func_177956_o(), bulb.func_177952_p() - 1) instanceof BlockErebusMushroomHuge;
        if (posX && negX && posZ && negZ) {
            return 5;
        }
        if (posX && negX) {
            if (bulb.func_177952_p() > centerZ) {
                return 8;
            }
            return 2;
        }
        if (posZ && negZ) {
            if (bulb.func_177958_n() > centerX) {
                return 6;
            }
            return 4;
        }
        if (posX && posZ) {
            return 1;
        }
        if (negX && negZ) {
            return 9;
        }
        if (negX && posZ) {
            return 3;
        }
        if (posX && negZ) {
            return 7;
        }
        int sides = (posX ? 1 : 0) + (negX ? 1 : 0) + (posZ ? 1 : 0) + (negZ ? 1 : 0);
        if (sides > 1) {
            return 0;
        }
        boolean posXposZ = this.getBlock(bulb.func_177958_n() + 1, bulb.func_177956_o(), bulb.func_177952_p() + 1) instanceof BlockErebusMushroomHuge;
        boolean negXposZ = this.getBlock(bulb.func_177958_n() - 1, bulb.func_177956_o(), bulb.func_177952_p() + 1) instanceof BlockErebusMushroomHuge;
        boolean posXnegZ = this.getBlock(bulb.func_177958_n() + 1, bulb.func_177956_o(), bulb.func_177952_p() - 1) instanceof BlockErebusMushroomHuge;
        boolean negXnegZ = this.getBlock(bulb.func_177958_n() - 1, bulb.func_177956_o(), bulb.func_177952_p() - 1) instanceof BlockErebusMushroomHuge;
        int corners = (posXposZ ? 1 : 0) + (negXposZ ? 1 : 0) + (posXnegZ ? 1 : 0) + (negXnegZ ? 1 : 0);
        if (sides == 0 && corners == 0) {
            return 14;
        }
        if (posXposZ && negXposZ || negXnegZ && posXnegZ || posXposZ && posXnegZ || negXposZ && negXnegZ) {
            return 14;
        }
        if (sides == 0 && corners == 2) {
            for (int dir = 0; dir < 4; ++dir) {
                int meta = this.getMetadata(bulb.func_177958_n() + offsetX[dir], bulb.func_177956_o() - 1, bulb.func_177952_p() + offsetZ[dir]);
                if (meta == 0) continue;
                return meta;
            }
        }
        if (sides == 1 && corners == 1 || sides == 0 && corners == 2) {
            if (bulb.func_177958_n() > centerX) {
                if (bulb.func_177952_p() > centerZ) {
                    return 9;
                }
                return 3;
            }
            if (bulb.func_177952_p() > centerZ) {
                return 7;
            }
            return 1;
        }
        return 0;
    }

    public static enum MushroomType {
        DARK_CAPPED(ModBlocks.DARK_CAPPED_MUSHROOM, ModBlocks.DARK_CAPPED_MUSHROOM_BLOCK),
        GRANDMAS_SHOES(ModBlocks.GRANDMAS_SHOES_MUSHROOM, ModBlocks.GRANDMAS_SHOES_MUSHROOM_BLOCK),
        SARCASTIC_CZECH(ModBlocks.SARCASTIC_CZECH_MUSHROOM, ModBlocks.SARCASTIC_CZECH_MUSHROOM_BLOCK),
        KAIZERS_FINGERS(ModBlocks.KAIZERS_FINGERS_MUSHROOM, ModBlocks.KAIZERS_FINGERS_MUSHROOM_BLOCK),
        DUTCH_CAP(ModBlocks.DUTCH_CAP_MUSHROOM, ModBlocks.DUTCH_CAP_MUSHROOM_BLOCK);

        public final Block mushroom;
        public final Block block;

        private MushroomType(Block mushroom, Block log) {
            this.block = log;
            this.mushroom = mushroom;
        }

        public static MushroomType getFromShroom(Block block) {
            for (MushroomType type : MushroomType.values()) {
                if (type.mushroom != block) continue;
                return type;
            }
            return null;
        }
    }
}

