/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.structure;

import erebus.ModBiomes;
import erebus.ModBlocks;
import erebus.ModFluids;
import erebus.ModItems;
import erebus.block.bamboo.BlockBambooTorch;
import erebus.blocks.BlockBones;
import erebus.blocks.BlockCapstone;
import erebus.blocks.BlockGneiss;
import erebus.blocks.BlockTempleBrickUnbreaking;
import erebus.blocks.BlockTempleTeleporter;
import erebus.entity.EntityAntlionBoss;
import erebus.entity.EntityUmberGolemDungeonTypes;
import erebus.items.ItemErebusFood;
import erebus.items.ItemMaterials;
import erebus.items.ItemSmoothie;
import erebus.tileentity.TileEntityBones;
import erebus.tileentity.TileEntityTempleTeleporter;
import erebus.world.feature.structure.worlddata.WorldDataAntlionMaze;
import erebus.world.feature.util.PerfectMazeGenerator;
import erebus.world.loot.IPostProcess;
import erebus.world.loot.LootItemStack;
import erebus.world.loot.LootUtil;
import erebus.world.loot.WeightedLootList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class WorldGenAntlionDungeon
extends WorldGenerator {
    private IBlockState GNEISS = ModBlocks.GNEISS.func_176223_P();
    private IBlockState GNEISS_RELIEF = ModBlocks.GNEISS.func_176223_P().func_177226_a(BlockGneiss.TYPE, (Comparable)((Object)BlockGneiss.EnumGneissType.GNEISS_RELIEF));
    private IBlockState GNEISS_CARVED = ModBlocks.GNEISS.func_176223_P().func_177226_a(BlockGneiss.TYPE, (Comparable)((Object)BlockGneiss.EnumGneissType.GNEISS_CARVED));
    private IBlockState GNEISS_BRICKS = ModBlocks.GNEISS.func_176223_P().func_177226_a(BlockGneiss.TYPE, (Comparable)((Object)BlockGneiss.EnumGneissType.GNEISS_BRICKS));
    private IBlockState GNEISS_TILES = ModBlocks.GNEISS.func_176223_P().func_177226_a(BlockGneiss.TYPE, (Comparable)((Object)BlockGneiss.EnumGneissType.GNEISS_TILES));
    private IBlockState TEMPLE_BRICK_UNBREAKING = ModBlocks.TEMPLE_BRICK_UNBREAKING.func_176223_P();
    private IBlockState TEMPLE_PILLAR = ModBlocks.TEMPLE_PILLAR.func_176223_P();
    private IBlockState CAPSTONE = ModBlocks.CAPSTONE.func_176223_P();
    private static IBlockState BAMBOO_TORCH_LOWER = ModBlocks.BAMBOO_TORCH.func_176223_P().func_177226_a(BlockBambooTorch.HALF, (Comparable)((Object)BlockBambooTorch.EnumBlockTorchHalf.LOWER));
    private static IBlockState BAMBOO_TORCH_UPPER = ModBlocks.BAMBOO_TORCH.func_176223_P().func_177226_a(BlockBambooTorch.HALF, (Comparable)((Object)BlockBambooTorch.EnumBlockTorchHalf.UPPER));
    private IBlockState GNEISS_VENT = ModBlocks.GNEISS_VENT.func_176223_P();
    private IBlockState FORCE_FIELD = ModBlocks.FORCE_FIELD.func_176223_P();
    private IBlockState TEMPLE_BRICK = ModBlocks.TEMPLE_BRICK.func_176223_P();
    private IBlockState ANTLION_SPAWNER = ModBlocks.ANTLION_SPAWNER.func_176223_P();
    private IBlockState MAGMA_CRAWLER_SPAWNER = ModBlocks.MAGMA_CRAWLER_SPAWNER.func_176223_P();
    private IBlockState TORCH_EAST = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST);
    private IBlockState TORCH_WEST = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST);
    private IBlockState TORCH_SOUTH = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH);
    private IBlockState TORCH_NORTH = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH);
    private final Map<IBlockState, Boolean> STRUCTURE_BLOCKS = new HashMap<IBlockState, Boolean>();
    public static final WeightedLootList chestLoot = new WeightedLootList(new LootItemStack[]{new LootItemStack(Items.field_151122_aG).setAmount(1, 4).setWeight(18), new LootItemStack(Items.field_151121_aF).setAmount(2, 6).setWeight(16), new LootItemStack(Blocks.field_150321_G).setAmount(2, 7).setWeight(13), new LootItemStack(ModItems.MATERIALS).setAmount(1, 3).setDamage(ItemMaterials.EnumErebusMaterialsType.JADE.ordinal()).setWeight(10), new LootItemStack(ModItems.MATERIALS).setAmount(4, 8).setDamage(ItemMaterials.EnumErebusMaterialsType.PLATE_EXO.ordinal()).setWeight(9), new LootItemStack(Items.field_151134_bR).setWeight(8), new LootItemStack(ModBlocks.UMBER_GOLEM_STATUE).setAmount(1).setWeight(1), new LootItemStack(ModItems.WEB_SLINGER).setAmount(1).setWeight(1), new LootItemStack(Items.field_151005_D).setWeight(3), new LootItemStack(Items.field_151035_b).setWeight(2), new LootItemStack(ModItems.JADE_PICKAXE).setWeight(1), new LootItemStack(Items.field_151011_C).setWeight(3), new LootItemStack(Items.field_151037_a).setWeight(2), new LootItemStack(ModItems.JADE_SHOVEL).setWeight(1), new LootItemStack(Items.field_151006_E).setWeight(3), new LootItemStack(Items.field_151036_c).setWeight(2), new LootItemStack(ModItems.JADE_AXE).setWeight(1), new LootItemStack(Items.field_151010_B).setWeight(3), new LootItemStack(Items.field_151040_l).setWeight(2), new LootItemStack(ModItems.JADE_SWORD).setWeight(1), new LootItemStack((Item)Items.field_151030_Z).setWeight(2), new LootItemStack(ModItems.JADE_CHESTPLATE).setWeight(1), new LootItemStack((Item)Items.field_151171_ah).setWeight(1), new LootItemStack((Item)Items.field_151028_Y).setWeight(2), new LootItemStack(ModItems.JADE_HELMET).setWeight(1), new LootItemStack((Item)Items.field_151169_ag).setWeight(1), new LootItemStack((Item)Items.field_151165_aa).setWeight(2), new LootItemStack(ModItems.JADE_LEGGINGS).setWeight(1), new LootItemStack((Item)Items.field_151149_ai).setWeight(1), new LootItemStack((Item)Items.field_151167_ab).setWeight(2), new LootItemStack(ModItems.JADE_BOOTS).setWeight(1), new LootItemStack((Item)Items.field_151151_aj).setWeight(1), new LootItemStack(ModItems.MATERIALS).setAmount(1).setDamage(ItemMaterials.EnumErebusMaterialsType.ALTAR_FRAGMENT.ordinal()).setWeight(1), new LootItemStack(ModItems.MATERIALS).setAmount(1).setDamage(ItemMaterials.EnumErebusMaterialsType.REINFORCED_PLATE_EXO.ordinal()).setWeight(1), new LootItemStack(ModItems.MATERIALS).setAmount(1).setDamage(ItemMaterials.EnumErebusMaterialsType.SCORPION_PINCER.ordinal()).setWeight(1), new LootItemStack(ModItems.MATERIALS).setAmount(1, 3).setDamage(ItemMaterials.EnumErebusMaterialsType.WHETSTONE_POWDER.ordinal()).setWeight(3), new LootItemStack(ModItems.MATERIALS).setAmount(1).setDamage(ItemMaterials.EnumErebusMaterialsType.PLATE_EXO_RHINO.ordinal()).setWeight(1), new LootItemStack(ModItems.EREBUS_FOOD).setAmount(1, 3).setDamage(ItemErebusFood.EnumFoodType.HONEY_SANDWICH.ordinal()).setWeight(3), new LootItemStack(ModItems.CABBAGE_SEEDS).setAmount(1, 3).setWeight(2), new LootItemStack(ModItems.WHETSTONE).setAmount(1).setDamage(0).setWeight(1), new LootItemStack(ModItems.LIFE_BLOOD).setAmount(1, 2).setWeight(4), new LootItemStack(ModItems.ROLLED_NEWSPAPER).setAmount(1).setWeight(1), new LootItemStack(ModItems.BAMBUCKET).setAmount(1).setWeight(6), new LootItemStack(ModItems.HOMING_BEECON).setAmount(1).setWeight(1), new LootItemStack(ModBlocks.GLOW_GEM_ACTIVE).setAmount(1, 3).setWeight(5), new LootItemStack(ModItems.SMOOTHIE).setAmount(1, 3).setDamage(ItemSmoothie.SmoothieType.GIVIN_ME_THE_BLUES.ordinal()).setWeight(3), new LootItemStack(ModItems.SMOOTHIE).setAmount(1).setDamage(ItemSmoothie.SmoothieType.BRYUFS_BREW.ordinal()).setWeight(1), new LootItemStack((Item)ModItems.WASP_DAGGER).setAmount(1, 3).setWeight(2)}).setPostProcessor(new IPostProcess(){

        @Override
        public ItemStack postProcessItem(ItemStack is, Random rand) {
            if (is.func_77973_b() == Items.field_151134_bR || rand.nextBoolean() && (is.func_77973_b() instanceof ItemTool || is.func_77973_b() instanceof ItemArmor || is.func_77973_b() instanceof ItemSword)) {
                boolean enchBook;
                boolean bl = enchBook = is.func_77973_b() == Items.field_151134_bR;
                if (enchBook) {
                    is = new ItemStack(Items.field_151122_aG);
                }
                List enchList = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)is, (int)(7 + rand.nextInt(10)), (boolean)true);
                if (enchBook) {
                    is = new ItemStack(Items.field_151134_bR);
                }
                if (enchList != null && enchList.size() > 0) {
                    for (int a = 0; a < enchList.size(); ++a) {
                        EnchantmentData data = (EnchantmentData)enchList.get(a);
                        is.func_77966_a(data.field_76302_b, data.field_76303_c);
                    }
                }
            }
            if (is.func_77973_b() == ModItems.BAMBUCKET) {
                int randomBucket = rand.nextInt(3);
                switch (randomBucket) {
                    case 0: {
                        is = ModFluids.getFilledBambucket(new FluidStack(FluidRegistry.getFluid((String)"beetle_juice"), 1000));
                        break;
                    }
                    case 1: {
                        is = ModFluids.getFilledBambucket(new FluidStack(FluidRegistry.getFluid((String)"anti_venom"), 1000));
                        break;
                    }
                    case 2: {
                        is = ModFluids.getFilledBambucket(new FluidStack(FluidRegistry.getFluid((String)"honey"), 1000));
                    }
                }
            }
            return is;
        }
    });

    public WorldGenAntlionDungeon() {
        this.initStuctureBlockMap();
    }

    public boolean isSolidStructureBlock(IBlockState state) {
        return this.STRUCTURE_BLOCKS.get(state) != null;
    }

    private void initStuctureBlockMap() {
        if (this.STRUCTURE_BLOCKS.isEmpty()) {
            this.STRUCTURE_BLOCKS.put(this.GNEISS, true);
            this.STRUCTURE_BLOCKS.put(this.GNEISS_RELIEF, true);
            this.STRUCTURE_BLOCKS.put(this.GNEISS_CARVED, true);
            this.STRUCTURE_BLOCKS.put(this.GNEISS_BRICKS, true);
            this.STRUCTURE_BLOCKS.put(this.GNEISS_TILES, true);
            this.STRUCTURE_BLOCKS.put(this.TEMPLE_BRICK_UNBREAKING, true);
            this.STRUCTURE_BLOCKS.put(this.TEMPLE_PILLAR, true);
            this.STRUCTURE_BLOCKS.put(this.CAPSTONE, true);
            this.STRUCTURE_BLOCKS.put(BAMBOO_TORCH_LOWER, true);
            this.STRUCTURE_BLOCKS.put(BAMBOO_TORCH_UPPER, true);
            this.STRUCTURE_BLOCKS.put(this.GNEISS_VENT, true);
            this.STRUCTURE_BLOCKS.put(this.FORCE_FIELD, true);
            this.STRUCTURE_BLOCKS.put(this.TEMPLE_BRICK, true);
            this.STRUCTURE_BLOCKS.put(this.ANTLION_SPAWNER, true);
            this.STRUCTURE_BLOCKS.put(this.MAGMA_CRAWLER_SPAWNER, true);
            this.STRUCTURE_BLOCKS.put(this.TORCH_EAST, true);
            this.STRUCTURE_BLOCKS.put(this.TORCH_WEST, true);
            this.STRUCTURE_BLOCKS.put(this.TORCH_SOUTH, true);
            this.STRUCTURE_BLOCKS.put(this.TORCH_NORTH, true);
            this.STRUCTURE_BLOCKS.put(Blocks.field_150353_l.func_176223_P(), true);
        }
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (this.checkWorldLocation(world, pos)) {
            this.generateStructure(world, rand, pos);
            return true;
        }
        return false;
    }

    public boolean checkBiome(Biome biome) {
        return biome == ModBiomes.VOLCANIC_DESERT;
    }

    public boolean checkWorldLocation(World world, BlockPos pos) {
        if (!(this.checkBiome(world.func_180494_b(pos.func_177982_a(64, 0, 0))) && this.checkBiome(world.func_180494_b(pos.func_177982_a(-64, 0, 0))) && this.checkBiome(world.func_180494_b(pos.func_177982_a(0, 0, 64))) && this.checkBiome(world.func_180494_b(pos.func_177982_a(0, 0, -64))))) {
            return false;
        }
        WorldDataAntlionMaze data = WorldDataAntlionMaze.forWorld(world);
        if (data.getData().isEmpty()) {
            data.addStructurePosition(pos);
            data.func_76185_a();
            return true;
        }
        if (!data.getData().isEmpty()) {
            for (int i = 0; i < data.getData().size(); ++i) {
                int x_origin = data.getData().get(i).func_177958_n();
                int z_origin = data.getData().get(i).func_177952_p();
                if (pos.func_177958_n() < x_origin - 800 || pos.func_177958_n() > x_origin + 800 || pos.func_177952_p() < z_origin - 800 || pos.func_177952_p() > z_origin + 800) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void generateStructure(World world, Random rand, BlockPos pos) {
        WorldDataAntlionMaze data = WorldDataAntlionMaze.forWorld(world);
        data.addStructurePosition(pos);
        data.func_76185_a();
        int sizeX = 60;
        int sizeY = 4;
        int sizeZ = 60;
        int mazeWidth = sizeX / 2;
        int mazeHeight = sizeZ / 2;
        int[][] maze = null;
        PerfectMazeGenerator generator = new PerfectMazeGenerator(mazeWidth, mazeHeight);
        maze = generator.generateMaze();
        this.buildFloor(world, pos.func_177982_a(0, -4, 0), mazeWidth, mazeHeight, rand);
        this.buildRoof(world, pos, mazeWidth, mazeHeight, rand);
        this.buildLevel(world, pos.func_177982_a(-60, -3, -60), mazeWidth, mazeHeight, maze, this.GNEISS_RELIEF);
        this.buildLevel(world, pos.func_177982_a(-60, -2, -60), mazeWidth, mazeHeight, maze, this.GNEISS_CARVED);
        this.buildLevel(world, pos.func_177982_a(-60, -1, -60), mazeWidth, mazeHeight, maze, this.GNEISS_RELIEF);
        this.createAir(world, pos.func_177982_a(0, -3, 0), mazeWidth, mazeHeight, rand);
        this.addFeature(world, pos.func_177982_a(-60, -2, -60), mazeWidth, mazeHeight, maze, rand);
        this.buildCourtyard(world, this.TEMPLE_PILLAR, pos.func_177982_a(0, -4, 0), 52, 4, 52);
        this.createPyramid(world, pos.func_177982_a(0, -4, 0), this.TEMPLE_BRICK_UNBREAKING, true, 22, 22);
        this.decoratePyramid(world, pos.func_177982_a(-22, -4, -22));
        this.addTeleporters(world, pos.func_177982_a(-22, -4, -22));
        this.addCapstones(world, pos.func_177982_a(0, 17, 0));
        this.spawnIdolGuardians(world, pos.func_177982_a(-60, -3, -60));
    }

    private void createAir(World world, BlockPos pos, int w, int h, Random rand) {
        for (int i = -h * 2; i <= h * 2; ++i) {
            for (int j = -w * 2; j <= w * 2; ++j) {
                for (int k = 0; k <= 2; ++k) {
                    if (!this.canPlaceFeatureAt(world, pos, pos.func_177982_a(j, k, i)) || this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(j, k, i)))) continue;
                    world.func_175698_g(pos.func_177982_a(j, k, i));
                }
            }
        }
    }

    private void addTeleporters(World world, BlockPos pos) {
        world.func_180501_a(pos.func_177982_a(13, 9, 13), this.CAPSTONE, 2);
        this.setFloorDecoStone(world, pos.func_177982_a(14, 9, 14));
        this.setLockStone(world, pos.func_177982_a(15, 9, 15), 2);
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(16, 9, 16), 0, pos.func_177982_a(30, 9, 13));
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(19, 9, 19), 5, pos.func_177982_a(19, 14, 19));
        world.func_180501_a(pos.func_177982_a(30, 9, 13), this.CAPSTONE, 2);
        this.setFloorDecoStone(world, pos.func_177982_a(25, 9, 14));
        this.setLockStone(world, pos.func_177982_a(26, 9, 15), 3);
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(27, 9, 16), 0, pos.func_177982_a(30, 9, 30));
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(24, 9, 19), 5, pos.func_177982_a(13, 9, 13));
        world.func_180501_a(pos.func_177982_a(30, 9, 30), this.CAPSTONE, 2);
        this.setFloorDecoStone(world, pos.func_177982_a(25, 9, 25));
        this.setLockStone(world, pos.func_177982_a(26, 9, 26), 4);
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(27, 9, 27), 0, pos.func_177982_a(13, 9, 30));
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(24, 9, 24), 5, pos.func_177982_a(30, 9, 13));
        world.func_180501_a(pos.func_177982_a(13, 9, 30), this.CAPSTONE, 2);
        this.setFloorDecoStone(world, pos.func_177982_a(14, 9, 25));
        this.setLockStone(world, pos.func_177982_a(15, 9, 26), 5);
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(16, 9, 27), 0, pos.func_177982_a(13, 9, 13));
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(19, 9, 24), 5, pos.func_177982_a(30, 9, 30));
        this.setFloorMidDecoStone(world, pos.func_177982_a(20, 9, 20));
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(22, 9, 21), 6, pos.func_177982_a(5, 1, 5));
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(21, 9, 21), 7, pos.func_177982_a(38, 1, 5));
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(22, 9, 22), 8, pos.func_177982_a(38, 1, 38));
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(21, 9, 22), 9, pos.func_177982_a(5, 1, 38));
        world.func_180501_a(pos.func_177982_a(19, 14, 19), this.CAPSTONE, 2);
        world.func_180501_a(pos.func_177982_a(19, 15, 25), BAMBOO_TORCH_LOWER, 3);
        world.func_180501_a(pos.func_177982_a(19, 16, 25), BAMBOO_TORCH_UPPER, 3);
        world.func_180501_a(pos.func_177982_a(25, 15, 19), BAMBOO_TORCH_LOWER, 3);
        world.func_180501_a(pos.func_177982_a(25, 16, 19), BAMBOO_TORCH_UPPER, 3);
        this.setFloorDecoStone(world, pos.func_177982_a(20, 14, 20));
        this.setLockStone(world, pos.func_177982_a(21, 14, 21), 1);
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(22, 14, 22), 0, pos.func_177982_a(13, 9, 13));
        WorldGenAntlionDungeon.setTeleporter(world, pos.func_177982_a(25, 14, 25), 5, pos.func_177982_a(19, 14, 19));
    }

    private void setLockStone(World world, BlockPos pos, int meta) {
        for (int dx = 0; dx < 3; ++dx) {
            for (int dz = 0; dz < 3; ++dz) {
                world.func_180501_a(pos.func_177982_a(dx, 0, dz), ModBlocks.TEMPLE_BRICK_UNBREAKING.func_176223_P().func_177226_a(BlockTempleBrickUnbreaking.TYPE, (Comparable)((Object)BlockTempleBrickUnbreaking.EnumTempleBrickType.values()[meta])), 2);
            }
        }
    }

    private void setFloorDecoStone(World world, BlockPos pos) {
        for (int dx = 0; dx < 5; ++dx) {
            for (int dz = 0; dz < 5; ++dz) {
                world.func_180501_a(pos.func_177982_a(dx, 0, dz), this.CAPSTONE, 2);
            }
        }
    }

    private void setFloorMidDecoStone(World world, BlockPos pos) {
        for (int dx = 0; dx < 4; ++dx) {
            for (int dz = 0; dz < 4; ++dz) {
                world.func_180501_a(pos.func_177982_a(dx, 0, dz), this.CAPSTONE, 2);
            }
        }
    }

    private void decoratePyramid(World world, BlockPos pos) {
        boolean forcefieldSet = false;
        boolean topchestSet = false;
        for (int yy = 0; yy < 30; ++yy) {
            for (int xx = 0; xx < 44; ++xx) {
                for (int zz = 0; zz < 44; ++zz) {
                    if (yy == 0) {
                        world.func_180501_a(pos.func_177982_a(xx, yy, zz), this.TEMPLE_BRICK_UNBREAKING, 2);
                    }
                    if (yy == 1) {
                        if (xx > 1 && xx < 42 && zz > 1 && zz < 42) {
                            world.func_180501_a(pos.func_177982_a(xx, yy, zz), Blocks.field_150354_m.func_176223_P(), 2);
                        }
                        if (xx > 4 && xx < 39 && zz > 4 && zz < 39) {
                            if (xx % 11 == 5 || zz % 11 == 5) {
                                world.func_180501_a(pos.func_177982_a(xx, yy, zz), this.GNEISS_VENT, 2);
                            } else if (xx >= 21 && xx <= 22 && zz >= 21 && zz <= 22) {
                                world.func_180501_a(pos.func_177971_a((Vec3i)pos.func_177982_a(xx, yy, zz)), this.GNEISS_VENT, 2);
                            } else {
                                world.func_180501_a(pos.func_177982_a(xx, yy, zz), Blocks.field_150354_m.func_176223_P(), 2);
                            }
                        }
                    }
                    if (yy == 9 && xx > 9 && xx < 34 && zz > 9 && zz < 34) {
                        world.func_180501_a(pos.func_177982_a(xx, yy, zz), this.TEMPLE_BRICK_UNBREAKING, 2);
                    }
                    if (yy == 10 && !forcefieldSet) {
                        for (int d = 0; d < 4; ++d) {
                            for (int wx = 0 + d; wx < 9; ++wx) {
                                world.func_180501_a(pos.func_177982_a(11 + wx, yy + d, 21), this.FORCE_FIELD, 2);
                                world.func_180501_a(pos.func_177982_a(11 + wx, yy + d, 22), this.FORCE_FIELD, 2);
                                world.func_180501_a(pos.func_177982_a(21, yy + d, 11 + wx), this.FORCE_FIELD, 2);
                                world.func_180501_a(pos.func_177982_a(22, yy + d, 11 + wx), this.FORCE_FIELD, 2);
                                world.func_180501_a(pos.func_177982_a(21, yy + d, 32 - wx), this.FORCE_FIELD, 2);
                                world.func_180501_a(pos.func_177982_a(22, yy + d, 32 - wx), this.FORCE_FIELD, 2);
                                world.func_180501_a(pos.func_177982_a(32 - wx, yy + d, 21), this.FORCE_FIELD, 2);
                                world.func_180501_a(pos.func_177982_a(32 - wx, yy + d, 22), this.FORCE_FIELD, 2);
                            }
                            for (int dx = 20; dx < 24; ++dx) {
                                for (int dz = 20; dz < 24; ++dz) {
                                    world.func_180501_a(pos.func_177982_a(dx, yy + d, dz), this.FORCE_FIELD, 2);
                                }
                            }
                            for (int dx1 = 21; dx1 < 23; ++dx1) {
                                for (int dz1 = 21; dz1 < 23; ++dz1) {
                                    world.func_175698_g(pos.func_177982_a(dx1, yy + d, dz1));
                                }
                            }
                        }
                        forcefieldSet = true;
                    }
                    if (yy == 14 && xx > 14 && xx < 29 && zz > 14 && zz < 29) {
                        world.func_180501_a(pos.func_177982_a(xx, yy, zz), this.TEMPLE_BRICK_UNBREAKING, 2);
                    }
                    if (yy == 15 && !topchestSet) {
                        world.func_180501_a(pos.func_177982_a(19, yy, 22), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.NORTH), 2);
                        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos.func_177982_a(19, yy, 22));
                        if (chest != null) {
                            chest.func_70299_a(0, ItemMaterials.EnumErebusMaterialsType.JADE.createStack(8));
                            chest.func_70296_d();
                        }
                    }
                    if (yy != 16) continue;
                }
            }
        }
    }

    public static void setTeleporter(World world, BlockPos pos, int meta, BlockPos posTarget) {
        world.func_180501_a(pos, ModBlocks.TEMPLE_TELEPORTER.func_176223_P().func_177226_a(BlockTempleTeleporter.TYPE, (Comparable)((Object)BlockTempleTeleporter.EnumTeleporterType.values()[meta])), 2);
        TileEntityTempleTeleporter teleporter = (TileEntityTempleTeleporter)world.func_175625_s(pos);
        if (teleporter != null) {
            teleporter.setTargetDestination(posTarget);
        }
    }

    private void addCapstones(World world, BlockPos pos) {
        world.func_180501_a(pos.func_177982_a(-1, 0, -1), this.CAPSTONE.func_177226_a(BlockCapstone.TYPE, (Comparable)((Object)BlockCapstone.EnumCapstoneType.CAPSTONE_MUD)), 3);
        world.func_180501_a(pos.func_177982_a(0, 0, -1), this.CAPSTONE.func_177226_a(BlockCapstone.TYPE, (Comparable)((Object)BlockCapstone.EnumCapstoneType.CAPSTONE_IRON)), 3);
        world.func_180501_a(pos.func_177982_a(-1, 0, 0), this.CAPSTONE.func_177226_a(BlockCapstone.TYPE, (Comparable)((Object)BlockCapstone.EnumCapstoneType.CAPSTONE_GOLD)), 3);
        world.func_180501_a(pos.func_177982_a(0, 0, 0), this.CAPSTONE.func_177226_a(BlockCapstone.TYPE, (Comparable)((Object)BlockCapstone.EnumCapstoneType.CAPSTONE_JADE)), 3);
    }

    private void createPyramid(World world, BlockPos pos, IBlockState block, boolean isHollow, int baseLengthX, int baseLengthZ) {
        for (int i = 0; i < 21; ++i) {
            int maxX = baseLengthX - 1;
            int maxZ = baseLengthZ - 1;
            for (int ix = -baseLengthX; ix <= maxX; ++ix) {
                for (int iz = -baseLengthZ; iz <= maxZ; ++iz) {
                    if (ix == -baseLengthX || ix == maxX || iz == -baseLengthZ || iz == maxZ) {
                        if (this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(ix, i, iz)))) continue;
                        world.func_180501_a(pos.func_177982_a(ix, i, iz), block, 2);
                        continue;
                    }
                    if (!isHollow || this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(ix, i, iz))) || world.func_175623_d(pos.func_177982_a(ix, i, iz))) continue;
                    world.func_175698_g(pos.func_177982_a(ix, i, iz));
                }
            }
            --baseLengthX;
            --baseLengthZ;
        }
    }

    private void spawnIdolGuardians(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!world.field_72995_K) {
            for (byte spawn = 0; spawn < 4; spawn = (byte)(spawn + 1)) {
                EntityUmberGolemDungeonTypes entityUmberGolem = new EntityUmberGolemDungeonTypes(world);
                entityUmberGolem.setType(spawn);
                entityUmberGolem.func_70606_j(entityUmberGolem.func_110138_aP());
                switch (spawn) {
                    case 0: {
                        entityUmberGolem.func_70107_b((double)x + 2.5, y, (double)z + 2.5);
                        break;
                    }
                    case 1: {
                        entityUmberGolem.func_70107_b((double)x + 118.5, y, (double)z + 2.5);
                        break;
                    }
                    case 2: {
                        entityUmberGolem.func_70107_b((double)x + 2.5, y, (double)z + 118.5);
                        break;
                    }
                    case 3: {
                        entityUmberGolem.func_70107_b((double)x + 118.5, y, (double)z + 118.5);
                    }
                }
                world.func_72838_d((Entity)entityUmberGolem);
            }
        }
    }

    private void buildCourtyard(World world, IBlockState block, BlockPos pos, int baseLengthX, int heightY, int baseLengthZ) {
        for (int yy = 0; yy <= heightY; ++yy) {
            for (int xx = -baseLengthX / 2; xx < baseLengthX / 2; ++xx) {
                for (int zz = -baseLengthZ / 2; zz < baseLengthZ / 2; ++zz) {
                    int i;
                    if (yy <= 0 || yy > 4) continue;
                    if (!world.func_175623_d(pos.func_177982_a(xx, yy, zz))) {
                        world.func_175698_g(pos.func_177982_a(xx, yy, zz));
                    }
                    if ((xx == -baseLengthX / 2 || xx == baseLengthX / 2 - 1) && zz > -baseLengthZ / 2 && zz < baseLengthZ / 2) {
                        if (yy <= 3) {
                            for (i = 3; i < 49; i += 5) {
                                world.func_180501_a(pos.func_177982_a(xx, yy, -baseLengthZ / 2 + i), block, 2);
                            }
                        }
                        if (yy == 4) {
                            for (i = 0; i < 52; ++i) {
                                world.func_180501_a(pos.func_177982_a(xx, yy, -baseLengthZ / 2 + i), this.TEMPLE_BRICK, 2);
                            }
                        }
                    }
                    if (zz != -baseLengthZ / 2 && zz != baseLengthZ / 2 - 1 || xx <= -baseLengthX / 2 || xx >= baseLengthX / 2) continue;
                    if (yy <= 3) {
                        for (i = 3; i < 49; i += 5) {
                            world.func_180501_a(pos.func_177982_a(-baseLengthZ / 2 + i, yy, zz), block, 2);
                        }
                    }
                    if (yy != 4) continue;
                    for (i = 0; i < 52; ++i) {
                        world.func_180501_a(pos.func_177982_a(-baseLengthZ / 2 + i, yy, zz), this.TEMPLE_BRICK, 2);
                    }
                }
            }
        }
    }

    private void buildRoof(World world, BlockPos pos, int w, int h, Random rand) {
        for (int i = -h * 2; i <= h * 2; ++i) {
            for (int j = -w * 2; j <= w * 2; ++j) {
                if (!this.canPlaceFeatureAt(world, pos, pos.func_177982_a(j, 0, i))) continue;
                world.func_180501_a(pos.func_177982_a(j, 0, i), this.GNEISS_BRICKS, 2);
            }
        }
    }

    private void buildFloor(World world, BlockPos pos, int w, int h, Random rand) {
        this.createPyramid(world, pos.func_177982_a(0, 5, 0), Blocks.field_150350_a.func_176223_P(), true, 24, 24);
        for (int i = -h * 2; i <= h * 2; ++i) {
            for (int j = -w * 2; j <= w * 2; ++j) {
                if (!this.canPlaceFloorAt(world, pos, pos.func_177982_a(j, 0, i))) continue;
                if (rand.nextInt(15) == 0) {
                    if (rand.nextBoolean() && rand.nextBoolean()) {
                        world.func_175656_a(pos.func_177982_a(j, 0, i), Blocks.field_150353_l.func_176223_P());
                        continue;
                    }
                    world.func_175656_a(pos.func_177982_a(j, 0, i), this.GNEISS_VENT);
                    continue;
                }
                world.func_180501_a(pos.func_177982_a(j, 0, i), this.GNEISS_TILES, 2);
            }
        }
    }

    private boolean canPlaceFloorAt(World world, BlockPos pos, BlockPos posFeature) {
        for (int xx = pos.func_177958_n() - 22; xx < pos.func_177958_n() + 22; ++xx) {
            for (int zz = pos.func_177952_p() - 22; zz < pos.func_177952_p() + 22; ++zz) {
                if (xx != posFeature.func_177958_n() || zz != posFeature.func_177952_p()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canPlaceFeatureAt(World world, BlockPos pos, BlockPos posFeature) {
        for (int xx = pos.func_177958_n() - 26; xx < pos.func_177958_n() + 26; ++xx) {
            for (int zz = pos.func_177952_p() - 26; zz < pos.func_177952_p() + 26; ++zz) {
                if (xx != posFeature.func_177958_n() || zz != posFeature.func_177952_p()) continue;
                return false;
            }
        }
        return true;
    }

    private void addFeature(World world, BlockPos pos, int w, int h, int[][] maze, Random rand) {
        for (int i = 0; i < h; ++i) {
            int j;
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 1) != 0) continue;
                if (rand.nextInt(25) == 0 && this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(1 + j * 4, -1, 1 + i * 4))) {
                    world.func_180501_a(pos.func_177982_a(1 + j * 4, 0, 1 + i * 4), this.TORCH_SOUTH, 2);
                    if (rand.nextInt(4) == 0) {
                        this.placeChest(world, pos.func_177982_a(1 + j * 4, -1, 1 + i * 4), EnumFacing.SOUTH, rand);
                        continue;
                    }
                    if (rand.nextInt(6) != 0) continue;
                    this.placeBones(world, pos.func_177982_a(1 + j * 4, -1, 1 + i * 4), EnumFacing.SOUTH, rand);
                    continue;
                }
                if (rand.nextInt(10) != 0) continue;
                if (rand.nextBoolean()) {
                    world.func_175656_a(pos.func_177982_a(2 + j * 4, -2, 2 + i * 4), this.ANTLION_SPAWNER);
                    continue;
                }
                world.func_175656_a(pos.func_177982_a(2 + j * 4, 2, 2 + i * 4), this.MAGMA_CRAWLER_SPAWNER);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 8) != 0 || rand.nextInt(25) != 0 || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(1 + j * 4, -1, 2 + i * 4))) continue;
                world.func_180501_a(pos.func_177982_a(1 + j * 4, 0, 2 + i * 4), this.TORCH_EAST, 2);
                if (rand.nextInt(4) == 0) {
                    this.placeChest(world, pos.func_177982_a(1 + j * 4, -1, 2 + i * 4), EnumFacing.EAST, rand);
                    continue;
                }
                if (rand.nextInt(6) != 0) continue;
                this.placeBones(world, pos.func_177982_a(1 + j * 4, -1, 2 + i * 4), EnumFacing.EAST, rand);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 4) != 0 || rand.nextInt(25) != 0 || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(3 + j * 4, -1, 2 + i * 4))) continue;
                world.func_180501_a(pos.func_177982_a(3 + j * 4, 0, 2 + i * 4), this.TORCH_WEST, 2);
                if (rand.nextInt(4) == 0) {
                    this.placeChest(world, pos.func_177982_a(3 + j * 4, -1, 2 + i * 4), EnumFacing.WEST, rand);
                    continue;
                }
                if (rand.nextInt(6) != 0) continue;
                this.placeBones(world, pos.func_177982_a(3 + j * 4, -1, 2 + i * 4), EnumFacing.WEST, rand);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 2) != 0 || rand.nextInt(25) != 0 || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(2 + j * 4, -1, 3 + i * 4))) continue;
                world.func_180501_a(new BlockPos(2 + j * 4, 0, 3 + i * 4), this.TORCH_NORTH, 2);
                if (rand.nextInt(4) == 0) {
                    this.placeChest(world, pos.func_177982_a(2 + j * 4, -1, 3 + i * 4), EnumFacing.NORTH, rand);
                    continue;
                }
                if (rand.nextInt(6) != 0) continue;
                this.placeBones(world, pos.func_177982_a(2 + j * 4, -1, 3 + i * 4), EnumFacing.NORTH, rand);
            }
        }
    }

    private void placeChest(World world, BlockPos pos, EnumFacing facing, Random rand) {
        world.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing), 2);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
        if (chest != null) {
            LootUtil.generateLoot((IInventory)chest, rand, chestLoot, 3, 10);
        }
    }

    private void placeBones(World world, BlockPos pos, EnumFacing facing, Random rand) {
        world.func_180501_a(pos, ModBlocks.BLOCK_OF_BONES.func_176223_P().func_177226_a((IProperty)BlockBones.field_176387_N, (Comparable)facing), 2);
        TileEntityBones bones = (TileEntityBones)world.func_175625_s(pos);
        if (bones != null) {
            LootUtil.generateLoot((IInventory)bones, rand, chestLoot, 3, 10);
        }
    }

    private void buildLevel(World world, BlockPos pos, int w, int h, int[][] maze, IBlockState blockType) {
        for (int i = 0; i < h; ++i) {
            int j;
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 1) == 0) {
                    if (!this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(j * 4, 1, i * 4)) || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(j * 4 + 1, 0, i * 4)) || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(j * 4 + 2, 0, i * 4)) || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(j * 4 + 3, 0, i * 4))) continue;
                    world.func_180501_a(pos.func_177982_a(j * 4, 0, i * 4), blockType, 2);
                    world.func_180501_a(pos.func_177982_a(j * 4 + 1, 0, i * 4), blockType, 2);
                    world.func_180501_a(pos.func_177982_a(j * 4 + 2, 0, i * 4), blockType, 2);
                    world.func_180501_a(pos.func_177982_a(j * 4 + 3, 0, i * 4), blockType, 2);
                    continue;
                }
                if (!this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(j * 4, 1, i * 4))) continue;
                world.func_180501_a(pos.func_177982_a(j * 4, 0, i * 4), blockType, 2);
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 8) != 0 || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(j * 4, 0, i * 4 + 1)) || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(j * 4, 0, i * 4 + 2)) || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(j * 4, 0, i * 4 + 3))) continue;
                world.func_180501_a(pos.func_177982_a(j * 4, 0, i * 4 + 1), blockType, 2);
                world.func_180501_a(pos.func_177982_a(j * 4, 0, i * 4 + 2), blockType, 2);
                world.func_180501_a(pos.func_177982_a(j * 4, 0, i * 4 + 3), blockType, 2);
            }
            if (!this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(w * 4, 0, i * 4)) || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(w * 4, 0, i * 4 + 1)) || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(w * 4, 0, i * 4 + 2)) || !this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(w * 4, 0, i * 4 + 3))) continue;
            world.func_180501_a(pos.func_177982_a(w * 4, 0, i * 4), blockType, 2);
            world.func_180501_a(pos.func_177982_a(w * 4, 0, i * 4 + 1), blockType, 2);
            world.func_180501_a(pos.func_177982_a(w * 4, 0, i * 4 + 2), blockType, 2);
            world.func_180501_a(pos.func_177982_a(w * 4, 0, i * 4 + 3), blockType, 2);
        }
        for (int j = 0; j <= w * 4; ++j) {
            if (!this.canPlaceFeatureAt(world, pos.func_177982_a(60, 0, 60), pos.func_177982_a(j * 4, 0, h * 4))) continue;
            world.func_180501_a(pos.func_177982_a(j, 0, h * 4), blockType, 2);
        }
    }

    public static void breakForceField(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        for (int d = 0; d < 4; ++d) {
            for (int wx = 0 + d; wx < 9; ++wx) {
                world.func_175698_g(pos.func_177982_a(11 + wx, d, 21));
                world.func_175698_g(pos.func_177982_a(11 + wx, d, 22));
                world.func_175698_g(pos.func_177982_a(21, d, 11 + wx));
                world.func_175698_g(pos.func_177982_a(22, d, 11 + wx));
                world.func_175698_g(pos.func_177982_a(21, d, 32 - wx));
                world.func_175698_g(pos.func_177982_a(22, d, 32 - wx));
                world.func_175698_g(pos.func_177982_a(32 - wx, d, 21));
                world.func_175698_g(pos.func_177982_a(32 - wx, d, 22));
            }
            for (int dx = 20; dx < 24; ++dx) {
                for (int dz = 20; dz < 24; ++dz) {
                    if (world.func_175623_d(pos.func_177982_a(dx, d, dz))) continue;
                    world.func_180498_a(null, 2001, pos.func_177982_a(dx, d, dz), Block.func_149682_b((Block)ModBlocks.FORCE_FIELD));
                    world.func_175698_g(pos.func_177982_a(dx, d, dz));
                }
            }
        }
        world.func_180501_a(pos.func_177982_a(20, 0, 20), BAMBOO_TORCH_LOWER, 3);
        world.func_180501_a(pos.func_177982_a(20, 1, 20), BAMBOO_TORCH_UPPER, 3);
        world.func_180501_a(pos.func_177982_a(20, 0, 23), BAMBOO_TORCH_LOWER, 3);
        world.func_180501_a(pos.func_177982_a(20, 1, 23), BAMBOO_TORCH_UPPER, 3);
        world.func_180501_a(pos.func_177982_a(23, 0, 23), BAMBOO_TORCH_LOWER, 3);
        world.func_180501_a(pos.func_177982_a(23, 1, 23), BAMBOO_TORCH_UPPER, 3);
        world.func_180501_a(pos.func_177982_a(23, 0, 20), BAMBOO_TORCH_LOWER, 3);
        world.func_180501_a(pos.func_177982_a(23, 1, 20), BAMBOO_TORCH_UPPER, 3);
        EntityAntlionBoss antlionboss = new EntityAntlionBoss(world);
        antlionboss.func_70107_b(x + 21, y - 8, z + 21);
        antlionboss.setInPyramid((byte)1);
        antlionboss.setSpawnPoint(x + 21, y - 8, z + 21);
        world.func_72838_d((Entity)antlionboss);
    }
}

