/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.structure;

import erebus.ModBiomes;
import erebus.ModBlocks;
import erebus.blocks.BlockDoorErebus;
import erebus.blocks.BlockLogErebus;
import erebus.blocks.BlockPlanksErebus;
import erebus.blocks.BlockUmberstone;
import erebus.blocks.EnumWood;
import erebus.core.handler.configs.ConfigHandler;
import java.util.Random;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenSwampHut
implements IWorldGenerator {
    private IBlockState log = EnumWood.MOSSBARK.getLog().func_176223_P();
    private IBlockState plank = ModBlocks.PLANKS.func_176223_P().func_177226_a(BlockPlanksErebus.TYPE, (Comparable)((Object)EnumWood.MOSSBARK));
    private IBlockState stairs = EnumWood.MOSSBARK.getStairs().func_176223_P();
    private IBlockState bricks = ModBlocks.UMBERSTONE.func_176223_P().func_177226_a(BlockUmberstone.TYPE, (Comparable)((Object)BlockUmberstone.EnumType.UMBERCOBBLE));
    private IBlockState fence = EnumWood.MOSSBARK.getFence().func_176223_P();
    private IBlockState door = EnumWood.MOSSBARK.getDoor().func_176223_P();
    private int length = 16;
    private int width = 16;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == ConfigHandler.INSTANCE.erebusDimensionID) {
            this.generate(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generate(World world, Random random, int x, int z) {
        int newY = 80;
        BlockPos pos = new BlockPos(x, newY, z);
        Biome biomeBase = world.func_180494_b(pos);
        if (biomeBase == ModBiomes.SUBMERGED_SWAMP) {
            for (int newX = 0; newX <= this.length; ++newX) {
                for (int newZ = 0; newZ <= this.width; ++newZ) {
                    IBlockState block = world.func_180495_p(pos.func_177982_a(newX, newY, newZ));
                    if (block == null || block != biomeBase.field_76752_A) continue;
                    this.generateStructure(world, random, pos);
                }
            }
        }
    }

    public boolean generateStructure(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.verticalBeam(world, rand, x + 5, y, z + 5, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 10, y, z + 5, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 5, y, z + 10, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 10, y, z + 10, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 4, y + 4, z + 4, this.log, 3, 0);
        this.verticalBeam(world, rand, x + 11, y + 4, z + 4, this.log, 3, 0);
        this.verticalBeam(world, rand, x + 4, y + 4, z + 11, this.log, 3, 0);
        this.verticalBeam(world, rand, x + 11, y + 4, z + 11, this.log, 3, 0);
        this.verticalBeam(world, rand, x + 4, y + 5, z + 5, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 11, y + 5, z + 5, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 4, y + 5, z + 10, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 11, y + 5, z + 10, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 5, y + 5, z + 4, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 10, y + 5, z + 4, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 5, y + 5, z + 11, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 10, y + 5, z + 11, this.log, 4, 0);
        this.verticalBeam(world, rand, x + 4, y + 8, z + 6, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 11, y + 8, z + 6, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 4, y + 8, z + 9, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 11, y + 8, z + 9, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 6, y + 8, z + 4, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 9, y + 8, z + 4, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 6, y + 8, z + 11, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 9, y + 8, z + 11, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 4, y + 9, z + 7, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 11, y + 9, z + 7, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 4, y + 9, z + 8, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 11, y + 9, z + 8, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 7, y + 9, z + 4, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 7, y + 9, z + 11, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 8, y + 9, z + 4, this.log, 2, 0);
        this.verticalBeam(world, rand, x + 8, y + 9, z + 11, this.log, 2, 0);
        for (int direction = 0; direction < 4; ++direction) {
            this.rotatedBeam(world, rand, x, y, z, 6, 5, this.bricks, 4, direction);
            this.rotatedBeam(world, rand, x, y + 1, z, 6, 5, this.plank, 1, direction);
            this.rotatedBeam(world, rand, x, y + 1, z, 7, 5, this.fence, 2, direction);
            this.rotatedBeam(world, rand, x, y + 1, z, 9, 5, this.plank, 1, direction);
            this.rotatedBeam(world, rand, x, y + 2, z, 6, 5, this.plank, 4, direction);
            this.rotatedBeam(world, rand, x, y + 3, z, 6, 5, this.plank, 4, direction);
            this.rotatedBeam(world, rand, x, y + 4, z, 5, 5, this.plank, 6, direction);
            this.rotatedBeam(world, rand, x, y + 4, z, 5, 4, this.plank, 6, direction);
            this.rotatedBeam(world, rand, x, y + 3, z, 4, 4, this.getStairRotations(this.stairs, direction == 0 ? 6 : (direction == 1 ? 4 : (direction == 2 ? 7 : 5))), 8, direction);
            this.rotatedBeam(world, rand, x, y + 5, z, 6, 4, this.plank, 1, direction);
            this.rotatedBeam(world, rand, x, y + 5, z, 7, 4, this.fence, 2, direction);
            this.rotatedBeam(world, rand, x, y + 5, z, 9, 4, this.plank, 1, direction);
            this.rotatedBeam(world, rand, x, y + 6, z, 6, 4, this.fence, 4, direction);
            this.rotatedBeam(world, rand, x, y + 7, z, 6, 4, this.plank, 4, direction);
            this.rotatedBeam(world, rand, x, y + 8, z, 7, 4, this.fence, 2, direction);
            this.rotatedBeam(world, rand, x, y + 7, z, 4, 4, this.plank, 1, direction);
            this.rotatedBeam(world, rand, x, y + 7, z, 11, 4, this.plank, 1, direction);
            this.rotatedBeam(world, rand, x, y + 11, z, 3, 7, this.getStairRotations(this.stairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1))), 4, direction);
            this.rotatedBeam(world, rand, x, y + 10, z, 3, 6, this.getStairRotations(this.stairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1))), 4, direction);
            this.rotatedBeam(world, rand, x, y + 9, z, 3, 5, this.getStairRotations(this.stairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1))), 3, direction);
            this.rotatedBeam(world, rand, x, y + 8, z, 3, 4, this.getStairRotations(this.stairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1))), 2, direction);
            this.rotatedBeam(world, rand, x, y + 10, z, 3, 7, this.getStairRotations(this.stairs, direction == 0 ? 7 : (direction == 1 ? 5 : (direction == 2 ? 6 : 4))), 1, direction);
            this.rotatedBeam(world, rand, x, y + 9, z, 3, 6, this.getStairRotations(this.stairs, direction == 0 ? 7 : (direction == 1 ? 5 : (direction == 2 ? 6 : 4))), 1, direction);
            this.rotatedBeam(world, rand, x, y + 8, z, 3, 5, this.getStairRotations(this.stairs, direction == 0 ? 7 : (direction == 1 ? 5 : (direction == 2 ? 6 : 4))), 1, direction);
            this.rotatedBeam(world, rand, x, y + 11, z, 3, 8, this.getStairRotations(this.stairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0))), 4, direction);
            this.rotatedBeam(world, rand, x, y + 10, z, 3, 9, this.getStairRotations(this.stairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0))), 4, direction);
            this.rotatedBeam(world, rand, x, y + 9, z, 3, 10, this.getStairRotations(this.stairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0))), 3, direction);
            this.rotatedBeam(world, rand, x, y + 8, z, 3, 11, this.getStairRotations(this.stairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0))), 2, direction);
            this.rotatedBeam(world, rand, x, y + 10, z, 3, 8, this.getStairRotations(this.stairs, direction == 0 ? 6 : (direction == 1 ? 4 : (direction == 2 ? 7 : 5))), 1, direction);
            this.rotatedBeam(world, rand, x, y + 9, z, 3, 9, this.getStairRotations(this.stairs, direction == 0 ? 6 : (direction == 1 ? 4 : (direction == 2 ? 7 : 5))), 1, direction);
            this.rotatedBeam(world, rand, x, y + 8, z, 3, 10, this.getStairRotations(this.stairs, direction == 0 ? 6 : (direction == 1 ? 4 : (direction == 2 ? 7 : 5))), 1, direction);
            this.rotatedBeam(world, rand, x, y + 11, z, 7, 7, this.plank, 1, direction);
            this.rotatedBeam(world, rand, x, y + 11, z, 7, 8, this.plank, 1, direction);
        }
        boolean leftExtension = true;
        boolean rightExtension = true;
        boolean backExtension = true;
        if (!(leftExtension || rightExtension || backExtension)) {
            int direction = rand.nextInt(4);
            System.out.println("Door can only be on main building");
            this.rotatedBeam(world, rand, x, y, z, 7, 5, this.getDoorRotations(this.door, direction == 1 ? 1 : (direction == 3 ? 3 : (direction == 2 ? 2 : 0))).func_177226_a((IProperty)BlockDoorErebus.field_176521_M, (Comparable)(direction == 0 || direction == 2 ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT)), 1, direction);
            this.rotatedBeam(world, rand, x, y + 1, z, 7, 5, this.getDoorRotations(this.door, direction == 1 ? 5 : (direction == 3 ? 7 : (direction == 2 ? 6 : 4))).func_177226_a((IProperty)BlockDoorErebus.field_176521_M, (Comparable)(direction == 0 || direction == 2 ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT)), 1, direction);
            this.rotatedBeam(world, rand, x, y, z, 8, 5, this.getDoorRotations(this.door, direction == 1 ? 1 : (direction == 3 ? 3 : (direction == 2 ? 2 : 0))).func_177226_a((IProperty)BlockDoorErebus.field_176521_M, (Comparable)(direction == 0 || direction == 2 ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT)), 1, direction);
            this.rotatedBeam(world, rand, x, y + 1, z, 8, 5, this.getDoorRotations(this.door, direction == 1 ? 5 : (direction == 3 ? 7 : (direction == 2 ? 6 : 4))).func_177226_a((IProperty)BlockDoorErebus.field_176521_M, (Comparable)(direction == 0 || direction == 2 ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT)), 1, direction);
        }
        if (leftExtension) {
            this.addExtention(world, rand, x, y, z, 1);
            System.out.println("Has Left Wing");
        }
        if (backExtension) {
            this.addExtention(world, rand, x, y, z, 2);
            System.out.println("Has Back Wing");
        }
        if (rightExtension) {
            this.addExtention(world, rand, x, y, z, 3);
            System.out.println("Has Right Wing");
        }
        System.out.println("Added Hut at: " + x + " " + z);
        return true;
    }

    private void addExtention(World world, Random rand, int x, int y, int z, int direction) {
        int beamLength;
        this.rotatedBeam(world, rand, x, y + 2, z, 2, 6, this.getLogRotations(this.log, direction == 0 || direction == 2 ? 4 : 8), 3, direction);
        this.rotatedBeam(world, rand, x, y + 2, z, 2, 9, this.getLogRotations(this.log, direction == 0 || direction == 2 ? 4 : 8), 3, direction);
        for (int beamHeight = 0; beamHeight < 2; ++beamHeight) {
            this.rotatedBeam(world, rand, x, y + beamHeight, z, 1, 6, this.log, 1, direction);
            this.rotatedBeam(world, rand, x, y + beamHeight, z, 1, 9, this.log, 1, direction);
            this.rotatedBeam(world, rand, x, y + beamHeight, z, 4, 6, this.log, 1, direction);
            this.rotatedBeam(world, rand, x, y + beamHeight, z, 4, 9, this.log, 1, direction);
        }
        for (beamLength = 0; beamLength < 4; ++beamLength) {
            this.rotatedBeam(world, rand, x, y + 2, z, 1, 6 + beamLength, this.getLogRotations(this.log, direction == 0 || direction == 2 ? 8 : 4), 1, direction);
        }
        for (beamLength = 0; beamLength < 2; ++beamLength) {
            this.rotatedBeam(world, rand, x, y + 3, z, 1, 7 + beamLength, this.plank, 1, direction);
        }
        for (beamLength = 0; beamLength < 2; ++beamLength) {
            for (int beamHeight = 0; beamHeight < 3; ++beamHeight) {
                this.rotatedBeam(world, rand, x, y + beamHeight, z, 5, 7 + beamLength, Blocks.field_150350_a.func_176223_P(), 1, direction);
            }
        }
        for (beamLength = 0; beamLength < 2; ++beamLength) {
            this.rotatedBeam(world, rand, x, y, z, 1, 7 + beamLength, this.bricks, 1, direction);
            this.rotatedBeam(world, rand, x, y + 1, z, 1, 7 + beamLength, this.fence, 1, direction);
        }
        this.rotatedBeam(world, rand, x, y, z, 2, 6, this.bricks, 2, direction);
        this.rotatedBeam(world, rand, x, y + 1, z, 2, 6, this.fence, 2, direction);
        this.rotatedBeam(world, rand, x, y, z, 2, 9, this.bricks, 1, direction);
        this.rotatedBeam(world, rand, x, y + 1, z, 2, 9, this.plank, 1, direction);
        this.rotatedBeam(world, rand, x, y, z, 3, 9, this.getDoorRotations(this.door, direction == 1 ? 1 : (direction == 3 ? 3 : (direction == 2 ? 2 : 0))).func_177226_a((IProperty)BlockDoorErebus.field_176521_M, (Comparable)(direction == 0 || direction == 2 ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT)), 1, direction);
        this.rotatedBeam(world, rand, x, y + 1, z, 3, 9, this.getDoorRotations(this.door, direction == 1 ? 5 : (direction == 3 ? 7 : (direction == 2 ? 6 : 4))).func_177226_a((IProperty)BlockDoorErebus.field_176521_M, (Comparable)(direction == 0 || direction == 2 ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT)), 1, direction);
        this.rotatedBeam(world, rand, x, y + 2, z, 0, 5, this.getStairRotations(this.stairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1))), 5, direction);
        this.rotatedBeam(world, rand, x, y + 3, z, 0, 6, this.getStairRotations(this.stairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1))), 4, direction);
        this.rotatedBeam(world, rand, x, y + 4, z, 0, 7, this.getStairRotations(this.stairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1))), 4, direction);
        this.rotatedBeam(world, rand, x, y + 2, z, 0, 6, this.getStairRotations(this.stairs, direction == 0 ? 7 : (direction == 1 ? 5 : (direction == 2 ? 6 : 4))), 1, direction);
        this.rotatedBeam(world, rand, x, y + 3, z, 0, 7, this.getStairRotations(this.stairs, direction == 0 ? 7 : (direction == 1 ? 5 : (direction == 2 ? 6 : 4))), 1, direction);
        this.rotatedBeam(world, rand, x, y + 4, z, 0, 8, this.getStairRotations(this.stairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0))), 4, direction);
        this.rotatedBeam(world, rand, x, y + 3, z, 0, 9, this.getStairRotations(this.stairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0))), 4, direction);
        this.rotatedBeam(world, rand, x, y + 2, z, 0, 10, this.getStairRotations(this.stairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0))), 5, direction);
        this.rotatedBeam(world, rand, x, y + 3, z, 0, 8, this.getStairRotations(this.stairs, direction == 0 ? 6 : (direction == 1 ? 4 : (direction == 2 ? 7 : 5))), 1, direction);
        this.rotatedBeam(world, rand, x, y + 2, z, 0, 9, this.getStairRotations(this.stairs, direction == 0 ? 6 : (direction == 1 ? 4 : (direction == 2 ? 7 : 5))), 1, direction);
        this.rotatedBeam(world, rand, x, y + 3, z, 4, 6, this.plank, 1, direction);
        this.rotatedBeam(world, rand, x, y + 3, z, 4, 9, this.plank, 1, direction);
    }

    public void rotatedBeam(World world, Random rand, int x, int y, int z, int a, int b, IBlockState blockType, int size, int direction) {
        switch (direction) {
            case 0: {
                for (int xx = x + a; xx < x + a + size; ++xx) {
                    world.func_180501_a(new BlockPos(xx, y, z + b), blockType, 2);
                }
                break;
            }
            case 1: {
                for (int zz = z + a; zz < z + a + size; ++zz) {
                    world.func_180501_a(new BlockPos(x + b, y, zz), blockType, 2);
                }
                break;
            }
            case 2: {
                for (int xx = x + this.length - a - 1; xx > x + this.length - a - size - 1; --xx) {
                    world.func_180501_a(new BlockPos(xx, y, z + this.length - b - 1), blockType, 2);
                }
                break;
            }
            case 3: {
                for (int zz = z + this.length - a - 1; zz > z + this.length - a - size - 1; --zz) {
                    world.func_180501_a(new BlockPos(x + this.length - b - 1, y, zz), blockType, 2);
                }
                break;
            }
        }
    }

    public void verticalBeam(World world, Random rand, int x, int y, int z, IBlockState blockType, int size, int direction) {
        for (int yy = y; yy < y + size; ++yy) {
            world.func_180501_a(new BlockPos(x, yy, z), blockType, 2);
        }
    }

    public void horizontalBeam(World world, Random rand, int x, int y, int z, IBlockState blockType, int size, int direction) {
        switch (direction) {
            case 0: {
                for (int xx = x; xx < x + size; ++xx) {
                    world.func_180501_a(new BlockPos(xx, y, z), blockType, 2);
                }
                break;
            }
            case 1: {
                for (int zz = z; zz < z + size; ++zz) {
                    world.func_180501_a(new BlockPos(x, y, zz), blockType, 2);
                }
                break;
            }
        }
    }

    public IBlockState getStairRotations(IBlockState state, int blockMeta) {
        int direction = blockMeta;
        switch (direction) {
            case 0: {
                return state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            }
            case 1: {
                return state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
            }
            case 2: {
                return state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            }
            case 3: {
                return state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            }
            case 4: {
                return state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            case 5: {
                return state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            case 6: {
                return state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            case 7: {
                return state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
        }
        return state;
    }

    public IBlockState getDoorRotations(IBlockState state, int direction) {
        switch (direction) {
            case 0: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER);
            }
            case 1: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER);
            }
            case 2: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER);
            }
            case 3: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER);
            }
            case 4: {
                state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            }
            case 5: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            }
            case 6: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            }
            case 7: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            }
        }
        return state;
    }

    public IBlockState getLogRotations(IBlockState state, int axis) {
        if (axis == 4) {
            return state.func_177226_a((IProperty)BlockLogErebus.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        }
        if (axis == 8) {
            return state.func_177226_a((IProperty)BlockLogErebus.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
        }
        return state;
    }
}

