/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenTallJungleTree
extends WorldGenerator {
    private static final int[] offsetX = new int[]{-1, 1, 0, 0};
    private static final int[] offsetZ = new int[]{0, 0, -1, 1};
    private static final IBlockState JUMGLE_TRUNK = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int testY;
        int baseHeight = 3 + rand.nextInt(3);
        int branchAmount = 2 + rand.nextInt(4);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int treeHeight = baseHeight + branchAmount * 3 + 1;
        if (y <= 0 || y + treeHeight > 255) {
            return false;
        }
        for (testY = y + 1; testY < y + baseHeight; ++testY) {
            if (world.func_175623_d(new BlockPos(x, testY, z))) continue;
            return false;
        }
        for (testY = y + baseHeight; testY <= y + treeHeight; ++testY) {
            for (int testX = x - 2; testX <= x + 2; ++testX) {
                for (int testZ = z - 2; testZ <= z + 2; ++testZ) {
                    if (world.func_175623_d(new BlockPos(testX, testY, testZ))) continue;
                    return false;
                }
            }
        }
        if (world.func_180495_p(new BlockPos(x, y - 1, z)) != Blocks.field_150346_d.func_176223_P() && world.func_180495_p(new BlockPos(x, y - 1, z)) != Blocks.field_150349_c.func_176223_P()) {
            return false;
        }
        for (int yy = 0; yy < baseHeight; ++yy) {
            world.func_180501_a(new BlockPos(x, y + yy, z), JUMGLE_TRUNK, 3);
        }
        y += baseHeight;
        for (int branch = 0; branch < branchAmount; ++branch) {
            int b;
            int a;
            for (a = 0; a < 3; ++a) {
                world.func_180501_a(new BlockPos(x, y + branch * 3 + a, z), JUMGLE_TRUNK, 3);
            }
            for (a = 0; a < 2; ++a) {
                for (b = 0; b < 4; ++b) {
                    world.func_180501_a(new BlockPos(x + offsetX[b], y + branch * 3 + a * 2, z + offsetZ[b]), JUNGLE_LEAF, 3);
                }
            }
            for (a = 0; a < 2; ++a) {
                for (b = 0; b < 2; ++b) {
                    world.func_180501_a(new BlockPos(x - 1 + a * 2, y + branch * 3 + 1, z - 1 + b * 2), JUNGLE_LEAF, 3);
                }
            }
            for (a = 0; a < 4; ++a) {
                world.func_180501_a(new BlockPos(x + offsetX[a] * 2, y + branch * 3 + 1, z + offsetZ[a] * 2), JUNGLE_LEAF, 3);
            }
        }
        world.func_180501_a(new BlockPos(x, y += branchAmount * 3, z), JUNGLE_LEAF, 3);
        return true;
    }
}

