/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.someguyssoftware.gottschcore.loot.LootContext;
import com.someguyssoftware.gottschcore.loot.LootEntry;
import com.someguyssoftware.gottschcore.loot.LootTableManager;
import com.someguyssoftware.gottschcore.loot.conditions.LootCondition;
import com.someguyssoftware.gottschcore.loot.conditions.LootConditionManager;
import com.someguyssoftware.gottschcore.loot.functions.LootFunction;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class LootEntryItem
extends LootEntry {
    protected final Item item;
    protected final LootFunction[] functions;

    public LootEntryItem(Item itemIn, int weightIn, int qualityIn, LootFunction[] functionsIn, LootCondition[] conditionsIn, String entryName) {
        super(weightIn, qualityIn, conditionsIn, entryName);
        this.item = itemIn;
        this.functions = functionsIn;
    }

    @Override
    public void addLoot(Collection<ItemStack> stacks, Random rand, LootContext context) {
        ItemStack itemstack = new ItemStack(this.item);
        for (LootFunction lootfunction : this.functions) {
            if (!LootConditionManager.testAllConditions(lootfunction.getConditions(), rand, context)) continue;
            itemstack = lootfunction.apply(itemstack, rand, context);
        }
        if (!itemstack.func_190926_b()) {
            if (itemstack.func_190916_E() < this.item.getItemStackLimit(itemstack)) {
                stacks.add(itemstack);
            } else {
                ItemStack itemstack1;
                for (int i = itemstack.func_190916_E(); i > 0; i -= itemstack1.func_190916_E()) {
                    itemstack1 = itemstack.func_77946_l();
                    itemstack1.func_190920_e(Math.min(itemstack.func_77976_d(), i));
                    stacks.add(itemstack1);
                }
            }
        }
    }

    @Override
    protected void serialize(JsonObject json, JsonSerializationContext context) {
        ResourceLocation resourcelocation;
        if (this.functions != null && this.functions.length > 0) {
            json.add("functions", context.serialize((Object)this.functions));
        }
        if ((resourcelocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.item)) == null) {
            throw new IllegalArgumentException("Can't serialize unknown item " + this.item);
        }
        json.addProperty("name", resourcelocation.toString());
    }

    public static LootEntryItem deserialize(JsonObject object, JsonDeserializationContext deserializationContext, int weightIn, int qualityIn, LootCondition[] conditionsIn) {
        String name = LootTableManager.readLootEntryName(object, "item");
        Item item = null;
        try {
            item = JsonUtils.func_188180_i((JsonObject)object, (String)"name");
        }
        catch (JsonSyntaxException e) {
            item = Item.func_150898_a((Block)Blocks.field_150478_aa);
        }
        LootFunction[] alootfunction = object.has("functions") ? (LootFunction[])JsonUtils.func_188174_a((JsonObject)object, (String)"functions", (JsonDeserializationContext)deserializationContext, LootFunction[].class) : new LootFunction[]{};
        return new LootEntryItem(item, weightIn, qualityIn, alootfunction, conditionsIn, name);
    }
}

