/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.someguyssoftware.gottschcore.loot.LootContext;
import com.someguyssoftware.gottschcore.loot.conditions.LootCondition;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.RandomValueRange;

public class EntityHasScore
implements LootCondition {
    private final Map<String, RandomValueRange> scores;
    private final LootContext.EntityTarget target;

    public EntityHasScore(Map<String, RandomValueRange> scoreIn, LootContext.EntityTarget targetIn) {
        this.scores = scoreIn;
        this.target = targetIn;
    }

    @Override
    public boolean testCondition(Random rand, LootContext context) {
        Entity entity = context.getEntity(this.target);
        if (entity == null) {
            return false;
        }
        Scoreboard scoreboard = entity.field_70170_p.func_96441_U();
        for (Map.Entry<String, RandomValueRange> entry : this.scores.entrySet()) {
            if (this.entityScoreMatch(entity, scoreboard, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean entityScoreMatch(Entity entityIn, Scoreboard scoreboardIn, String objectiveStr, RandomValueRange rand) {
        ScoreObjective scoreobjective = scoreboardIn.func_96518_b(objectiveStr);
        if (scoreobjective == null) {
            return false;
        }
        String s = entityIn instanceof EntityPlayerMP ? entityIn.func_70005_c_() : entityIn.func_189512_bd();
        return !scoreboardIn.func_178819_b(s, scoreobjective) ? false : rand.func_186510_a(scoreboardIn.func_96529_a(s, scoreobjective).func_96652_c());
    }

    public static class Serializer
    extends LootCondition.Serializer<EntityHasScore> {
        protected Serializer() {
            super(new ResourceLocation("entity_scores"), EntityHasScore.class);
        }

        @Override
        public void serialize(JsonObject json, EntityHasScore value, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry entry : value.scores.entrySet()) {
                jsonobject.add((String)entry.getKey(), context.serialize(entry.getValue()));
            }
            json.add("scores", (JsonElement)jsonobject);
            json.add("entity", context.serialize((Object)value.target));
        }

        @Override
        public EntityHasScore deserialize(JsonObject json, JsonDeserializationContext context) {
            Set set = JsonUtils.func_152754_s((JsonObject)json, (String)"scores").entrySet();
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (Map.Entry entry : set) {
                map.put(entry.getKey(), JsonUtils.func_188179_a((JsonElement)((JsonElement)entry.getValue()), (String)"score", (JsonDeserializationContext)context, RandomValueRange.class));
            }
            return new EntityHasScore(map, (LootContext.EntityTarget)((Object)JsonUtils.func_188174_a((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class)));
        }
    }
}

