/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.someguyssoftware.gottschcore.loot.LootContext;
import com.someguyssoftware.gottschcore.loot.conditions.LootCondition;
import java.util.Random;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class RandomChance
implements LootCondition {
    private final float chance;

    public RandomChance(float chanceIn) {
        this.chance = chanceIn;
    }

    @Override
    public boolean testCondition(Random rand, LootContext context) {
        return rand.nextFloat() < this.chance;
    }

    public static class Serializer
    extends LootCondition.Serializer<RandomChance> {
        protected Serializer() {
            super(new ResourceLocation("random_chance"), RandomChance.class);
        }

        @Override
        public void serialize(JsonObject json, RandomChance value, JsonSerializationContext context) {
            json.addProperty("chance", (Number)Float.valueOf(value.chance));
        }

        @Override
        public RandomChance deserialize(JsonObject json, JsonDeserializationContext context) {
            return new RandomChance(JsonUtils.func_151217_k((JsonObject)json, (String)"chance"));
        }
    }
}

