/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.someguyssoftware.gottschcore.loot.LootContext;
import com.someguyssoftware.gottschcore.loot.conditions.LootCondition;
import com.someguyssoftware.gottschcore.loot.functions.LootFunction;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.RandomValueRange;

public class EnchantWithLevels
extends LootFunction {
    private final RandomValueRange randomLevel;
    private final boolean isTreasure;

    public EnchantWithLevels(LootCondition[] conditionsIn, RandomValueRange randomRange, boolean isTreasureIn) {
        super(conditionsIn);
        this.randomLevel = randomRange;
        this.isTreasure = isTreasureIn;
    }

    @Override
    public ItemStack apply(ItemStack stack, Random rand, LootContext context) {
        return EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)stack, (int)this.randomLevel.func_186511_a(rand), (boolean)this.isTreasure);
    }

    public static class Serializer
    extends LootFunction.Serializer<EnchantWithLevels> {
        public Serializer() {
            super(new ResourceLocation("enchant_with_levels"), EnchantWithLevels.class);
        }

        @Override
        public void serialize(JsonObject object, EnchantWithLevels functionClazz, JsonSerializationContext serializationContext) {
            object.add("levels", serializationContext.serialize((Object)functionClazz.randomLevel));
            object.addProperty("treasure", Boolean.valueOf(functionClazz.isTreasure));
        }

        @Override
        public EnchantWithLevels deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            RandomValueRange randomvaluerange = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)object, (String)"levels", (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            boolean flag = JsonUtils.func_151209_a((JsonObject)object, (String)"treasure", (boolean)false);
            return new EnchantWithLevels(conditionsIn, randomvaluerange, flag);
        }
    }
}

