/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.meta;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.json.JSMin;
import com.someguyssoftware.gottschcore.meta.IMeta;
import com.someguyssoftware.gottschcore.meta.Meta;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.resource.AbstractResourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class MetaManager
extends AbstractResourceManager {
    private static final String ASSETS_FOLDER = "assets";
    private final Map<String, IMeta> metaMap = Maps.newHashMap();

    public MetaManager(IMod mod, String resourceFolder) {
        super(mod, resourceFolder);
    }

    public void clear() {
        this.metaMap.clear();
    }

    public MetaManager loadAll(List<String> locations) {
        GottschCore.logger.debug("loading all meta files...");
        for (String location : locations) {
            GottschCore.logger.debug("loading from -> {}", (Object)location);
            this.load(new ResourceLocation(location));
        }
        return this;
    }

    public IMeta load(ResourceLocation location) {
        String key = location.toString();
        if (this.getMetaMap().containsKey(key)) {
            GottschCore.logger.debug("read meta from master map using key -> {}", (Object)key);
            return this.getMetaMap().get(key);
        }
        this.readMeta(location);
        GottschCore.logger.debug("output from master meta map:");
        if (this.getMetaMap().get(key) != null) {
            GottschCore.logger.debug("Loaded meta file from -> {}", (Object)key);
        } else {
            GottschCore.logger.debug("Unable to read meta file from -> {}", (Object)key);
        }
        return this.getMetaMap().containsKey(key) ? this.getMetaMap().get(key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readMeta(ResourceLocation location) {
        boolean bl;
        String loc = location.func_110623_a();
        GottschCore.logger.debug("meta file resource path -> {}", (Object)loc);
        String suffix = "";
        if (!loc.endsWith(".json")) {
            suffix = ".json";
        }
        Path path = Paths.get(this.getMod().getConfig().getConfigFolder(), this.getMod().getId(), loc + suffix);
        File file = path.toFile();
        GottschCore.logger.debug("template file path -> {}", (Object)file.getAbsoluteFile());
        if (!file.exists()) {
            GottschCore.logger.debug("file does not exist, read from jar -> {}", (Object)file.getAbsolutePath());
            return this.readFromJar(location);
        }
        GottschCore.logger.debug("read file from stream (file system) -> {}", (Object)file.getAbsolutePath());
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file);
            this.readFromStream(location.toString(), inputstream);
            bl = true;
        }
        catch (Throwable e) {
            boolean flag;
            try {
                GottschCore.logger.error("error reading from stream: ", e);
                flag = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            return flag;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean readFromJar(ResourceLocation location) {
        boolean bl;
        String resourceDomain = location.func_110624_b();
        String resourcePath = location.func_110623_a();
        InputStream inputstream = null;
        try {
            Path path = Paths.get(ASSETS_FOLDER, resourceDomain, this.getBaseResourceFolder(), resourcePath + ".json");
            GottschCore.logger.debug("attempting to open resource stream -> {}", (Object)path.toString());
            inputstream = this.getMod().getClass().getResourceAsStream(path.toString());
            this.readFromStream(location.toString(), inputstream);
            bl = true;
        }
        catch (Throwable var10) {
            try {
                GottschCore.logger.error("error reading resource: ", var10);
                boolean flag = false;
                return flag;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(inputstream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    protected void readFromStream(String id, InputStream stream) throws IOException, Exception {
        GottschCore.logger.debug("reading meta file from stream.");
        IMeta meta = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(stream, out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        try {
            meta = (IMeta)gson.fromJson(jsonReader, Meta.class);
            GottschCore.logger.debug("meta -> {}", (Object)meta);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to meta file:", e);
        }
        finally {
            try {
                jsonReader.close();
            }
            catch (IOException e) {
                GottschCore.logger.warn("Unable to close JSON Reader when reading meta file.");
            }
        }
        this.getMetaMap().put(id, meta);
    }

    public Map<String, IMeta> getMetaMap() {
        return this.metaMap;
    }
}

