/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.positional;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import javax.annotation.concurrent.Immutable;
import net.minecraft.util.math.AxisAlignedBB;

@Immutable
public class BBox {
    private ICoords minCoords;
    private ICoords maxCoords;

    public BBox(ICoords c1, ICoords c2) {
        int minX = Math.min(c1.getX(), c2.getX());
        int minY = Math.min(c1.getY(), c2.getY());
        int minZ = Math.min(c1.getZ(), c2.getZ());
        int maxX = Math.max(c1.getX(), c2.getX());
        int maxY = Math.max(c1.getY(), c2.getY());
        int maxZ = Math.max(c1.getZ(), c2.getZ());
        this.setMinCoords(new Coords(minX, minY, minZ));
        this.setMaxCoords(new Coords(maxX, maxY, maxZ));
    }

    public BBox(ICoords c) {
        this.setMinCoords(new Coords(c));
        this.setMaxCoords(c.add(1, 1, 1));
    }

    public BBox(AxisAlignedBB aabb) {
        this.setMinCoords(new Coords((int)aabb.field_72340_a, (int)aabb.field_72338_b, (int)aabb.field_72339_c));
        this.setMaxCoords(new Coords((int)aabb.field_72336_d, (int)aabb.field_72337_e, (int)aabb.field_72334_f));
    }

    public AxisAlignedBB toAABB() {
        return new AxisAlignedBB(this.minCoords.toPos(), this.maxCoords.toPos());
    }

    public boolean intersects(BBox other) {
        return this.toAABB().func_72326_a(other.toAABB());
    }

    public BBox grow(int value) {
        return new BBox(this.toAABB().func_186662_g((double)value));
    }

    public BBox grow(int x, int y, int z) {
        return new BBox(this.toAABB().func_72314_b((double)x, (double)y, (double)z));
    }

    public BBox expand(double x, double y, double z) {
        return new BBox(this.toAABB().func_72321_a(x, y, z));
    }

    public ICoords getMinCoords() {
        return this.minCoords;
    }

    public void setMinCoords(ICoords minCoords) {
        this.minCoords = minCoords;
    }

    public ICoords getMaxCoords() {
        return this.maxCoords;
    }

    public void setMaxCoords(ICoords maxCoords) {
        this.maxCoords = maxCoords;
    }
}

