/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.positional;

import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.ICoords;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

@Immutable
public class Coords
implements ICoords {
    private final int x;
    private final int y;
    private final int z;

    public Coords(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coords(ICoords coords) {
        this(coords.getX(), coords.getY(), coords.getZ());
    }

    public Coords(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Coords(Vec3d vec) {
        this(MathHelper.func_76128_c((double)vec.field_72450_a), MathHelper.func_76128_c((double)vec.field_72448_b), MathHelper.func_76128_c((double)vec.field_72449_c));
    }

    @Override
    public ICoords up(int n) {
        return new Coords(this.getX(), this.getY() + n, this.getZ());
    }

    @Override
    public ICoords down(int n) {
        return new Coords(this.getX(), this.getY() - n, this.getZ());
    }

    @Override
    public ICoords north(int n) {
        return new Coords(this.getX(), this.getY(), this.getZ() - n);
    }

    @Override
    public ICoords south(int n) {
        return new Coords(this.getX(), this.getY(), this.getZ() + n);
    }

    @Override
    public ICoords east(int n) {
        return new Coords(this.getX() + n, this.getY(), this.getZ());
    }

    @Override
    public ICoords west(int n) {
        return new Coords(this.getX() - n, this.getY(), this.getZ());
    }

    @Override
    public ICoords offset(EnumFacing facing) {
        return this.offset(facing, 1);
    }

    @Override
    public ICoords offset(EnumFacing facing, int n) {
        return n == 0 ? this : new Coords(this.getX() + facing.func_82601_c() * n, this.getY() + facing.func_96559_d() * n, this.getZ() + facing.func_82599_e() * n);
    }

    @Override
    public double getDistanceSq(double toX, double toY, double toZ) {
        double d0 = (double)this.getX() - toX;
        double d1 = (double)this.getY() - toY;
        double d2 = (double)this.getZ() - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    @Override
    public double getDistanceSq(ICoords coords) {
        return this.getDistanceSq(coords.getX(), coords.getY(), coords.getZ());
    }

    @Override
    public double getDistance(double x, double y, double z) {
        double d0 = (double)this.getX() - x;
        double d1 = (double)this.getY() - y;
        double d2 = (double)this.getZ() - z;
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    @Override
    public double getDistance(ICoords coords) {
        return this.getDistance(coords.getX(), coords.getY(), coords.getZ());
    }

    @Override
    public double getXZAngle(double targetX, double targetZ) {
        double angle = Math.toDegrees(Math.atan2(targetZ - (double)this.getZ(), targetX - (double)this.getX()));
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    @Override
    public double getXZAngle(ICoords coords) {
        return this.getXZAngle(coords.getX(), coords.getZ());
    }

    @Override
    public ICoords add(int x, int y, int z) {
        Coords coords = new Coords(this.x + x, this.y + y, this.z + z);
        return coords;
    }

    @Override
    public ICoords add(ICoords coords) {
        Coords c = new Coords(this.x + coords.getX(), this.y + coords.getY(), this.z + coords.getZ());
        return c;
    }

    @Override
    public ICoords add(Direction direction, int n) {
        switch (direction) {
            case NORTH: {
                return this.north(n);
            }
            case EAST: {
                return this.east(n);
            }
            case SOUTH: {
                return this.south(n);
            }
            case WEST: {
                return this.west(n);
            }
            case UP: {
                return this.up(n);
            }
            case DOWN: {
                return this.down(n);
            }
        }
        return this;
    }

    @Override
    public ICoords withX(ICoords coords) {
        return new Coords(coords.getX(), this.getY(), this.getZ());
    }

    @Override
    public ICoords withX(int x) {
        return new Coords(x, this.getY(), this.getZ());
    }

    @Override
    public ICoords withY(ICoords coords) {
        return new Coords(this.getX(), coords.getY(), this.getZ());
    }

    @Override
    public ICoords withY(int y) {
        return new Coords(this.getX(), y, this.getZ());
    }

    @Override
    public ICoords withZ(ICoords coords) {
        return new Coords(this.getX(), this.getY(), coords.getZ());
    }

    @Override
    public ICoords withZ(int z) {
        return new Coords(this.getX(), this.getY(), z);
    }

    @Override
    public ICoords delta(ICoords coords) {
        Coords c = new Coords(this.x - coords.getX(), this.y - coords.getY(), this.z - coords.getZ());
        return c;
    }

    @Override
    public BlockPos toPos() {
        return new BlockPos(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public ChunkPos toChunkPos() {
        return new ChunkPos(this.toPos());
    }

    @Override
    public ICoords rotate(double xlen, double zlen, double degrees) {
        double s = Math.sin(Math.toRadians(degrees));
        double c = Math.cos(Math.toRadians(degrees));
        double xnew = xlen * c - zlen * s;
        double znew = xlen * s + zlen * c;
        ICoords coords = this.add((int)xnew, 0, (int)znew);
        return coords;
    }

    @Override
    public ICoords rotate90(int width) {
        Coords coords = new Coords(width - this.getZ() - 1, this.getY(), this.getX());
        return coords;
    }

    @Override
    public ICoords rotate180(int depth, int width) {
        Coords coords = new Coords(width - this.getX() - 1, this.getY(), depth - this.getZ() - 1);
        return coords;
    }

    @Override
    public ICoords rotate270(int depth) {
        Coords coords = new Coords(this.z, this.y, depth - this.getX() - 1);
        return coords;
    }

    @Override
    public int get(int axis) {
        switch (axis) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return this.x;
    }

    @Override
    public int get(char axis) {
        switch (axis) {
            case 'X': 
            case 'x': {
                return this.x;
            }
            case 'Y': 
            case 'y': {
                return this.y;
            }
            case 'Z': 
            case 'z': {
                return this.z;
            }
        }
        return this.x;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        try {
            nbt.func_74768_a("x", this.getX());
            nbt.func_74768_a("y", this.getY());
            nbt.func_74768_a("z", this.getZ());
        }
        catch (Exception e) {
            GottschCore.logger.error("Unable to write state to NBT:", (Throwable)e);
        }
        return nbt;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    @Deprecated
    public ICoords resetX(int x) {
        return new Coords(x, this.getY(), this.getZ());
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    @Deprecated
    public ICoords resetY(int y) {
        return new Coords(this.getX(), y, this.getZ());
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    @Deprecated
    public ICoords resetZ(int z) {
        return new Coords(this.getX(), this.getY(), z);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coords other = (Coords)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    @Override
    public String toString() {
        return "Coords [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    @Override
    public String toShortString() {
        return this.x + " " + this.y + " " + this.z;
    }

    public static String toShortString(BlockPos pos) {
        return pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p();
    }
}

