/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.version;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.version.BuildVersion;
import com.someguyssoftware.gottschcore.version.VersionPackage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.commons.io.IOUtils;

public class VersionChecker {
    public static BuildVersion getVersion(String url, BuildVersion mv) {
        InputStream in = null;
        String json = null;
        try {
            in = new URL(url).openStream();
            json = IOUtils.toString((InputStream)in, (Charset)Charset.forName("UTF-8"));
            GottschCore.logger.info("Published Version Info: " + json);
        }
        catch (MalformedURLException e) {
            GottschCore.logger.warn("Bad URL: " + url);
            return BuildVersion.EMPTY_VERSION;
        }
        catch (IOException e) {
            GottschCore.logger.warn("IO Exception occurred: " + e.getMessage());
            return BuildVersion.EMPTY_VERSION;
        }
        catch (Exception e) {
            GottschCore.logger.warn("Unexpected exception occurred: " + e.getMessage());
            return BuildVersion.EMPTY_VERSION;
        }
        try {
            Gson gson = new Gson();
            Type collectionType = new TypeToken<Collection<VersionPackage>>(){}.getType();
            List packages = (List)gson.fromJson(json, collectionType);
            for (VersionPackage pack : packages) {
                BuildVersion v = pack.getMinecraft();
                if (v.getMajor() != mv.getMajor() || v.getMinor() != mv.getMinor() || v.getBuild() != mv.getBuild()) continue;
                return pack.getMod();
            }
        }
        catch (JsonSyntaxException e) {
            GottschCore.logger.warn("Bad JSON Syntax: " + json, (Throwable)e);
            return BuildVersion.EMPTY_VERSION;
        }
        catch (Exception e) {
            GottschCore.logger.warn("Unexpected expection processing json: " + json, (Throwable)e);
            return BuildVersion.EMPTY_VERSION;
        }
        return BuildVersion.EMPTY_VERSION;
    }

    public static BuildVersion getVersionUsingForge(IMod mod) {
        BuildVersion buildVersion = BuildVersion.EMPTY_VERSION;
        URL url = null;
        try {
            url = new URL(mod.getUpdateURL());
        }
        catch (MalformedURLException e) {
            GottschCore.logger.warn("Unable to open updateURL:" + mod.getUpdateURL(), (Throwable)e);
            return buildVersion;
        }
        GottschCore.logger.info("[{}] Starting version check at {}", (Object)mod.getId(), (Object)url.toString());
        String data = null;
        try {
            InputStream con = url.openStream();
            data = new String(ByteStreams.toByteArray((InputStream)con), "UTF-8");
            con.close();
        }
        catch (Exception e) {
            GottschCore.logger.warn("Unexpected expection in data stream: ", (Throwable)e);
            return buildVersion;
        }
        GottschCore.logger.debug("[{}] Received version check data:\n{}", (Object)mod.getId(), (Object)data);
        try {
            Map json = (Map)new Gson().fromJson(data, Map.class);
            Map promos = (Map)json.get("promos");
            String rec = (String)promos.get("1.12.2-recommended");
            String lat = (String)promos.get("1.12.2-latest");
            if (rec != null) {
                buildVersion = new BuildVersion(rec);
            } else if (lat != null) {
                buildVersion = new BuildVersion(lat);
            }
        }
        catch (JsonSyntaxException e) {
            GottschCore.logger.warn("Bad JSON Syntax: " + data, (Throwable)e);
        }
        catch (Exception e) {
            GottschCore.logger.warn("Unexpected expection processing json: " + data, (Throwable)e);
        }
        return buildVersion;
    }

    public static boolean checkVersion(BuildVersion version, BuildVersion modVersion) {
        if (version.getMajor() > modVersion.getMajor()) {
            return false;
        }
        if (version.getMajor() == modVersion.getMajor()) {
            if (version.getMinor() > modVersion.getMinor()) {
                return false;
            }
            if (version.getMinor() == modVersion.getMinor() && version.getBuild() > modVersion.getBuild()) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkVersionUsingForge(BuildVersion version, BuildVersion modVersion) throws Exception {
        if (version == null || modVersion == null) {
            return true;
        }
        ComparableVersion current = new ComparableVersion(modVersion.toString());
        ComparableVersion recommended = new ComparableVersion(version.toString());
        int diff = recommended.compareTo(current);
        return diff <= 0;
    }
}

