/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.world.gen.structure;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.json.JSMin;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.resource.AbstractResourceManager;
import com.someguyssoftware.gottschcore.world.gen.structure.DecayRuleSet;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayRuleSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class DecayManager
extends AbstractResourceManager {
    private static final String ASSETS_FOLDER = "assets";
    private final Map<String, IDecayRuleSet> ruleSetMap = Maps.newHashMap();

    public DecayManager(IMod mod, String resourceFolder) {
        super(mod, resourceFolder);
    }

    public void clear() {
        this.ruleSetMap.clear();
    }

    public DecayManager loadAll(List<String> locations) {
        GottschCore.logger.debug("loading all decay ruleset files...");
        for (String location : locations) {
            GottschCore.logger.debug("loading from -> {}", (Object)location);
            this.load(new ResourceLocation(location));
        }
        return this;
    }

    public IDecayRuleSet load(ResourceLocation location) {
        String key = location.toString();
        if (this.getRuleSetMap().containsKey(key)) {
            GottschCore.logger.debug("read ruleset from master map using key -> {}", (Object)key);
            return this.getRuleSetMap().get(key);
        }
        this.readRuleSet(location);
        GottschCore.logger.debug("output from master decayRuleSet map:");
        for (Map.Entry<String, IDecayRuleSet> entry : this.getRuleSetMap().entrySet()) {
            GottschCore.logger.debug("key: {}, value: {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
        if (this.getRuleSetMap().get(key) != null) {
            GottschCore.logger.debug("Loaded decayRuleSet file from -> {}", (Object)key);
        } else {
            GottschCore.logger.debug("Unable to read decayRuleSet file from -> {}", (Object)key);
        }
        return this.getRuleSetMap().containsKey(key) ? this.getRuleSetMap().get(key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readRuleSet(ResourceLocation location) {
        boolean bl;
        String loc = location.func_110623_a();
        GottschCore.logger.debug("decay ruleset file resource path -> {}", (Object)loc);
        String suffix = "";
        if (!loc.endsWith(".json")) {
            suffix = ".json";
        }
        Path path = Paths.get(this.getMod().getConfig().getConfigFolder(), this.getMod().getId(), loc + suffix);
        File file = path.toFile();
        GottschCore.logger.debug("template file path -> {}", (Object)file.getAbsoluteFile());
        if (!file.exists()) {
            GottschCore.logger.debug("file does not exist, read from jar -> {}", (Object)file.getAbsolutePath());
            return this.readFromJar(location);
        }
        GottschCore.logger.debug("read file from stream (file system) -> {}", (Object)file.getAbsolutePath());
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file);
            this.readFromStream(location.toString(), inputstream);
            bl = true;
        }
        catch (Throwable e) {
            boolean flag;
            try {
                GottschCore.logger.error("error reading from stream: ", e);
                flag = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            return flag;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean readFromJar(ResourceLocation location) {
        boolean bl;
        String resourceDomain = location.func_110624_b();
        String resourcePath = location.func_110623_a();
        InputStream inputstream = null;
        try {
            Path path = Paths.get(ASSETS_FOLDER, resourceDomain, this.getBaseResourceFolder(), resourcePath + ".json");
            GottschCore.logger.debug("attempting to open resource stream -> {}", (Object)path.toString());
            inputstream = this.getMod().getClass().getResourceAsStream(path.toString());
            this.readFromStream(location.toString(), inputstream);
            bl = true;
        }
        catch (Throwable var10) {
            try {
                GottschCore.logger.error("error reading resource: ", var10);
                boolean flag = false;
                return flag;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(inputstream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    protected void readFromStream(String id, InputStream stream) throws IOException, Exception {
        GottschCore.logger.debug("reading decayRuleSet file from stream.");
        IDecayRuleSet decayRuleSet = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(stream, out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        try {
            decayRuleSet = (IDecayRuleSet)gson.fromJson(jsonReader, DecayRuleSet.class);
            GottschCore.logger.debug("decayRuleSet -> {}", (Object)decayRuleSet);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load decayRuleSet file:", e);
        }
        finally {
            try {
                jsonReader.close();
            }
            catch (IOException e) {
                GottschCore.logger.warn("Unable to close JSON Reader when reading decayRuleSet file.");
            }
        }
        this.getRuleSetMap().put(id, decayRuleSet);
    }

    public Map<String, IDecayRuleSet> getRuleSetMap() {
        return this.ruleSetMap;
    }
}

