/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.world.gen.structure;

import com.google.common.collect.Maps;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.resource.AbstractResourceManager;
import com.someguyssoftware.gottschcore.world.gen.structure.GottschTemplate;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.io.IOUtils;

public class GottschTemplateManager
extends AbstractResourceManager {
    private final DataFixer fixer;
    private final Map<String, Template> templates = Maps.newHashMap();
    private List<Block> markerScanList;
    private Map<StructureMarkers, Block> markerMap;
    private Map<IBlockState, IBlockState> replacementMap;

    public GottschTemplateManager(IMod mod, String resourceFolder, DataFixer fixer) {
        super(mod, resourceFolder);
        this.fixer = fixer;
        this.markerMap = Maps.newHashMapWithExpectedSize((int)10);
        this.markerMap.put(StructureMarkers.CHEST, (Block)Blocks.field_150486_ae);
        this.markerMap.put(StructureMarkers.BOSS_CHEST, Blocks.field_150477_bB);
        this.markerMap.put(StructureMarkers.SPAWNER, Blocks.field_150474_ac);
        this.markerMap.put(StructureMarkers.ENTRANCE, Blocks.field_150340_R);
        this.markerMap.put(StructureMarkers.OFFSET, Blocks.field_150451_bX);
        this.markerMap.put(StructureMarkers.PROXIMITY_SPAWNER, Blocks.field_150339_S);
        this.markerMap.put(StructureMarkers.NULL, Blocks.field_150357_h);
        this.markerScanList = Arrays.asList(this.markerMap.get((Object)StructureMarkers.CHEST), this.markerMap.get((Object)StructureMarkers.BOSS_CHEST), this.markerMap.get((Object)StructureMarkers.SPAWNER), this.markerMap.get((Object)StructureMarkers.ENTRANCE), this.markerMap.get((Object)StructureMarkers.OFFSET), this.markerMap.get((Object)StructureMarkers.PROXIMITY_SPAWNER));
        this.replacementMap = Maps.newHashMap();
        this.replacementMap.put(Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE), Blocks.field_150350_a.func_176223_P());
        this.replacementMap.put(Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLACK), Blocks.field_150474_ac.func_176223_P());
    }

    public GottschTemplateManager loadAll(List<String> locations) {
        GottschCore.logger.debug("loading all structures...");
        for (String location : locations) {
            GottschCore.logger.debug("loading from -> {}", (Object)location);
            this.load(new ResourceLocation(location), this.markerScanList, this.replacementMap);
        }
        return this;
    }

    public Template load(ResourceLocation templatePath, List<Block> markerBlocks, Map<IBlockState, IBlockState> replacementBlocks) {
        String key = templatePath.toString();
        if (this.getTemplates().containsKey(key)) {
            GottschCore.logger.debug("read template from master map using key -> {}", (Object)key);
            return this.templates.get(key);
        }
        this.readTemplate(templatePath, markerBlocks, replacementBlocks);
        if (this.templates.get(key) != null) {
            GottschCore.logger.debug("Loaded template from -> {}", (Object)key);
        } else {
            GottschCore.logger.debug("Unable to read template from -> {}", (Object)key);
        }
        return this.templates.containsKey(key) ? this.templates.get(key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readTemplate(ResourceLocation location, List<Block> markerBlocks, Map<IBlockState, IBlockState> replacementBlocks) {
        boolean bl;
        String s = location.func_110623_a();
        GottschCore.logger.debug("template resource path -> {}", (Object)s);
        String suffix = "";
        if (!s.endsWith(".nbt")) {
            suffix = ".nbt";
        }
        Path path = Paths.get(this.getMod().getConfig().getConfigFolder(), this.getMod().getId(), s + suffix);
        File file1 = path.toFile();
        GottschCore.logger.debug("template file path -> {}", (Object)file1.getAbsoluteFile());
        if (!file1.exists()) {
            GottschCore.logger.debug("file does not exist, read from jar -> {}", (Object)file1.getAbsolutePath());
            return this.readTemplateFromJar(location, markerBlocks, replacementBlocks);
        }
        GottschCore.logger.debug("reading template from file system using file path -> {}", (Object)file1.getAbsolutePath());
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file1);
            this.readTemplateFromStream(location.toString(), inputstream, markerBlocks, replacementBlocks);
            bl = true;
        }
        catch (Throwable var10) {
            boolean flag;
            try {
                flag = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            return flag;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readTemplateFromJar(ResourceLocation id, List<Block> markerBlocks, Map<IBlockState, IBlockState> replacementBlocks) {
        boolean bl;
        String s = id.func_110624_b();
        String s1 = id.func_110623_a();
        InputStream inputstream = null;
        try {
            GottschCore.logger.debug("attempting to open resource stream -> {}", (Object)("/assets/" + s + "/strucutres/" + s1 + ".nbt"));
            inputstream = MinecraftServer.class.getResourceAsStream("/assets/" + s + "/structures/" + s1 + ".nbt");
            this.readTemplateFromStream(id.toString(), inputstream, markerBlocks, replacementBlocks);
            bl = true;
        }
        catch (Throwable var10) {
            try {
                GottschCore.logger.error("error reading resource: ", var10);
                boolean flag = false;
                return flag;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(inputstream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    private void readTemplateFromStream(String id, InputStream stream, List<Block> markerBlocks, Map<IBlockState, IBlockState> replacementBlocks) throws IOException {
        NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        if (!nbttagcompound.func_150297_b("DataVersion", 99)) {
            nbttagcompound.func_74768_a("DataVersion", 500);
        }
        GottschTemplate template = new GottschTemplate();
        template.read(this.fixer.func_188257_a((IFixType)FixTypes.STRUCTURE, nbttagcompound), markerBlocks, replacementBlocks);
        GottschCore.logger.debug("adding template to map with key -> {}", (Object)id);
        this.templates.put(id, template);
    }

    public void remove(ResourceLocation templatePath) {
        this.templates.remove(templatePath.func_110623_a());
    }

    public Map<String, Template> getTemplates() {
        return this.templates;
    }

    public List<Block> getMarkerScanList() {
        return this.markerScanList;
    }

    public void setMarkerScanList(List<Block> scanList) {
        this.markerScanList = scanList;
    }

    public Map<StructureMarkers, Block> getMarkerMap() {
        return this.markerMap;
    }

    public void setMarkerMap(Map<StructureMarkers, Block> markerMap) {
        this.markerMap = markerMap;
    }

    public DataFixer getFixer() {
        return this.fixer;
    }

    public Map<IBlockState, IBlockState> getReplacementMap() {
        return this.replacementMap;
    }

    public void setReplacementMap(Map<IBlockState, IBlockState> replacementMap) {
        this.replacementMap = replacementMap;
    }
}

