/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.entities.IAggressive;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.init.ModEnchantments;
import com.Fishmod.mod_LavaCow.init.Modblocks;
import com.Fishmod.mod_LavaCow.mod_LavaCow;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityZombieMushroom
extends EntityZombie
implements IAggressive {
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityZombieMushroom.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean isAggressive = false;
    private int attackTimer;
    private Vec3d[] spore_color = new Vec3d[]{new Vec3d(0.83, 0.73, 0.5), new Vec3d(0.0, 0.98, 0.93)};

    public EntityZombieMushroom(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.95f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN_TYPE, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean func_70601_bi() {
        if (this.field_71093_bK == DimensionType.OVERWORLD.func_186068_a()) {
            return super.func_70601_bi();
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 20 == 0) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0));
            for (Entity entity1 : list) {
                if (!(entity1 instanceof EntityLivingBase)) continue;
                float local_difficulty = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
                if (((EntityLivingBase)entity1).func_70660_b(MobEffects.field_76436_u) != null) continue;
                ((EntityLivingBase)entity1).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 40 * (int)local_difficulty, 0));
            }
        }
        if (this.field_70173_aa % 5 == 0 && this.func_130014_f_().field_72995_K) {
            mod_LavaCow.PROXY.spawnCustomParticle("spore", this.field_70170_p, this.field_70165_t + (double)(new Random().nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(new Random().nextFloat() * this.field_70131_O), this.field_70161_v + (double)(new Random().nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, (float)this.spore_color[this.getSkin()].field_72450_a, (float)this.spore_color[this.getSkin()].field_72448_b, (float)this.spore_color[this.getSkin()].field_72449_c);
        }
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (super.func_70652_k(par1Entity)) {
            this.attackTimer = 5;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            return true;
        }
        return false;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData) {
        boolean is_near_shroom = false;
        int dx = MathHelper.func_76128_c((double)this.field_70165_t);
        int dy = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int dz = MathHelper.func_76128_c((double)this.field_70161_v);
        int r = 4;
        for (BlockPos C : BlockPos.func_177980_a((BlockPos)new BlockPos(dx - r, dy - r, dz - r), (BlockPos)new BlockPos(dx + r, dy + r, dz + r))) {
            if (this.func_130014_f_().func_180495_p(C).func_177230_c() != Modblocks.GLOWSHROOM && this.func_130014_f_().func_180495_p(C).func_177230_c() != Modblocks.GLOWSHROOM_BLOCK_STEM && this.func_130014_f_().func_180495_p(C).func_177230_c() != Modblocks.GLOWSHROOM_BLOCK_CAP) continue;
            is_near_shroom = true;
        }
        if (is_near_shroom || this.field_70163_u < 50.0 && !this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v))) {
            this.setSkin(1);
        }
        return super.func_180482_a(difficulty, entityLivingData);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.isAggressive = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        } else {
            this.isAggressive = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)34);
        }
    }

    @Override
    public boolean isAggressive() {
        return this.isAggressive;
    }

    @Override
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    public void setAttackTimer(int i) {
        this.attackTimer = i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 5;
        } else if (id == 11) {
            this.isAggressive = true;
        } else if (id == 34) {
            this.isAggressive = false;
        } else {
            super.func_70103_a(id);
        }
    }

    protected SoundEvent func_184639_G() {
        return FishItems.ENTITY_ZOMBIEFROZEN_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FishItems.ENTITY_ZOMBIEFROZEN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_ZOMBIEFROZEN_DEATH;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Random random = new Random();
            if (random.nextFloat() < 0.1f) {
                int getVariant = this.getSkin();
                switch (getVariant) {
                    case 0: {
                        this.func_70099_a(new ItemStack((Block)Modblocks.CORDY_SHROOM, 1), 0.0f);
                        break;
                    }
                    case 1: {
                        this.func_70099_a(new ItemStack((Block)Modblocks.GLOWSHROOM, 1), 0.0f);
                        break;
                    }
                }
            }
            int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)cause.func_76346_g(), (DamageSource)cause);
            if (this.func_146066_aG()) {
                LootTableHandler.dropRareLoot((Entity)this, FishItems.POISONSPORE, Modconfig.ZombieMushroom_DropSpore, ModEnchantments.POISONOUS, 3, i);
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && !this.func_70027_ad()) {
                this.makeAreaOfEffectCloud(this);
            }
        }
    }

    private void makeAreaOfEffectCloud(EntityZombieMushroom EntityIn) {
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(EntityIn.field_70170_p, EntityIn.field_70165_t, EntityIn.field_70163_u, EntityIn.field_70161_v);
        float local_difficulty = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
        entityareaeffectcloud.func_184481_a((EntityLivingBase)EntityIn);
        entityareaeffectcloud.func_184483_a(3.0f);
        entityareaeffectcloud.func_184495_b(-0.5f);
        entityareaeffectcloud.func_184485_d(10);
        entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
        entityareaeffectcloud.func_184484_a(PotionTypes.field_185254_z);
        entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76436_u, 40 * (int)local_difficulty, 0));
        entityareaeffectcloud.func_184482_a(5149489);
        EntityIn.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Variant", this.getSkin());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSkin(nbt.func_74762_e("Variant"));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.ZOMBIEMUSHROOM;
    }
}

