/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common;

import java.io.File;
import me.ichun.mods.hats.client.core.EventHandlerClient;
import me.ichun.mods.hats.common.core.Config;
import me.ichun.mods.hats.common.core.EventHandlerServer;
import me.ichun.mods.hats.common.core.HatHandler;
import me.ichun.mods.hats.common.core.HatInfo;
import me.ichun.mods.hats.common.core.ProxyCommon;
import me.ichun.mods.hats.common.core.SessionState;
import me.ichun.mods.ichunutil.common.core.Logger;
import me.ichun.mods.ichunutil.common.core.config.ConfigBase;
import me.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.core.network.PacketChannel;
import me.ichun.mods.ichunutil.common.module.update.UpdateChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;

@Mod(modid="hats", name="Hats", version="7.1.1", certificateFingerprint="4db5c2bd1b556f252a5b8b54b256d381b2a0a6b8", guiFactory="me.ichun.mods.ichunutil.common.core.config.GenericModGuiFactory", dependencies="required-after:ichunutil@[7.0.2,8.0.0)", acceptableRemoteVersions="[7.1.0,7.2.0)", acceptedMinecraftVersions="[1.12,1.13)")
public class Hats {
    public static final String VERSION = "7.1.1";
    public static final String MOD_NAME = "Hats";
    public static final String MOD_ID = "hats";
    public static final Logger LOGGER = Logger.createLogger((String)"Hats");
    public static PacketChannel channel;
    public static Config config;
    public static HatInfo favouriteHatInfo;
    @Mod.Instance(value="hats")
    public static Hats instance;
    @SidedProxy(clientSide="me.ichun.mods.hats.client.core.ProxyClient", serverSide="me.ichun.mods.hats.common.core.ProxyCommon")
    public static ProxyCommon proxy;
    public static EventHandlerServer eventHandlerServer;
    public static EventHandlerClient eventHandlerClient;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        HatHandler.hatsFolder = new File(event.getModConfigurationDirectory().getParent(), "/mods/hats");
        if (!HatHandler.hatsFolder.exists()) {
            HatHandler.hatsFolder.mkdirs();
        }
        config = (Config)ConfigHandler.registerConfig((ConfigBase)new Config(event.getSuggestedConfigurationFile()));
        proxy.preInitMod();
        UpdateChecker.registerMod((UpdateChecker.ModVersionInfo)new UpdateChecker.ModVersionInfo(MOD_NAME, "1.12.2", VERSION, false));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerAboutToStartEvent event) {
        SessionState.serverHasMod = 1;
        SessionState.currentKing = "";
        proxy.initCommands(event.getServer());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        Hats.eventHandlerServer.mobHats.clear();
        Hats.eventHandlerServer.playerHats.clear();
        Hats.eventHandlerServer.playerActivity.clear();
        Hats.eventHandlerServer.playerTradeRequests.clear();
        Hats.eventHandlerServer.activeTrades.clear();
        Hats.proxy.playerWornHats.clear();
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (event.getSource() != null && event.getSource().isFile()) {
            LOGGER.warn((Object)("The file " + event.getSource().getName() + " has been modified. Support for the mod will not be provided."));
        }
    }

    public static void console(String s, boolean warning) {
        StringBuilder sb = new StringBuilder();
        if (warning) {
            LOGGER.warn((Object)sb.append("[").append(VERSION).append("] ").append(s).toString());
        } else {
            LOGGER.info((Object)sb.append("[").append(VERSION).append("] ").append(s).toString());
        }
    }

    public static void console(String s) {
        Hats.console(s, false);
    }

    static {
        favouriteHatInfo = new HatInfo();
    }
}

