/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.gui;

import com.feed_the_beast.ftblib.lib.EnumTeamColor;
import com.feed_the_beast.ftblib.lib.client.CachedVertexData;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.misc.ChunkSelectorMap;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiChunkSelectorBase;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbutilities.events.chunks.UpdateClientDataEvent;
import com.feed_the_beast.ftbutilities.gui.ClientClaimedChunks;
import com.feed_the_beast.ftbutilities.net.MessageClaimedChunksModify;
import com.feed_the_beast.ftbutilities.net.MessageClaimedChunksRequest;
import com.feed_the_beast.ftbutilities.net.MessageClaimedChunksUpdate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="ftbutilities", value={Side.CLIENT})
public class GuiClaimedChunks
extends GuiChunkSelectorBase {
    public static GuiClaimedChunks instance;
    private static final ClientClaimedChunks.ChunkData[] chunkData;
    private static int claimedChunks;
    private static int loadedChunks;
    private static int maxClaimedChunks;
    private static int maxLoadedChunks;
    private static final ClientClaimedChunks.ChunkData NULL_CHUNK_DATA;
    private static final CachedVertexData AREA;
    private final String currentDimName;

    @Nullable
    private static ClientClaimedChunks.ChunkData getAt(int x, int y) {
        int i = x + y * 15;
        return i < 0 || i >= chunkData.length ? null : chunkData[i];
    }

    private static boolean hasBorder(ClientClaimedChunks.ChunkData data, @Nullable ClientClaimedChunks.ChunkData with) {
        if (with == null) {
            with = NULL_CHUNK_DATA;
        }
        return (data.flags != with.flags || data.team != with.team) && !with.isLoaded();
    }

    @SubscribeEvent
    public static void onChunkDataUpdate(UpdateClientDataEvent event) {
        ClientClaimedChunks.ChunkData data;
        MessageClaimedChunksUpdate m = event.getMessage();
        claimedChunks = m.claimedChunks;
        loadedChunks = m.loadedChunks;
        maxClaimedChunks = m.maxClaimedChunks;
        maxLoadedChunks = m.maxLoadedChunks;
        Arrays.fill(chunkData, null);
        for (ClientClaimedChunks.Team team : m.teams.values()) {
            for (Map.Entry<Integer, ClientClaimedChunks.ChunkData> entry : team.chunks.entrySet()) {
                int x = entry.getKey() % 15;
                int z = entry.getKey() / 15;
                GuiClaimedChunks.chunkData[x + z * 15] = entry.getValue();
            }
        }
        AREA.reset();
        EnumTeamColor prevCol = null;
        for (int i = 0; i < chunkData.length; ++i) {
            data = chunkData[i];
            if (data == null) continue;
            if (prevCol != data.team.color) {
                prevCol = data.team.color;
                GuiClaimedChunks.AREA.color.set(data.team.color.getColor(), 150);
            }
            AREA.rect(i % 15 * 12, i / 15 * 12, 12, 12);
        }
        for (int i = 0; i < chunkData.length; ++i) {
            boolean borderR;
            data = chunkData[i];
            if (data == null) continue;
            int x = i % 15;
            int dx = x * 12;
            int y = i / 15;
            int dy = y * 12;
            boolean borderU = y > 0 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x, y - 1));
            boolean borderD = y < 14 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x, y + 1));
            boolean borderL = x > 0 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x - 1, y));
            boolean bl = borderR = x < 14 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x + 1, y));
            if (data.isLoaded()) {
                GuiClaimedChunks.AREA.color.set(255, 80, 80, 230);
            } else {
                GuiClaimedChunks.AREA.color.set(80, 80, 80, 230);
            }
            if (borderU) {
                AREA.rect(dx, dy, 12, 1);
            }
            if (borderD) {
                AREA.rect(dx, dy + 12 - 1, 12, 1);
            }
            if (borderL) {
                AREA.rect(dx, dy, 1, 12);
            }
            if (!borderR) continue;
            AREA.rect(dx + 12 - 1, dy, 1, 12);
        }
    }

    public GuiClaimedChunks() {
        this.currentDimName = ServerUtils.getDimensionName((int)Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension()).func_150254_d();
    }

    public void onPostInit() {
        new MessageClaimedChunksRequest(this.startX, this.startZ).sendToServer();
        ChunkSelectorMap.getMap().resetMap(this.startX, this.startZ);
    }

    public int getSelectionMode(MouseButton button) {
        boolean claim = !GuiClaimedChunks.isShiftKeyDown();
        boolean flag = button.isLeft();
        if (flag) {
            return claim ? 0 : 2;
        }
        return claim ? 1 : 3;
    }

    public void onChunksSelected(Collection<ChunkPos> chunks) {
        new MessageClaimedChunksModify(this.startX, this.startZ, this.currentSelectionMode, chunks).sendToServer();
    }

    public void drawArea(Tessellator tessellator, BufferBuilder buffer) {
        AREA.draw(tessellator, buffer);
    }

    public void addCornerButtons(Panel panel) {
        panel.add((Widget)new ButtonSide(panel, I18n.func_135052_a((String)"gui.close", (Object[])new Object[0]), GuiIcons.ACCEPT){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                this.getGui().closeGui();
            }
        });
        panel.add((Widget)new ButtonSide(panel, I18n.func_135052_a((String)"selectServer.refresh", (Object[])new Object[0]), GuiIcons.REFRESH){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new MessageClaimedChunksRequest(GuiClaimedChunks.this.startX, GuiClaimedChunks.this.startZ).sendToServer();
                ChunkSelectorMap.getMap().resetMap(GuiClaimedChunks.this.startX, GuiClaimedChunks.this.startZ);
            }
        });
        if (maxClaimedChunks >= 0) {
            panel.add((Widget)new ButtonSide(panel, I18n.func_135052_a((String)"ftbutilities.lang.chunks.unclaim_all_dim", (Object[])new Object[]{this.currentDimName}), GuiIcons.REMOVE){

                public void onClicked(MouseButton button) {
                    GuiHelper.playClickSound();
                    String s = I18n.func_135052_a((String)"ftbutilities.lang.chunks.unclaim_all_dim_q", (Object[])new Object[]{GuiClaimedChunks.this.currentDimName});
                    GuiClaimedChunks.this.openYesNo(s, "", () -> ClientUtils.execClientCommand((String)("/chunks unclaim_all " + Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension())));
                }
            });
            panel.add((Widget)new ButtonSide(panel, I18n.func_135052_a((String)"ftbutilities.lang.chunks.unclaim_all", (Object[])new Object[0]), GuiIcons.REMOVE){

                public void onClicked(MouseButton button) {
                    GuiHelper.playClickSound();
                    String s = I18n.func_135052_a((String)"ftbutilities.lang.chunks.unclaim_all_q", (Object[])new Object[0]);
                    GuiClaimedChunks.this.openYesNo(s, "", () -> ClientUtils.execClientCommand((String)"/chunks unclaim_all"));
                }
            });
        }
        panel.add((Widget)new ButtonSide(panel, I18n.func_135052_a((String)"gui.info", (Object[])new Object[0]), GuiIcons.INFO){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                this.handleClick("https://github.com/FTBTeam/FTB-Chunks/wiki");
            }
        });
    }

    public void addCornerText(List<String> list, GuiChunkSelectorBase.Corner corner) {
        if (maxClaimedChunks < 0) {
            if (corner == GuiChunkSelectorBase.Corner.BOTTOM_RIGHT) {
                if (maxClaimedChunks == -2) {
                    list.add(TextFormatting.RED + I18n.func_135052_a((String)"ftblib.lang.team.error.no_team", (Object[])new Object[0]));
                } else {
                    list.add(TextFormatting.RED + I18n.func_135052_a((String)"feature_disabled_server", (Object[])new Object[0]));
                }
            }
            return;
        }
        switch (corner) {
            case BOTTOM_RIGHT: {
                list.add(I18n.func_135052_a((String)"ftbutilities.lang.chunks.claimed_count", (Object[])new Object[]{claimedChunks, maxClaimedChunks == Integer.MAX_VALUE ? "\u221e" : Integer.toString(maxClaimedChunks)}));
                list.add(I18n.func_135052_a((String)"ftbutilities.lang.chunks.loaded_count", (Object[])new Object[]{loadedChunks, maxLoadedChunks == Integer.MAX_VALUE ? "\u221e" : Integer.toString(maxLoadedChunks)}));
            }
        }
    }

    public void addButtonText(GuiChunkSelectorBase.MapButton button, List<String> list) {
        ClientClaimedChunks.ChunkData data = chunkData[button.index];
        if (data != null) {
            list.add(data.team.nameComponent.func_150254_d());
            list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"ftbutilities.lang.chunks.claimed_area", (Object[])new Object[0]));
            if (data.isLoaded()) {
                list.add(TextFormatting.RED + I18n.func_135052_a((String)"ftbutilities.lang.chunks.upgrade.loaded", (Object[])new Object[0]));
            }
        } else {
            list.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"ftbutilities.lang.chunks.wilderness", (Object[])new Object[0]));
        }
        if (GuiClaimedChunks.isCtrlKeyDown()) {
            list.add(button.chunkPos.toString());
        }
    }

    static {
        chunkData = new ClientClaimedChunks.ChunkData[225];
        NULL_CHUNK_DATA = new ClientClaimedChunks.ChunkData(new ClientClaimedChunks.Team(0), 0);
        AREA = new CachedVertexData(7, DefaultVertexFormats.field_181706_f);
    }

    private static abstract class ButtonSide
    extends Button {
        public ButtonSide(Panel panel, String text, Icon icon) {
            super(panel, text, icon);
            this.setSize(20, 20);
        }
    }
}

