/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandler;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandlerRegistry;
import org.cyclops.integratedtunnels.api.world.IBlockPlaceHandler;
import org.cyclops.integratedtunnels.api.world.IBlockPlaceHandlerRegistry;
import org.cyclops.integratedtunnels.core.PlayerHelpers;
import org.cyclops.integratedtunnels.core.helper.obfuscation.ObfuscationHelpers;

public class ItemStorageBlockWrapper
implements IIngredientComponentStorage<ItemStack, Integer> {
    private final boolean writeOnly;
    private final WorldServer world;
    private final BlockPos pos;
    private final EnumFacing side;
    private final EnumHand hand;
    private final boolean blockUpdate;
    private final int fortune;
    private final boolean silkTouch;
    private final boolean ignoreReplacable;
    private final boolean breakOnNoDrops;
    private IBlockBreakHandler blockBreakHandler = null;
    private List<ItemStack> cachedDrops = null;

    public ItemStorageBlockWrapper(boolean writeOnly, WorldServer world, BlockPos pos, EnumFacing side, EnumHand hand, boolean blockUpdate, int fortune, boolean silkTouch, boolean ignoreReplacable, boolean breakOnNoDrops) {
        this.writeOnly = writeOnly;
        this.world = world;
        this.pos = pos;
        this.side = side;
        this.hand = hand;
        this.blockUpdate = blockUpdate;
        this.fortune = fortune;
        this.silkTouch = silkTouch;
        this.ignoreReplacable = ignoreReplacable;
        this.breakOnNoDrops = breakOnNoDrops;
    }

    protected void sendBlockUpdate() {
        this.world.func_190524_a(this.pos, Blocks.field_150350_a, this.pos);
    }

    protected IBlockBreakHandler getBlockBreakHandler(IBlockState blockState, World world, BlockPos pos, EntityPlayer player) {
        return ((IBlockBreakHandlerRegistry)IntegratedTunnels._instance.getRegistryManager().getRegistry(IBlockBreakHandlerRegistry.class)).getHandler(blockState, world, pos, player);
    }

    protected void removeBlock(IBlockState blockState, EntityPlayer player) {
        if (this.blockBreakHandler != null) {
            this.blockBreakHandler.breakBlock(blockState, (World)this.world, this.pos, player);
        } else {
            blockState.func_177230_c().removedByPlayer(blockState, (World)this.world, this.pos, player, false);
        }
        if (GeneralConfig.worldInteractionEvents) {
            this.world.func_175718_b(2001, this.pos, Block.func_176210_f((IBlockState)blockState));
        }
        if (this.blockUpdate) {
            this.sendBlockUpdate();
        }
    }

    protected List<ItemStack> getItemStacks() {
        if (this.writeOnly) {
            boolean isDestReplaceable;
            if (!(this.world.func_175623_d(this.pos) || (isDestReplaceable = this.world.func_180495_p(this.pos).func_177230_c().func_176200_f((IBlockAccess)this.world, this.pos)) && this.ignoreReplacable)) {
                IBlockState blockState = this.world.func_180495_p(this.pos);
                return Lists.newArrayList((Object[])new ItemStack[]{BlockHelpers.getItemStackFromBlockState((IBlockState)blockState)});
            }
        } else {
            if (this.cachedDrops != null) {
                return this.cachedDrops;
            }
            if (!this.world.func_175623_d(this.pos)) {
                IBlockState blockState = this.world.func_180495_p(this.pos);
                FakePlayer player = PlayerHelpers.getFakePlayer(this.world);
                PlayerHelpers.setPlayerState((EntityPlayer)player, this.hand, this.pos, 0.0f, 0.0f, 0.0f, this.side, false);
                this.blockBreakHandler = this.getBlockBreakHandler(blockState, (World)this.world, this.pos, (EntityPlayer)player);
                if (this.blockBreakHandler != null) {
                    this.cachedDrops = this.blockBreakHandler.getDrops(blockState, (World)this.world, this.pos, (EntityPlayer)player);
                } else {
                    BlockEvent.BreakEvent blockBreakEvent = new BlockEvent.BreakEvent((World)this.world, this.pos, blockState, (EntityPlayer)player);
                    if (!MinecraftForge.EVENT_BUS.post((Event)blockBreakEvent)) {
                        boolean doSilkTouch = this.silkTouch && blockState.func_177230_c().canSilkHarvest((World)this.world, this.pos, blockState, (EntityPlayer)player);
                        ArrayList drops = doSilkTouch ? Lists.newArrayList((Object[])new ItemStack[]{ObfuscationHelpers.getSilkTouchDrop(blockState)}) : Lists.newArrayList((Iterable)blockState.func_177230_c().getDrops((IBlockAccess)this.world, this.pos, blockState, this.fortune));
                        float dropChance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)this.world, (BlockPos)this.pos, (IBlockState)blockState, (int)this.fortune, (float)1.0f, (boolean)doSilkTouch, (EntityPlayer)player);
                        if (drops.size() == 0) {
                            if (this.breakOnNoDrops) {
                                this.removeBlock(blockState, (EntityPlayer)player);
                            }
                            drops = Lists.newArrayList((Object[])new ItemStack[]{ItemStack.field_190927_a});
                        } else {
                            Iterator it = drops.iterator();
                            while (it.hasNext()) {
                                if (!((ItemStack)it.next()).func_190926_b()) continue;
                                it.remove();
                            }
                        }
                        if (this.world.field_73012_v.nextFloat() <= dropChance) {
                            this.cachedDrops = drops;
                            return this.cachedDrops;
                        }
                    }
                }
            }
        }
        return Lists.newArrayList((Object[])new ItemStack[]{ItemStack.field_190927_a});
    }

    protected IBlockPlaceHandler getBlockPlaceHandler(ItemStack itemStack, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player) {
        return ((IBlockPlaceHandlerRegistry)IntegratedTunnels._instance.getRegistryManager().getRegistry(IBlockPlaceHandlerRegistry.class)).getHandler(itemStack, world, pos, side, hitX, hitY, hitZ, player);
    }

    protected ItemStack setItemStack(ItemStack itemStack, boolean simulate) {
        Item item;
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() == 1 && (item = itemStack.func_77973_b()) instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            FakePlayer player = PlayerHelpers.getFakePlayer(this.world);
            PlayerHelpers.setPlayerState((EntityPlayer)player, this.hand, this.pos, 0.0f, 0.0f, 0.0f, this.side, false);
            IBlockPlaceHandler blockPlaceHandler = this.getBlockPlaceHandler(itemStack, (World)this.world, this.pos, this.side.func_176734_d(), 0.0f, 0.0f, 0.0f, (EntityPlayer)player);
            if (blockPlaceHandler != null) {
                blockPlaceHandler.placeBlock(itemStack, (World)this.world, this.pos, this.side.func_176734_d(), 0.0f, 0.0f, 0.0f, (EntityPlayer)player);
            } else {
                IBlockState blockState = itemBlock.func_179223_d().getStateForPlacement((World)this.world, this.pos, this.side.func_176734_d(), 0.0f, 0.0f, 0.0f, itemStack.func_77960_j(), (EntityLivingBase)player, this.hand);
                if (this.world.func_190527_a(itemBlock.func_179223_d(), this.pos, false, this.side.func_176734_d(), null) && (simulate || itemBlock.placeBlockAt(itemStack, (EntityPlayer)player, (World)this.world, this.pos, this.side.func_176734_d(), 0.0f, 0.0f, 0.0f, blockState))) {
                    if (!simulate) {
                        itemBlock.func_179223_d().func_180633_a((World)this.world, this.pos, blockState, (EntityLivingBase)player, itemStack);
                        if (GeneralConfig.worldInteractionEvents) {
                            SoundType soundtype = this.world.func_180495_p(this.pos).func_177230_c().getSoundType(this.world.func_180495_p(this.pos), (World)this.world, this.pos, (Entity)player);
                            this.world.func_184133_a((EntityPlayer)player, this.pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                        }
                        if (this.blockUpdate) {
                            this.sendBlockUpdate();
                        }
                    }
                    return ItemStack.field_190927_a;
                }
            }
        }
        return itemStack;
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return this.getItemStacks().iterator();
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return new FilteredIngredientCollectionIterator((Iterable)((Object)this), this.getComponent().getMatcher(), (Object)prototype, (Object)matchCondition);
    }

    public long getMaxQuantity() {
        return 1L;
    }

    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        ItemStack itemStack;
        List<ItemStack> itemStacks = this.getItemStacks();
        if (itemStacks.size() > 0 && !(itemStack = itemStacks.get(0)).func_190926_b()) {
            return stack;
        }
        if (stack.func_190926_b()) {
            return stack;
        }
        ItemStack remaining = stack.func_77946_l();
        if (!this.setItemStack(remaining.func_77979_a(1), simulate).func_190926_b()) {
            return stack;
        }
        return remaining;
    }

    protected void postExtract() {
        boolean allEmpty = true;
        for (ItemStack stack : this.getItemStacks()) {
            if (stack.func_190926_b()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            IBlockState blockState = this.world.func_180495_p(this.pos);
            FakePlayer player = PlayerHelpers.getFakePlayer(this.world);
            player.func_184598_c(this.hand);
            this.removeBlock(blockState, (EntityPlayer)player);
        }
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        Integer quantityFlag = (Integer)this.getComponent().getPrimaryQuantifier().getMatchCondition();
        Integer subMatchCondition = (Integer)matcher.withoutCondition((Object)matchCondition, (Object)quantityFlag);
        List<ItemStack> itemStacks = this.getItemStacks();
        if (itemStacks.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ListIterator<ItemStack> it = itemStacks.listIterator();
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (!matcher.matches((Object)prototype, (Object)itemStack, (Object)subMatchCondition) || matcher.hasCondition((Object)matchCondition, (Object)quantityFlag) && itemStack.func_190916_E() < prototype.func_190916_E()) continue;
            itemStack = itemStack.func_77946_l();
            ItemStack ret = itemStack.func_77979_a(Helpers.castSafe((long)prototype.func_190916_E()));
            if (!simulate) {
                if (itemStack.func_190926_b()) {
                    it.remove();
                } else {
                    it.set(itemStack);
                }
            }
            if (!simulate) {
                this.postExtract();
            }
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        List<ItemStack> itemStacks = this.getItemStacks();
        if (itemStacks.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = itemStacks.get(0);
        itemStack = itemStack.func_77946_l();
        ItemStack ret = itemStack.func_77979_a(Helpers.castSafe((long)maxQuantity));
        if (!simulate) {
            if (itemStack.func_190926_b()) {
                itemStacks.remove(0);
            } else {
                itemStacks.set(0, itemStack);
            }
        }
        if (!simulate) {
            this.postExtract();
        }
        return ret;
    }
}

