/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.integratedtunnels.core.ExtendedFakePlayer;
import org.cyclops.integratedtunnels.core.PlayerHelpers;
import org.cyclops.integratedtunnels.core.helper.obfuscation.ObfuscationHelpers;

public class ItemStoragePlayerWrapper
implements IIngredientComponentStorage<ItemStack, Integer> {
    private static final Predicate<Entity> CAN_BE_ATTACKED = Entity::func_70075_an;
    private final ExtendedFakePlayer player;
    private final WorldServer world;
    private final BlockPos pos;
    private final float offsetX;
    private final float offsetY;
    private final float offsetZ;
    private final EnumFacing side;
    private final EnumHand hand;
    private final boolean rightClick;
    private final boolean sneaking;
    private final boolean continuousClick;
    private final int entityIndex;
    private final IIngredientComponentStorage<ItemStack, Integer> playerReturnHandler;

    public ItemStoragePlayerWrapper(@Nullable ExtendedFakePlayer player, WorldServer world, BlockPos pos, double offsetX, double offsetY, double offsetZ, EnumFacing side, EnumHand hand, boolean rightClick, boolean sneaking, boolean continuousClick, int entityIndex, IIngredientComponentStorage<ItemStack, Integer> playerReturnHandler) {
        this.player = player;
        this.world = world;
        this.pos = pos;
        this.continuousClick = continuousClick;
        this.entityIndex = entityIndex;
        this.offsetX = (float)offsetX;
        this.offsetY = (float)offsetY;
        this.offsetZ = (float)offsetZ;
        this.side = side;
        this.hand = hand;
        this.rightClick = rightClick;
        this.sneaking = sneaking;
        this.playerReturnHandler = playerReturnHandler;
    }

    public static void cancelDestroyingBlock(EntityPlayerMP player) {
        player.field_71134_c.func_180238_e();
        ObfuscationHelpers.setDurabilityRemaining(player.field_71134_c, -1);
    }

    protected Entity getEntity(List<Entity> entities) {
        if (this.entityIndex < 0) {
            return entities.get(this.world.field_73012_v.nextInt(entities.size()));
        }
        return entities.get(Math.min(this.entityIndex, entities.size() - 1));
    }

    private void returnPlayerInventory(EntityPlayer player) {
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack.func_190926_b()) continue;
            ItemStack remaining = (ItemStack)this.playerReturnHandler.insert((Object)itemStack, false);
            ItemStackHelpers.spawnItemStackToPlayer((World)this.world, (BlockPos)this.pos, (ItemStack)remaining, (EntityPlayer)player);
            it.remove();
        }
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return Iterators.forArray((Object[])new ItemStack[0]);
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return this.iterator();
    }

    public long getMaxQuantity() {
        return 1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        if (simulate) {
            return ItemStack.field_190927_a;
        }
        if (this.player == null) {
            return stack;
        }
        PlayerHelpers.setPlayerState((EntityPlayer)this.player, this.hand, this.pos, this.offsetX, this.offsetY, this.offsetZ, this.side, this.sneaking);
        PlayerHelpers.setHeldItemSilent((EntityPlayer)this.player, this.hand, stack);
        if (!this.continuousClick) {
            ItemStoragePlayerWrapper.cancelDestroyingBlock((EntityPlayerMP)this.player);
        }
        if (this.rightClick) {
            List entities;
            if (!stack.func_190926_b()) {
                EnumActionResult actionResult = stack.func_77973_b().onItemUseFirst((EntityPlayer)this.player, (World)this.world, this.pos, this.side, this.offsetX, this.offsetY, this.offsetZ, this.hand);
                if (actionResult == EnumActionResult.FAIL) {
                    return stack;
                }
                if (actionResult == EnumActionResult.SUCCESS) {
                    this.returnPlayerInventory((EntityPlayer)this.player);
                    return ItemStack.field_190927_a;
                }
            }
            IBlockState blockState = this.world.func_180495_p(this.pos);
            if ((!this.player.func_70093_af() || stack.func_190926_b()) && blockState.func_177230_c().func_180639_a((World)this.world, this.pos, blockState, (EntityPlayer)this.player, this.hand, this.side, this.offsetX, this.offsetY, this.offsetZ)) {
                this.returnPlayerInventory((EntityPlayer)this.player);
                return ItemStack.field_190927_a;
            }
            if (!stack.func_190926_b()) {
                EnumActionResult cancelResult = ForgeHooks.onItemRightClick((EntityPlayer)this.player, (EnumHand)this.hand);
                if (cancelResult != null) {
                    if (cancelResult == EnumActionResult.FAIL) {
                        return stack;
                    }
                    if (cancelResult == EnumActionResult.SUCCESS) {
                        this.returnPlayerInventory((EntityPlayer)this.player);
                        return ItemStack.field_190927_a;
                    }
                } else {
                    ItemStack copyBeforeUse = stack.func_77946_l();
                    ActionResult actionresult = stack.func_77957_a((World)this.world, (EntityPlayer)this.player, this.hand);
                    if (actionresult.func_188397_a() == EnumActionResult.FAIL) {
                        return stack;
                    }
                    if (((ItemStack)actionresult.func_188398_b()).func_190926_b()) {
                        PlayerHelpers.setHeldItemSilent((EntityPlayer)this.player, this.hand, ItemStack.field_190927_a);
                        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this.player, (ItemStack)copyBeforeUse, (EnumHand)this.hand);
                    } else {
                        PlayerHelpers.setHeldItemSilent((EntityPlayer)this.player, this.hand, (ItemStack)actionresult.func_188398_b());
                    }
                    if (actionresult.func_188397_a() == EnumActionResult.SUCCESS) {
                        if (this.player.func_184587_cr()) {
                            this.player.updateActiveHandSimulated();
                            this.player.func_184597_cx();
                        }
                        this.returnPlayerInventory((EntityPlayer)this.player);
                        return ItemStack.field_190927_a;
                    }
                }
            }
            if (!stack.func_190926_b()) {
                BlockPos targetPos = this.pos;
                int reachDistance = MathHelper.func_76125_a((int)((int)this.player.field_71134_c.getBlockReachDistance()), (int)0, (int)10);
                int i = 0;
                while (i++ < reachDistance && this.world.func_175623_d(targetPos)) {
                    targetPos = targetPos.func_177972_a(this.side.func_176734_d());
                }
                EnumActionResult actionResult = stack.func_77973_b().func_180614_a((EntityPlayer)this.player, (World)this.world, targetPos, this.hand, this.side, this.offsetX, this.offsetY, this.offsetZ);
                if (actionResult == EnumActionResult.FAIL) {
                    return stack;
                }
                if (actionResult == EnumActionResult.SUCCESS) {
                    this.returnPlayerInventory((EntityPlayer)this.player);
                    return ItemStack.field_190927_a;
                }
            }
            if ((entities = this.world.func_72872_a(Entity.class, new AxisAlignedBB(this.pos))).size() <= 0) return stack;
            Entity entity = this.getEntity(entities);
            EnumActionResult actionResult = this.player.func_190775_a(entity, this.hand);
            if (actionResult == EnumActionResult.FAIL) {
                return stack;
            }
            if (actionResult != EnumActionResult.SUCCESS) return stack;
            this.returnPlayerInventory((EntityPlayer)this.player);
            return ItemStack.field_190927_a;
        }
        if (!this.world.func_175623_d(this.pos)) {
            int durabilityRemaining = ObfuscationHelpers.getDurabilityRemaining(this.player.field_71134_c);
            if (durabilityRemaining < 0) {
                this.player.field_71134_c.func_180784_a(this.pos, this.side);
            } else if (durabilityRemaining >= 9) {
                this.player.field_71134_c.func_180237_b(this.pos);
                ItemStoragePlayerWrapper.cancelDestroyingBlock((EntityPlayerMP)this.player);
            } else {
                this.player.field_71134_c.func_73075_a();
            }
            this.returnPlayerInventory((EntityPlayer)this.player);
            return ItemStack.field_190927_a;
        }
        ItemStoragePlayerWrapper.cancelDestroyingBlock((EntityPlayerMP)this.player);
        List entities = this.world.func_175647_a(Entity.class, new AxisAlignedBB(this.pos), CAN_BE_ATTACKED::test);
        if (entities.size() <= 0) return stack;
        Entity entity = this.getEntity(entities);
        this.player.func_71059_n(entity);
        this.returnPlayerInventory((EntityPlayer)this.player);
        return ItemStack.field_190927_a;
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        return ItemStack.field_190927_a;
    }
}

