/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model.parsing;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.model.IModelParser;
import team.chisel.ctm.client.model.parsing.ModelParserV1;

public enum ModelLoaderCTM implements ICustomModelLoader
{
    INSTANCE;

    private static final Map<Integer, IModelParser> parserVersions;
    private IResourceManager manager;
    private Map<ResourceLocation, IModelCTM> loadedModels = Maps.newHashMap();
    private LoadingCache<ResourceLocation, JsonElement> jsonCache = CacheBuilder.newBuilder().maximumSize(128L).build((CacheLoader)new CacheLoader<ResourceLocation, JsonElement>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public JsonElement load(ResourceLocation modelLocation) throws Exception {
            String path = modelLocation.func_110623_a() + ".json";
            if (!path.startsWith("models/")) {
                path = "models/" + path;
            }
            ResourceLocation absolute = new ResourceLocation(modelLocation.func_110624_b(), path);
            try (IResource resource = ModelLoaderCTM.this.manager.func_110536_a(absolute);
                 InputStream resourceInputStream = resource.func_110527_b();
                 InputStreamReader resourceInputStreamReader = new InputStreamReader(resourceInputStream);){
                JsonElement ele = new JsonParser().parse((Reader)resourceInputStreamReader);
                if (ele == null) return JsonNull.INSTANCE;
                JsonElement jsonElement = ele;
                return jsonElement;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return JsonNull.INSTANCE;
        }
    });
    public static final Set<ResourceLocation> parsedLocations;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void afterModelBaking(ModelBakeEvent event) {
        this.jsonCache.invalidateAll();
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.jsonCache.invalidateAll();
        this.loadedModels.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        JsonElement json;
        if (modelLocation instanceof ModelResourceLocation) {
            modelLocation = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        }
        return (json = (JsonElement)this.jsonCache.getUnchecked((Object)modelLocation)).isJsonObject() && json.getAsJsonObject().has("ctm_version");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        this.loadedModels.computeIfAbsent(modelLocation, res -> this.loadFromFile((ResourceLocation)res, true));
        IModelCTM model = this.loadedModels.get(modelLocation);
        if (model != null) {
            model.load();
        }
        return model;
    }

    private IModelCTM loadFromFile(ResourceLocation res, boolean forLoad) {
        JsonObject json;
        IModelParser parser;
        if (forLoad) {
            parsedLocations.add(new ResourceLocation(res.func_110624_b(), res.func_110623_a().replace("models/", "")));
        }
        if ((parser = parserVersions.get((json = ((JsonElement)this.jsonCache.getUnchecked((Object)res)).getAsJsonObject()).get("ctm_version").getAsInt())) == null) {
            throw new IllegalArgumentException("Invalid \"ctm_version\" in model " + res);
        }
        return parser.fromJson(res, json);
    }

    static {
        parserVersions = ImmutableMap.of((Object)1, (Object)new ModelParserV1());
        parsedLocations = new HashSet<ResourceLocation>();
    }
}

