/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import javax.annotation.Nullable;
import net.daveyx0.multimob.entity.IMultiMobLava;
import net.daveyx0.primitivemobs.core.PrimitiveMobsLootTables;
import net.daveyx0.primitivemobs.core.PrimitiveMobsSoundEvents;
import net.daveyx0.primitivemobs.entity.item.EntityFlameSpit;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFlameSpewer
extends EntityMob
implements IRangedAttackMob,
IMultiMobLava {
    private static final DataParameter<Byte> ON_FIRE = EntityDataManager.func_187226_a(EntityFlameSpewer.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> IN_DANGER = EntityDataManager.func_187226_a(EntityFlameSpewer.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> ATTACK_TIME = EntityDataManager.func_187226_a(EntityFlameSpewer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ATTACK_SIGNAL = EntityDataManager.func_187226_a(EntityFlameSpewer.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityFlameSpewer(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.setOnFire(false);
        this.setInDanger(false);
        this.setAttackTime(10);
        this.setAttackSignal(0.0f);
        this.func_70105_a(1.0f, 1.25f);
        this.func_184644_a(PathNodeType.LAVA, 10.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIGoToLava(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIFlameSpewAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ON_FIRE, (Object)0);
        this.field_70180_af.func_187214_a(IN_DANGER, (Object)0);
        this.func_184212_Q().func_187214_a(ATTACK_TIME, (Object)0);
        this.func_184212_Q().func_187214_a(ATTACK_SIGNAL, (Object)Float.valueOf(0.0f));
    }

    protected SoundEvent func_184639_G() {
        return PrimitiveMobsSoundEvents.ENTITY_FLAMESPEWER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.getAttackTime() < 10 || this.getAttackSignal() > 0.0f;
    }

    public void setAttackTime(int time) {
        this.func_184212_Q().func_187227_b(ATTACK_TIME, (Object)time);
    }

    public void setAttackSignal(float signal) {
        this.func_184212_Q().func_187227_b(ATTACK_SIGNAL, (Object)Float.valueOf(signal));
    }

    public int getAttackTime() {
        return (Integer)this.func_184212_Q().func_187225_a(ATTACK_TIME);
    }

    public float getAttackSignal() {
        return ((Float)this.func_184212_Q().func_187225_a(ATTACK_SIGNAL)).floatValue();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_180799_ab() || this.func_70090_H()) {
            this.field_70181_x = !this.func_130014_f_().func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v)) ? 0.1 : 0.0;
            if (this.func_70090_H() && this.field_70173_aa % 15 == 0) {
                this.func_70097_a(DamageSource.field_76369_e, 4.0f);
            }
        } else if (this.field_70173_aa % 25 == 0) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            this.func_70664_aZ();
            this.func_191989_p(1.0f);
        }
    }

    @Nullable
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190926_b()) {
            return null;
        }
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v, stack);
        entityitem.func_174869_p();
        for (int i = 0; i < 50; ++i) {
            Vec3d vec = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)10, (int)7);
            if (vec == null) continue;
            entityitem.field_70159_w = (vec.field_72450_a - entityitem.field_70165_t) / 18.0;
            entityitem.field_70181_x = (vec.field_72448_b - entityitem.field_70163_u) / 18.0 + 0.5;
            entityitem.field_70179_y = (vec.field_72449_c - entityitem.field_70161_v) / 18.0;
            break;
        }
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("AttackTime", this.getAttackTime());
        compound.func_74776_a("AttackSignal", this.getAttackSignal());
        compound.func_74757_a("onFire", this.isOnFire());
        compound.func_74757_a("inDanger", this.isInDanger());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setAttackTime(compound.func_74762_e("AttackTime"));
        this.setAttackSignal(compound.func_74760_g("AttackSignal"));
        this.setOnFire(compound.func_74767_n("onFire"));
        this.setInDanger(compound.func_74767_n("inDanger"));
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrimitiveMobsLootTables.ENTITIES_FLAMESPEWER;
    }

    public boolean isOnFire() {
        return ((Byte)this.field_70180_af.func_187225_a(ON_FIRE) & 1) != 0;
    }

    public void setOnFire(boolean onFire) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ON_FIRE);
        b0 = onFire ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ON_FIRE, (Object)b0);
    }

    public boolean isInDanger() {
        return ((Byte)this.field_70180_af.func_187225_a(IN_DANGER) & 1) != 0;
    }

    public void setInDanger(boolean onFire) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(IN_DANGER);
        b0 = onFire ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(IN_DANGER, (Object)b0);
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70058_J() {
        return this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public boolean func_70601_bi() {
        return this.field_70163_u < 64.0;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (type == EnumCreatureType.MONSTER) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    static class AIGoToLava
    extends EntityAIMoveToBlock {
        private final EntityFlameSpewer spewer;

        public AIGoToLava(EntityFlameSpewer spewer) {
            super((EntityCreature)spewer, (double)0.7f, 25);
            this.spewer = spewer;
        }

        public boolean func_75250_a() {
            return !this.spewer.func_180799_ab() && super.func_75250_a();
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.spewer.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, (float)this.spewer.func_70646_bf());
            if (this.func_179487_f()) {
                this.field_179496_a = 10;
            }
        }

        protected boolean func_179488_a(World worldIn, BlockPos pos) {
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            BlockPos tempPos = pos;
            return block == Blocks.field_150353_l && worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150353_l && worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150353_l && worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150353_l && worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150353_l;
        }
    }

    static class AIFlameSpewAttack
    extends EntityAIBase {
        private final EntityFlameSpewer spewer;
        private int attackStep;
        private int attackTime;
        private float attackSignal;
        private boolean performingAttack;
        private boolean hasSeenPlayerThisAttack;

        public AIFlameSpewAttack(EntityFlameSpewer spewerIn) {
            this.spewer = spewerIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.spewer.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 10;
            this.attackSignal = 0.0f;
            this.attackTime = 100;
            this.performingAttack = false;
            this.hasSeenPlayerThisAttack = false;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75251_c() {
            this.spewer.setOnFire(false);
            this.attackSignal = 0.0f;
            this.attackStep = 10;
            this.attackTime = 100;
            this.spewer.setAttackTime(this.attackStep);
            this.spewer.setAttackSignal(this.attackSignal);
            this.spewer.setOnFire(false);
            this.spewer.setInDanger(false);
            this.performingAttack = false;
        }

        public void func_75246_d() {
            double d0;
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.spewer.func_70638_az();
            if (!this.performingAttack && this.spewer.func_180799_ab() && this.spewer.func_70685_l((Entity)entitylivingbase)) {
                if (this.attackTime <= 50) {
                    this.spewer.setOnFire(false);
                    this.hasSeenPlayerThisAttack = false;
                }
                if (!this.spewer.isOnFire()) {
                    if (this.spewer.func_70685_l((Entity)entitylivingbase)) {
                        this.hasSeenPlayerThisAttack = true;
                    }
                    this.attackStep = this.attackTime * 2 / 10;
                    if (this.attackTime <= 3) {
                        this.attackSignal += 0.05f;
                    }
                }
            }
            if ((d0 = this.spewer.func_70068_e((Entity)entitylivingbase)) < 5.0 && !this.spewer.func_180799_ab()) {
                this.spewer.setInDanger(true);
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.spewer.func_70652_k((Entity)entitylivingbase);
                }
            } else if (d0 < this.getFollowDistance() / 2.0 * (this.getFollowDistance() / 2.0) && this.spewer.func_180799_ab()) {
                this.spewer.setInDanger(false);
                double d1 = entitylivingbase.field_70165_t - this.spewer.field_70165_t;
                double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f + 0.25f) - (this.spewer.field_70163_u + (double)(this.spewer.field_70131_O / 2.0f));
                double d3 = entitylivingbase.field_70161_v - this.spewer.field_70161_v;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    this.attackSignal -= 0.05f;
                    if (this.attackStep == 1) {
                        this.attackTime = 30;
                        this.spewer.setOnFire(true);
                        this.performingAttack = true;
                    } else if (this.attackStep <= 10) {
                        this.attackTime = 3;
                        this.spewer.setOnFire(true);
                        this.performingAttack = true;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 10;
                        this.performingAttack = false;
                    }
                    if (this.attackStep > 1 && this.hasSeenPlayerThisAttack) {
                        float f = MathHelper.func_76129_c((float)(MathHelper.func_76133_a((double)d0) * 0.1f));
                        this.spewer.field_70170_p.func_180498_a((EntityPlayer)null, 1018, new BlockPos((int)this.spewer.field_70165_t, (int)this.spewer.field_70163_u, (int)this.spewer.field_70161_v), 0);
                        for (int i = 0; i < 1; ++i) {
                            EntityFlameSpit entitysmallfireball = new EntityFlameSpit(this.spewer.field_70170_p, (EntityLivingBase)this.spewer, d1 + this.spewer.func_70681_au().nextGaussian() * (double)0.02f * (double)f, d2 - this.spewer.func_70681_au().nextGaussian() * (double)0.02f * (double)f, d3 + this.spewer.func_70681_au().nextGaussian() * (double)0.02f * (double)f);
                            entitysmallfireball.field_70163_u = this.spewer.field_70163_u + (double)(this.spewer.field_70131_O / 2.0f) - 0.5;
                            this.spewer.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                        }
                    }
                }
            } else if (this.spewer.func_180799_ab() && this.spewer.func_70685_l((Entity)entitylivingbase)) {
                double d1 = entitylivingbase.field_70165_t - this.spewer.field_70165_t;
                double d3 = entitylivingbase.field_70161_v - this.spewer.field_70161_v;
                this.spewer.field_70159_w = d1 * 0.01;
                this.spewer.field_70179_y = d3 * 0.01;
                this.spewer.setInDanger(false);
                this.spewer.setOnFire(false);
            } else {
                this.spewer.func_70661_as().func_75499_g();
                this.spewer.setInDanger(false);
                this.spewer.setOnFire(false);
            }
            this.spewer.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
            if (this.attackSignal < 0.0f) {
                this.attackSignal = 0.0f;
            } else if ((double)this.attackSignal > 0.4) {
                this.attackSignal = 0.4f;
            }
            this.spewer.setAttackSignal(this.attackSignal);
            this.spewer.setAttackTime(this.attackStep);
            super.func_75246_d();
        }

        private double getFollowDistance() {
            IAttributeInstance iattributeinstance = this.spewer.func_110148_a(SharedMonsterAttributes.field_111265_b);
            return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
        }
    }
}

