/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.passive;

import javax.annotation.Nullable;
import net.daveyx0.multimob.entity.IMultiMobPassive;
import net.daveyx0.multimob.util.ColorUtil;
import net.daveyx0.primitivemobs.core.PrimitiveMobsLootTables;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityChameleon
extends EntityAnimal
implements IMultiMobPassive {
    private float R;
    private float G;
    private float B;
    private float NewR;
    private float NewG;
    private float NewB;
    private int colorSpeed = 4;
    private IBlockState currentState;
    private int currentMultiplier;

    public EntityChameleon(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.5f);
        this.setSkinRGB(new int[]{0, 125, 25});
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        int prio = 0;
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityChameleon(this.func_130014_f_());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrimitiveMobsLootTables.ENTITIES_CHAMELEON;
    }

    public void func_70071_h_() {
        if (this.func_70090_H() && !this.field_70123_F) {
            this.field_70181_x = 0.02;
        }
        if (this.func_130014_f_().field_72995_K) {
            this.changeColor((Entity)this);
        }
        if (this.R != this.NewR || this.G != this.NewG || this.B != this.NewB) {
            for (int i = 0; i < this.colorSpeed; ++i) {
                if (this.R > this.NewR) {
                    this.R -= 1.0f;
                } else if (this.R < this.NewR) {
                    this.R += 1.0f;
                }
                if (this.G > this.NewG) {
                    this.G -= 1.0f;
                } else if (this.G < this.NewG) {
                    this.G += 1.0f;
                }
                if (this.B > this.NewB) {
                    this.B -= 1.0f;
                    continue;
                }
                if (!(this.B < this.NewB)) continue;
                this.B += 1.0f;
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151071_bq;
    }

    public float[] getSkinRGB() {
        return new float[]{this.R, this.G, this.B};
    }

    public void setSkinRGB(int[] RGB) {
        this.R = RGB[0];
        this.G = RGB[1];
        this.B = RGB[2];
    }

    public float[] getNewSkinRGB() {
        return new float[]{this.NewR, this.NewG, this.NewB};
    }

    public void setNewSkinRGB(int[] RGB) {
        this.NewR = RGB[0];
        this.NewG = RGB[1];
        this.NewB = RGB[2];
    }

    public void changeColor(Entity entity) {
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        if (entity.func_130014_f_().func_180495_p(new BlockPos(i, j, k)).func_177230_c() == Blocks.field_150350_a) {
            j = MathHelper.func_76128_c((double)(entity.func_174813_aQ().field_72338_b - 0.1));
        }
        BlockPos pos = new BlockPos(i, j, k);
        IBlockState state = entity.func_130014_f_().func_180495_p(pos);
        int colorMultiplier = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)this.func_130014_f_(), pos, 0);
        if (state.func_177230_c() != Blocks.field_150350_a && (this.currentState != state || this.currentMultiplier != colorMultiplier)) {
            this.currentState = state;
            this.currentMultiplier = colorMultiplier;
            int[] newColor = ColorUtil.getBlockStateColor((IBlockState)state, (BlockPos)pos, (World)this.func_130014_f_(), (boolean)true);
            if (newColor != null) {
                if (ColorUtil.isColorInvalid((int[])newColor)) {
                    newColor = new int[]{63, 118, 42, 255};
                }
                this.setNewSkinRGB(newColor);
            }
        }
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (type == EnumCreatureType.CREATURE) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }
}

