/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.passive;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.daveyx0.multimob.entity.IMultiMobPassive;
import net.daveyx0.multimob.entity.ai.EntityAITemptItemStack;
import net.daveyx0.primitivemobs.core.PrimitiveMobsVillagerProfessions;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.IShearable;

public class EntitySheepman
extends EntityVillager
implements IShearable,
IMultiMobPassive {
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(EntitySheepman.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> CAN_DESPAWN = EntityDataManager.func_187226_a(EntitySheepman.class, (DataSerializer)DataSerializers.field_187198_h);
    private final InventoryCrafting inventoryCrafting = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }, 2, 1);
    private int sheepTimer;

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAITemptItemStack((EntityCreature)this, 1.1, false, (Set)Sets.newHashSet((Object[])new ItemStack[]{new ItemStack(Items.field_151043_k)})));
    }

    public EntitySheepman(World worldIn) {
        super(worldIn);
        this.inventoryCrafting.func_70299_a(0, new ItemStack(Items.field_151100_aR));
        this.inventoryCrafting.func_70299_a(1, new ItemStack(Items.field_151100_aR));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(CAN_DESPAWN, (Object)true);
    }

    public void setCanDespawn(boolean b) {
        this.field_70180_af.func_187227_b(CAN_DESPAWN, (Object)b);
    }

    public IEntityLivingData func_190672_a(DifficultyInstance p_190672_1_, @Nullable IEntityLivingData p_190672_2_, boolean p_190672_3_) {
        int profession = this.field_70146_Z.nextInt(3);
        switch (profession) {
            case 0: {
                this.setProfession(PrimitiveMobsVillagerProfessions.SHEEPMAN_PROFESSION_SCAVENGER);
                this.setFleeceColor(EnumDyeColor.RED);
                break;
            }
            case 1: {
                this.setProfession(PrimitiveMobsVillagerProfessions.SHEEPMAN_PROFESSION_ALCHEMIST);
                this.setFleeceColor(EnumDyeColor.ORANGE);
                break;
            }
            case 2: {
                this.setProfession(PrimitiveMobsVillagerProfessions.SHEEPMAN_PROFESSION_THIEF);
                this.setFleeceColor(EnumDyeColor.BLACK);
            }
        }
        return super.func_190672_a(p_190672_1_, p_190672_2_, false);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        return livingdata;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    protected float func_70599_aP() {
        return 1.1111f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.getSheared()) {
            return LootTableList.field_186403_K;
        }
        switch (this.getFleeceColor()) {
            default: {
                return LootTableList.field_186404_L;
            }
            case ORANGE: {
                return LootTableList.field_186405_M;
            }
            case MAGENTA: {
                return LootTableList.field_186406_N;
            }
            case LIGHT_BLUE: {
                return LootTableList.field_186407_O;
            }
            case YELLOW: {
                return LootTableList.field_186408_P;
            }
            case LIME: {
                return LootTableList.field_186409_Q;
            }
            case PINK: {
                return LootTableList.field_186410_R;
            }
            case GRAY: {
                return LootTableList.field_186411_S;
            }
            case SILVER: {
                return LootTableList.field_186412_T;
            }
            case CYAN: {
                return LootTableList.field_186413_U;
            }
            case PURPLE: {
                return LootTableList.field_186414_V;
            }
            case BLUE: {
                return LootTableList.field_186415_W;
            }
            case BROWN: {
                return LootTableList.field_186416_X;
            }
            case GREEN: {
                return LootTableList.field_186417_Y;
            }
            case RED: {
                return LootTableList.field_186418_Z;
            }
            case BLACK: 
        }
        return LootTableList.field_186376_aa;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150340_R);
        if (flag && ((Boolean)this.field_70180_af.func_187225_a(CAN_DESPAWN)).booleanValue()) {
            this.consumeItemFromStack(player, itemstack);
            this.setCanDespawn(false);
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151097_aZ && !this.getSheared() && !this.func_70631_g_()) {
            if (!this.field_70170_p.field_72995_K) {
                this.setSheared(true);
                int i = 1 + this.field_70146_Z.nextInt(3);
                for (int j = 0; j < i; ++j) {
                    EntityItem entityitem = this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getFleeceColor().func_176765_a()), 1.0f);
                    entityitem.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
                    entityitem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                    entityitem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                }
            }
            itemstack.func_77972_a(1, (EntityLivingBase)player);
            this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void consumeItemFromStack(EntityPlayer player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Sheared", this.getSheared());
        compound.func_74774_a("Color", (byte)this.getFleeceColor().func_176765_a());
        compound.func_74757_a("canDespawn", ((Boolean)this.field_70180_af.func_187225_a(CAN_DESPAWN)).booleanValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSheared(compound.func_74767_n("Sheared"));
        this.setFleeceColor(EnumDyeColor.func_176764_b((int)compound.func_74771_c("Color")));
        this.setCanDespawn(compound.func_74767_n("canDespawn"));
    }

    public EnumDyeColor getFleeceColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0xF));
    }

    public void setFleeceColor(EnumDyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.func_176765_a() & 0xF)));
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (sheared) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public EntitySheepman createChild(EntityAgeable ageable) {
        EntitySheepman entitysheep = (EntitySheepman)ageable;
        EntitySheepman entitysheep1 = new EntitySheepman(this.field_70170_p);
        return entitysheep1;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getFleeceColor().func_176765_a()));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    private EnumDyeColor getDyeColorMixFromParents(EntitySheepman father, EntitySheepman mother) {
        int i = father.getFleeceColor().func_176767_b();
        int j = mother.getFleeceColor().func_176767_b();
        this.inventoryCrafting.func_70301_a(0).func_77964_b(i);
        this.inventoryCrafting.func_70301_a(1).func_77964_b(j);
        ItemStack itemstack = CraftingManager.func_82787_a((InventoryCrafting)this.inventoryCrafting, (World)father.field_70170_p);
        int k = itemstack.func_77973_b() == Items.field_151100_aR ? itemstack.func_77960_j() : (this.field_70170_p.field_73012_v.nextBoolean() ? i : j);
        return EnumDyeColor.func_176766_a((int)k);
    }

    protected boolean func_70692_ba() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_DESPAWN);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            EntitySheep sheep = new EntitySheep(this.field_70170_p);
            sheep.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            sheep.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)sheep)), (IEntityLivingData)null);
            sheep.func_94061_f(this.func_175446_cd());
            sheep.func_175512_b(this.getFleeceColor());
            if (this.func_145818_k_()) {
                sheep.func_96094_a(this.func_95999_t());
                sheep.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)sheep);
            this.func_70106_y();
        }
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return super.isCreatureType(type, forSpawnCount);
    }
}

