/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.client;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.poopycoders.improvedbackpacks.ImprovedBackpacks;
import ru.poopycoders.improvedbackpacks.items.ItemBackpack;
import ru.poopycoders.improvedbackpacks.items.ItemEnderBackpack;
import ru.poopycoders.improvedbackpacks.proxy.ClientProxy;

@SideOnly(value=Side.CLIENT)
public class LayerBackpack
implements LayerRenderer<EntityPlayer> {
    private RenderPlayer renderPlayer;

    public LayerBackpack(RenderPlayer renderPlayer) {
        this.renderPlayer = renderPlayer;
    }

    public void doRenderLayer(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (!(chest.func_77973_b() instanceof ItemBackpack) && !(chest.func_77973_b() instanceof ItemEnderBackpack)) {
            chest = null;
        }
        ItemStack bauble = null;
        if (ImprovedBackpacks.proxy.isBaublesHere() && !((bauble = BaublesApi.getBaublesHandler(player).getStackInSlot(BaubleType.BODY.getValidSlots()[0])).func_77973_b() instanceof ItemBackpack) && !(bauble.func_77973_b() instanceof ItemEnderBackpack)) {
            bauble = null;
        }
        if (chest != null || bauble != null) {
            GlStateManager.func_179094_E();
            float swing = player.func_70678_g(partialTicks);
            float swingAngle = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swing) * ((float)Math.PI * 2))) * 0.2f;
            if (player.field_184622_au == EnumHand.OFF_HAND ^ player.func_184591_cq() == EnumHandSide.LEFT) {
                swingAngle *= -1.0f;
            }
            if (swingAngle != 0.0f) {
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(swingAngle)), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                GlStateManager.func_179114_b((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            GlStateManager.func_179137_b((double)((double)scale * 8.0), (double)0.0, (double)0.0);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-1.0, (double)-0.88, (double)-0.78);
            this.renderBackpack(chest != null ? chest : bauble, 10.0f - headPitch);
            GlStateManager.func_179121_F();
            if (chest != null && bauble != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)-0.95, (double)-0.78);
                this.renderBackpack(bauble, headPitch - 10.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_177142_b() {
        return false;
    }

    private void renderBackpack(ItemStack stack, float headPitch) {
        IBakedModel baseModel;
        boolean ender = stack.func_77973_b() instanceof ItemEnderBackpack;
        int color = ender ? -1 : ItemBackpack.getColor0(stack);
        BlockModelRenderer renderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        IBakedModel iBakedModel = baseModel = ender ? ClientProxy.ENDER_BACKPACK_MODEL : ClientProxy.BACKPACK_MODEL;
        if (this.isRenderingInGUI()) {
            GlStateManager.func_179140_f();
            renderer.func_178262_a(baseModel, this.getBrightnessFromPitch(headPitch), r, g, b);
        } else {
            renderer.func_178262_a(baseModel, 1.0f, r, g, b);
        }
    }

    private boolean isRenderingInGUI() {
        return !Minecraft.func_71410_x().func_175598_ae().func_178627_a();
    }

    private float getBrightnessFromPitch(float headPitch) {
        return MathHelper.func_76131_a((float)(-headPitch % 90.0f), (float)-30.0f, (float)30.0f) / 60.0f / 2.0f + 0.75f;
    }
}

