/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.init;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import ru.poopycoders.improvedbackpacks.init.ModConfig;
import ru.poopycoders.improvedbackpacks.init.ModItems;
import ru.poopycoders.improvedbackpacks.init.recipes.RecipeBackpackDye;
import ru.poopycoders.improvedbackpacks.init.recipes.RecipeBackpackUpgrade;

public class ModRecipes {
    public static void init() {
        ModRecipes.shaped(ModItems.BOUND_LEATHER, "SLS", Character.valueOf('S'), "string", Character.valueOf('L'), "leather");
        ModRecipes.smelting(ModItems.BOUND_LEATHER, ModItems.TANNED_LEATHER, 3.0f);
        ModRecipes.shaped("blank_upgrade_1", ModItems.BLANK_UPGRADE, " T ", "SPS", " T ", Character.valueOf('T'), ModItems.TANNED_LEATHER, Character.valueOf('S'), "stickWood", Character.valueOf('P'), "plankWood");
        ModRecipes.shaped("blank_upgrade_2", ModItems.BLANK_UPGRADE, " S ", "TPT", " S ", Character.valueOf('T'), ModItems.TANNED_LEATHER, Character.valueOf('S'), "stickWood", Character.valueOf('P'), "plankWood");
        int maxTier = Math.min(5, ModConfig.maxBackpackTier);
        switch (maxTier) {
            case 5: {
                ModRecipes.shaped(ModRecipes.data(ModItems.UPGRADE, 4), " T ", "MBM", " M ", Character.valueOf('T'), ModItems.TANNED_LEATHER, Character.valueOf('M'), "gemDiamond", Character.valueOf('B'), ModItems.BLANK_UPGRADE);
            }
            case 4: {
                ModRecipes.shaped(ModRecipes.data(ModItems.UPGRADE, 3), " T ", "MBM", " M ", Character.valueOf('T'), ModItems.TANNED_LEATHER, Character.valueOf('M'), "ingotGold", Character.valueOf('B'), ModItems.BLANK_UPGRADE);
            }
            case 3: {
                ModRecipes.shaped(ModRecipes.data(ModItems.UPGRADE, 2), " T ", "MBM", " M ", Character.valueOf('T'), ModItems.TANNED_LEATHER, Character.valueOf('M'), "ingotIron", Character.valueOf('B'), ModItems.BLANK_UPGRADE);
            }
            case 2: {
                ModRecipes.shaped(ModRecipes.data(ModItems.UPGRADE, 1), " T ", "MBM", " M ", Character.valueOf('T'), ModItems.TANNED_LEATHER, Character.valueOf('M'), "stone", Character.valueOf('B'), ModItems.BLANK_UPGRADE);
            }
            case 1: {
                ModRecipes.shaped(ModItems.UPGRADE, " T ", "MBM", " M ", Character.valueOf('T'), ModItems.TANNED_LEATHER, Character.valueOf('M'), "logWood", Character.valueOf('B'), ModItems.BLANK_UPGRADE);
            }
        }
        ModRecipes.shaped((Item)ModItems.BACKPACK, "STS", "TCT", "STS", Character.valueOf('S'), "string", Character.valueOf('C'), "chestWood", Character.valueOf('T'), ModItems.TANNED_LEATHER);
        if (ModConfig.enderBackpackEnabled) {
            ModRecipes.shaped((Item)ModItems.ENDER_BACKPACK, "STS", "TCT", "STS", Character.valueOf('S'), "string", Character.valueOf('C'), "chestEnder", Character.valueOf('T'), ModItems.TANNED_LEATHER);
        }
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ForgeRegistries.RECIPES.register(new RecipeBackpackDye(color).setRegistryName(new ResourceLocation("improvedbackpacks", "backpack_dyeing_" + color.func_176610_l())));
        }
        ForgeRegistries.RECIPES.register(new RecipeBackpackUpgrade().setRegistryName(new ResourceLocation("improvedbackpacks", "backpack_upgrading")));
    }

    private static ItemStack data(Item item, int data) {
        return new ItemStack(item, 1, data);
    }

    private static ItemStack data(Block block, int data) {
        return new ItemStack(block, 1, data);
    }

    private static ItemStack stack(Item item) {
        return new ItemStack(item, 1, 0);
    }

    private static Object[] amount(Item item, int amount) {
        Object[] itemStacks = new ItemStack[amount];
        Arrays.fill(itemStacks, new ItemStack(item));
        return itemStacks;
    }

    private static Object[] amount(Block block, int amount) {
        Object[] itemStacks = new ItemStack[amount];
        Arrays.fill(itemStacks, new ItemStack(block));
        return itemStacks;
    }

    private static Ingredient[] amountData(Item item, int amount, int data) {
        Object[] ingredients = new Ingredient[amount];
        Arrays.fill(ingredients, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(item, 1, data)}));
        return ingredients;
    }

    private static Ingredient[] amountData(Block block, int amount, int data) {
        Object[] ingredients = new Ingredient[amount];
        Arrays.fill(ingredients, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(block, 1, data)}));
        return ingredients;
    }

    private static void shaped(Item output, Object ... params) {
        ModRecipes.shaped(output.func_77658_a(), output, params);
    }

    private static void shaped(Block output, Object ... params) {
        ModRecipes.shaped(output.func_149739_a(), output, params);
    }

    private static void shaped(ItemStack output, Object ... params) {
        ModRecipes.shaped(output.func_77977_a(), output, params);
    }

    private static void shaped(String name, Item output, Object ... params) {
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("improvedbackpacks", name), null, (ItemStack)new ItemStack(output), (Object[])params);
    }

    private static void shaped(String name, Block output, Object ... params) {
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("improvedbackpacks", name), null, (ItemStack)new ItemStack(output), (Object[])params);
    }

    private static void shaped(String name, ItemStack output, Object ... params) {
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("improvedbackpacks", name), null, (ItemStack)output, (Object[])params);
    }

    private static void shapeless(Item output, Ingredient ... inputs) {
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("improvedbackpacks", output.func_77658_a()), null, (ItemStack)new ItemStack(output), (Ingredient[])inputs);
    }

    private static void shapeless(Block output, Ingredient ... inputs) {
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("improvedbackpacks", output.func_149739_a()), null, (ItemStack)new ItemStack(output), (Ingredient[])inputs);
    }

    private static void shapeless(ItemStack output, Ingredient ... inputs) {
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("improvedbackpacks", output.func_77977_a()), null, (ItemStack)output, (Ingredient[])inputs);
    }

    private static void smelting(Item input, Item output, float xp) {
        GameRegistry.addSmelting((Item)input, (ItemStack)new ItemStack(output), (float)xp);
    }

    private static void smelting(Item input, Block output, float xp) {
        GameRegistry.addSmelting((Item)input, (ItemStack)new ItemStack(output), (float)xp);
    }

    private static void smelting(Item input, ItemStack output, float xp) {
        GameRegistry.addSmelting((Item)input, (ItemStack)output, (float)xp);
    }

    private static void smelting(Block input, Item output, float xp) {
        GameRegistry.addSmelting((Block)input, (ItemStack)new ItemStack(output), (float)xp);
    }

    private static void smelting(Block input, Block output, float xp) {
        GameRegistry.addSmelting((Block)input, (ItemStack)new ItemStack(output), (float)xp);
    }

    private static void smelting(Block input, ItemStack output, float xp) {
        GameRegistry.addSmelting((Block)input, (ItemStack)output, (float)xp);
    }

    private static void smelting(ItemStack input, Item output, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)new ItemStack(output), (float)xp);
    }

    private static void smelting(ItemStack input, Block output, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)new ItemStack(output), (float)xp);
    }

    private static void smelting(ItemStack input, ItemStack output, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp);
    }
}

