/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.tiles;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.poopycoders.improvedbackpacks.ImprovedBackpacks;
import ru.poopycoders.improvedbackpacks.init.ModConfig;
import ru.poopycoders.improvedbackpacks.init.ModItems;
import ru.poopycoders.improvedbackpacks.inventory.IBackpackInventory;
import ru.poopycoders.improvedbackpacks.items.ItemBackpack;
import ru.poopycoders.improvedbackpacks.utils.NBTUtils;

public class TileEntityBackpack
extends TileEntity
implements IBackpackInventory {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int tier;
    private UUID uuid;
    private EnumDyeColor color;
    private String customName;
    private boolean destroyedByCreativePlayer;
    private boolean changedColor;

    public void readFirstSyncNBT(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readSyncNBT(tag);
    }

    public void readSyncNBT(NBTTagCompound tag) {
        this.changedColor = false;
        if (tag.func_150297_b("Color", 3)) {
            int colorMeta = MathHelper.func_76125_a((int)tag.func_74762_e("Color"), (int)0, (int)EnumDyeColor.values().length);
            if (this.color == null || this.color.func_176765_a() != colorMeta) {
                this.color = EnumDyeColor.func_176764_b((int)colorMeta);
                this.changedColor = true;
            }
        } else if (this.color != null) {
            this.color = null;
            this.changedColor = true;
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.readFirstSyncNBT(tag);
        this.tier = tag.func_150297_b("Tier", 3) ? MathHelper.func_76125_a((int)tag.func_74762_e("Tier"), (int)0, (int)ModConfig.maxBackpackTier) : 0;
        if (tag.func_186855_b("UUID")) {
            this.uuid = tag.func_186857_a("UUID");
        }
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.items);
        this.customName = tag.func_150297_b("CustomName", 8) ? tag.func_74779_i("CustomName") : null;
    }

    @Nonnull
    public NBTTagCompound writeFirstSyncNBT(NBTTagCompound tag) {
        this.writeSyncNBT(tag);
        return super.func_189515_b(tag);
    }

    @Nonnull
    public NBTTagCompound writeSyncNBT(NBTTagCompound tag) {
        if (this.color != null) {
            tag.func_74768_a("Color", this.color.func_176765_a());
        }
        return tag;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.tier != 0) {
            tag.func_74768_a("Tier", this.tier);
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.items);
        if (this.customName != null) {
            tag.func_74778_a("CustomName", this.customName);
        }
        if (this.uuid != null) {
            tag.func_186854_a("UUID", this.uuid);
        }
        return this.writeFirstSyncNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeFirstSyncNBT(new NBTTagCompound());
    }

    @ParametersAreNullableByDefault
    public void handleUpdateTag(NBTTagCompound tag) {
        this.readFirstSyncNBT(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.writeSyncNBT(new NBTTagCompound()));
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager connection, SPacketUpdateTileEntity packet) {
        this.readSyncNBT(packet.func_148857_g());
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.changedColor) {
            this.changedColor = false;
            Minecraft.func_71410_x().field_71438_f.func_174959_b(packet.func_179823_a());
        }
    }

    public int func_70302_i_() {
        return ItemBackpack.getInventorySize(this.tier);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_190926_b() || !ImprovedBackpacks.api.isStackBlocked(stack, null);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.customName;
        }
        if (this.color != null) {
            return "item.backpack." + this.color.func_176762_d() + ".name";
        }
        return "item.backpack.name";
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return new TextComponentString(this.func_70005_c_());
        }
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setTier(int tier) {
        this.tier = tier;
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void loadItemsFromBackpack(ItemStack backpack) {
        if (backpack.func_77942_o()) {
            ItemStackHelper.func_191283_b((NBTTagCompound)backpack.func_77978_p(), this.items);
        }
    }

    public EnumDyeColor getColor() {
        return this.color;
    }

    public void setColor(EnumDyeColor color) {
        this.color = color;
    }

    @Override
    public EnumDyeColor getBackpackColor() {
        return this.color;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public ItemStack exportToItemStack() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        ItemStack is = new ItemStack((Item)ModItems.BACKPACK);
        ItemBackpack.setBackpackColor(is, this.color);
        ItemBackpack.setBackpackUUID(is, this.uuid);
        ItemBackpack.setTier(is, this.tier);
        ItemStackHelper.func_191282_a((NBTTagCompound)NBTUtils.getStackTag(is), this.items);
        if (this.func_145818_k_()) {
            is.func_151001_c(this.func_70005_c_());
        }
        return is;
    }

    public ItemStack getPickBlock() {
        return ItemBackpack.setBackpackColor(new ItemStack((Item)ModItems.BACKPACK), this.color);
    }

    public void setDestroyedByCreativePlayer(boolean destroyedByCreativePlayer) {
        this.destroyedByCreativePlayer = destroyedByCreativePlayer;
    }

    public boolean isDestroyedByCreativePlayer() {
        return this.destroyedByCreativePlayer;
    }

    public boolean shouldDrop() {
        return !this.isDestroyedByCreativePlayer() || !this.func_191420_l() || this.func_145818_k_();
    }
}

