/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.fluids;

import de.ellpeck.actuallyadditions.mod.blocks.base.BlockFluidFlowing;
import de.ellpeck.actuallyadditions.mod.fluids.FluidAA;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.EnumRarity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public final class InitFluids {
    public static Fluid fluidCanolaOil;
    public static Fluid fluidRefinedCanolaOil;
    public static Fluid fluidCrystalOil;
    public static Fluid fluidEmpoweredOil;
    public static Block blockCanolaOil;
    public static Block blockRefinedCanolaOil;
    public static Block blockCrystalOil;
    public static Block blockEmpoweredOil;

    public static void init() {
        fluidCanolaOil = InitFluids.registerFluid("canolaoil", "block_canola_oil", EnumRarity.UNCOMMON);
        fluidRefinedCanolaOil = InitFluids.registerFluid("refinedcanolaoil", "block_refined_canola_oil", EnumRarity.UNCOMMON);
        fluidCrystalOil = InitFluids.registerFluid("crystaloil", "block_crystal_oil", EnumRarity.RARE);
        fluidEmpoweredOil = InitFluids.registerFluid("empoweredoil", "block_empowered_oil", EnumRarity.EPIC);
        blockCanolaOil = InitFluids.registerFluidBlock(fluidCanolaOil, Material.field_151586_h, "block_canola_oil");
        blockRefinedCanolaOil = InitFluids.registerFluidBlock(fluidRefinedCanolaOil, Material.field_151586_h, "block_refined_canola_oil");
        blockCrystalOil = InitFluids.registerFluidBlock(fluidCrystalOil, Material.field_151586_h, "block_crystal_oil");
        blockEmpoweredOil = InitFluids.registerFluidBlock(fluidEmpoweredOil, Material.field_151586_h, "block_empowered_oil");
    }

    private static Fluid registerFluid(String fluidName, String fluidTextureName, EnumRarity rarity) {
        Fluid fluid = new FluidAA(fluidName.toLowerCase(Locale.ROOT), fluidTextureName).setRarity(rarity);
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        return FluidRegistry.getFluid((String)fluid.getName());
    }

    private static Block registerFluidBlock(Fluid fluid, Material material, String name) {
        return new BlockFluidFlowing(fluid, material, name);
    }
}

