/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CompostRecipe;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityCompost
extends TileEntityInventoryBase {
    public static final int COMPOST_TIME_TICKS = 3000;
    protected int conversionTime;
    protected CompostRecipe recipe;

    public TileEntityCompost() {
        super(1, "compost");
    }

    public static CompostRecipe getRecipeForInput(ItemStack input) {
        if (StackUtil.isValid(input)) {
            for (CompostRecipe recipe : ActuallyAdditionsAPI.COMPOST_RECIPES) {
                if (!recipe.matches(input)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("ConversionTime", this.conversionTime);
        }
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.conversionTime = compound.func_74762_e("ConversionTime");
        }
        if (type == TileEntityBase.NBTType.SYNC) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c.func_177984_a());
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            boolean theFlag = this.conversionTime > 0;
            ItemStack input = this.inv.getStackInSlot(0);
            if (StackUtil.isValid(input)) {
                if (this.recipe == null || !this.recipe.matches(input)) {
                    this.recipe = TileEntityCompost.getRecipeForInput(input);
                }
                if (this.recipe != null) {
                    ++this.conversionTime;
                    if (this.conversionTime >= 3000) {
                        ItemStack output = this.recipe.getOutput().func_77946_l();
                        output.func_190920_e(input.func_190916_E());
                        this.inv.setStackInSlot(0, output);
                        this.conversionTime = 0;
                        this.func_70296_d();
                    }
                } else {
                    this.conversionTime = 0;
                }
            }
            if (theFlag != this.conversionTime > 0) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> TileEntityCompost.getRecipeForInput(stack) != null;
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> TileEntityCompost.getRecipeForInput(this.inv.getStackInSlot(slot)) == null;
    }

    public IBlockState getCurrentDisplay() {
        ItemStack input = this.inv.getStackInSlot(0);
        CompostRecipe displayRecipe = this.recipe;
        if (displayRecipe == null || !displayRecipe.matches(input)) {
            displayRecipe = TileEntityCompost.getRecipeForInput(input);
        }
        if (displayRecipe == null) {
            for (CompostRecipe r : ActuallyAdditionsAPI.COMPOST_RECIPES) {
                if (ItemUtil.areItemsEqual(input, r.getOutput(), true)) {
                    return r.getOutputDisplay();
                }
                if (!r.getInput().apply(input)) continue;
                return r.getInputDisplay();
            }
        }
        if (displayRecipe != null) {
            return displayRecipe.getInputDisplay();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public float getHeight() {
        ItemStack input = this.inv.getStackInSlot(0);
        if (input.func_190926_b()) {
            return 0.0f;
        }
        return (float)input.func_190916_E() / (float)input.func_77976_d();
    }
}

