/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.client.gui.ChangeCommandButton;
import com.github.alexthe666.rats.server.entity.tile.TileEntityAutoCurdler;
import com.github.alexthe666.rats.server.inventory.ContainerAutoCurdler;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiAutoCurdler
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/auto_curdler.png");
    private final InventoryPlayer playerInventory;
    private final IInventory tileFurnace;
    public ChangeCommandButton previousCommand;
    public ChangeCommandButton nextCommand;

    public GuiAutoCurdler(IInventory furnaceInv, InventoryPlayer playerInv) {
        super((Container)new ContainerAutoCurdler(furnaceInv, playerInv.field_70458_d));
        this.playerInventory = playerInv;
        this.tileFurnace = furnaceInv;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tileFurnace.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 5, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 94 + 2, 0x404040);
        int screenW = (this.field_146294_l - this.field_146999_f) / 2;
        int screenH = (this.field_146295_m - this.field_147000_g) / 2;
        if (((TileEntityAutoCurdler)this.tileFurnace).tank.getFluid() != null && mouseX > screenW + 29 && mouseX < screenW + 53 && mouseY > screenH + 15 && mouseY < screenH + 73) {
            String fluidName = TextFormatting.BLUE.toString() + ((TileEntityAutoCurdler)this.tileFurnace).tank.getFluid().getLocalizedName();
            String fluidSize = TextFormatting.GRAY.toString() + ((TileEntityAutoCurdler)this.tileFurnace).tank.getFluidAmount() + " " + I18n.func_135052_a((String)"container.auto_curdler.mb", (Object[])new Object[0]);
            GuiUtils.drawHoveringText(Arrays.asList(fluidName, fluidSize), (int)(mouseX - screenW), (int)(mouseY - screenH + 10), (int)this.field_146294_l, (int)this.field_146295_m, (int)120, (FontRenderer)this.field_146289_q);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int l = this.getCookProgressScaled(50);
        this.func_73729_b(i + 63, j + 35, 176, 0, l + 1, 16);
        if (((TileEntityAutoCurdler)this.tileFurnace).tank.getFluid() != null) {
            FluidTank tank = ((TileEntityAutoCurdler)this.tileFurnace).tank;
            int textureYPos = (int)(57.0f * ((float)tank.getFluidAmount() / (float)tank.getCapacity()));
            GuiAutoCurdler.renderFluidStack(i + 29, j + 15 - textureYPos + 57, 24, textureYPos, 0.0f, tank.getFluid());
            this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        }
        this.func_73729_b(i + 29, j + 15, 0, 166, 24, 58);
    }

    private int getCookProgressScaled(int pixels) {
        int i = this.tileFurnace.func_174887_a_(1);
        int j = this.tileFurnace.func_174887_a_(2);
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public static void renderFluidStack(int x, int y, int width, int height, float depth, FluidStack fluidStack) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill(fluidStack).toString());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        do {
            int currentHeight = Math.min(sprite.func_94216_b(), height);
            height -= currentHeight;
            float v2 = sprite.func_94207_b((double)((float)(16 * currentHeight) / (float)sprite.func_94216_b()));
            int x2 = x;
            int width2 = width;
            do {
                int currentWidth = Math.min(sprite.func_94211_a(), width2);
                width2 -= currentWidth;
                float u2 = sprite.func_94214_a((double)((float)(16 * currentWidth) / (float)sprite.func_94211_a()));
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_181662_b((double)x2, (double)y, (double)depth).func_187315_a((double)u1, (double)v1).func_181675_d();
                bufferbuilder.func_181662_b((double)x2, (double)(y + currentHeight), (double)depth).func_187315_a((double)u1, (double)v2).func_181675_d();
                bufferbuilder.func_181662_b((double)(x2 + currentWidth), (double)(y + currentHeight), (double)depth).func_187315_a((double)u2, (double)v2).func_181675_d();
                bufferbuilder.func_181662_b((double)(x2 + currentWidth), (double)y, (double)depth).func_187315_a((double)u2, (double)v1).func_181675_d();
                tessellator.func_78381_a();
                x2 += currentWidth;
            } while (width2 > 0);
            y += currentHeight;
        } while (height > 0);
    }
}

