/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityFeralRatlantean
extends EntityMob
implements IAnimatedEntity,
IRatlantean {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SLASH = Animation.create((int)25);
    public static final Animation ANIMATION_SNIFF = Animation.create((int)20);
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("rats", "feral_ratlantean"));
    private static final DataParameter<Boolean> TOGA = EntityDataManager.func_187226_a(EntityFeralRatlantean.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLOR_VARIANT = EntityDataManager.func_187226_a(EntityFeralRatlantean.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Predicate<EntityLivingBase> NOT_RATLANTEAN = new Predicate<EntityLivingBase>(){

        public boolean apply(@Nullable EntityLivingBase entity) {
            return entity.func_70089_S() && !(entity instanceof IRatlantean);
        }
    };
    private int animationTick;
    private Animation currentAnimation;

    public EntityFeralRatlantean(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.85f, 1.2f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, false, NOT_RATLANTEAN));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.field_70146_Z.nextBoolean() ? ANIMATION_SLASH : ANIMATION_BITE);
        }
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TOGA, (Object)true);
        this.field_70180_af.func_187214_a(COLOR_VARIANT, (Object)0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 4.0f && this.func_70685_l((Entity)this.func_70638_az())) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(this.field_70146_Z.nextBoolean() ? ANIMATION_BITE : ANIMATION_SLASH);
            }
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() > 8 && this.getAnimationTick() < 12) {
                this.doExtraEffect(this.func_70638_az());
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 0.25f, this.field_70165_t - this.func_70638_az().field_70165_t, this.field_70161_v - this.func_70638_az().field_70161_v);
            }
            if (this.getAnimation() == ANIMATION_SLASH && (this.getAnimationTick() == 8 || this.getAnimationTick() == 16)) {
                this.doExtraEffect(this.func_70638_az());
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 0.25f, this.field_70165_t - this.func_70638_az().field_70165_t, this.field_70161_v - this.func_70638_az().field_70161_v);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.field_70146_Z.nextInt(150) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SNIFF);
        }
    }

    public boolean doExtraEffect(EntityLivingBase target) {
        return false;
    }

    public int getColorVariant() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR_VARIANT);
    }

    public void setColorVariant(int color) {
        this.field_70180_af.func_187227_b(COLOR_VARIANT, (Object)color);
    }

    public void setToga(boolean plague) {
        this.field_70180_af.func_187227_b(TOGA, (Object)plague);
    }

    public boolean hasToga() {
        return (Boolean)this.field_70180_af.func_187225_a(TOGA);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ColorVariant", this.getColorVariant());
        compound.func_74757_a("Toga", this.hasToga());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setToga(compound.func_74767_n("Toga"));
        this.setColorVariant(compound.func_74762_e("ColorVariant"));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setColorVariant(this.func_70681_au().nextInt(4));
        this.setToga(true);
        return livingdata;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_SLASH, ANIMATION_SNIFF};
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.RAT_PLAGUE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.RAT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.RAT_DIE;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.4f;
    }

    protected float func_70599_aP() {
        return 0.7f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }
}

