/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRatlanteanFlame;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRatlanteanSpirit
extends EntityMob
implements IAnimatedEntity,
IRatlantean {
    public static final Animation ANIMATION_ATTACK = Animation.create((int)10);
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("rats", "ratlantean_soul"));
    private int animationTick;
    private Animation currentAnimation;

    public EntityRatlanteanSpirit(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.85f);
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityRatlanteanSpirit.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGolem.class, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.field_70170_p.field_72995_K) {
            RatsMod.PROXY.spawnParticle("rat_ghost", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.92f, 0.82, 0.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK};
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.RATLANTEAN_SPIRIT_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.RATLANTEAN_SPIRIT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.RATLANTEAN_SPIRIT_DIE;
    }

    class AIFireballAttack
    extends EntityAIBase {
        private final EntityRatlanteanSpirit parentEntity;
        public int attackTimer;

        public AIFireballAttack(EntityRatlanteanSpirit ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (entitylivingbase != null && entitylivingbase.func_70068_e((Entity)this.parentEntity) >= 4096.0 || !this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                EntityRatlanteanSpirit.this.field_70765_h.func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 0.5);
            }
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 20) {
                    double d1 = 4.0;
                    double d2 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d3 = entitylivingbase.field_70163_u + (double)entitylivingbase.field_70131_O - (this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f));
                    double d4 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    world.func_180498_a(null, 1016, new BlockPos((Entity)this.parentEntity), 0);
                    EntityRatlanteanFlame entitylargefireball = new EntityRatlanteanFlame(world, (EntityLivingBase)this.parentEntity, d2, d3, d4);
                    entitylargefireball.field_70165_t = this.parentEntity.field_70165_t;
                    entitylargefireball.field_70163_u = this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f);
                    entitylargefireball.field_70161_v = this.parentEntity.field_70161_v;
                    world.func_72838_d((Entity)entitylargefireball);
                    this.attackTimer = -10;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityRatlanteanSpirit.this.func_70605_aq().func_75640_a() && EntityRatlanteanSpirit.this.field_70146_Z.nextInt(2) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityRatlanteanSpirit.this);
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityRatlanteanSpirit.this.field_70146_Z.nextInt(15) - 7, EntityRatlanteanSpirit.this.field_70146_Z.nextInt(11) - 5, EntityRatlanteanSpirit.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityRatlanteanSpirit.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityRatlanteanSpirit.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityRatlanteanSpirit.this.func_70638_az() != null) break;
                EntityRatlanteanSpirit.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityRatlanteanSpirit vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityRatlanteanSpirit.this.field_70165_t;
                double d1 = this.field_75647_c - EntityRatlanteanSpirit.this.field_70163_u;
                double d2 = this.field_75644_d - EntityRatlanteanSpirit.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityRatlanteanSpirit.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityRatlanteanSpirit.this.field_70159_w *= 0.5;
                    EntityRatlanteanSpirit.this.field_70181_x *= 0.5;
                    EntityRatlanteanSpirit.this.field_70179_y *= 0.5;
                } else {
                    EntityRatlanteanSpirit.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityRatlanteanSpirit.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityRatlanteanSpirit.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityRatlanteanSpirit.this.func_70638_az() == null) {
                        EntityRatlanteanSpirit.this.field_70761_aq = EntityRatlanteanSpirit.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityRatlanteanSpirit.this.field_70159_w, (double)EntityRatlanteanSpirit.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityRatlanteanSpirit.this.func_70638_az().field_70165_t - EntityRatlanteanSpirit.this.field_70165_t;
                        double d5 = EntityRatlanteanSpirit.this.func_70638_az().field_70161_v - EntityRatlanteanSpirit.this.field_70161_v;
                        EntityRatlanteanSpirit.this.field_70761_aq = EntityRatlanteanSpirit.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

