/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.Comparator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RatAIPickupFromInventory
extends EntityAIBase {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int feedingTicks;

    public RatAIPickupFromInventory(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!(this.entity.canMove() && this.entity.func_70909_n() && this.canPickUp() && this.entity.func_70638_az() == null)) {
            return false;
        }
        if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        this.targetBlock = this.entity.pickupPos;
    }

    private boolean canPickUp() {
        return this.entity.getCommand() == RatCommand.TRANSPORT || this.entity.getCommand() == RatCommand.HARVEST && (this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) || this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLACER) || this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BREEDER));
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.field_70170_p.func_175625_s(this.targetBlock) != null) {
            TileEntity entity = this.entity.field_70170_p.func_175625_s(this.targetBlock);
            this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
            double distance = this.entity.func_70011_f((double)this.targetBlock.func_177958_n() + 0.5, this.targetBlock.func_177956_o() + 1, (double)this.targetBlock.func_177952_p() + 0.5);
            if (distance < 2.5 && distance > 1.65 && this.canSeeChest() && entity instanceof IInventory) {
                this.toggleChest((IInventory)entity, true);
            }
            if (distance <= 1.7 && this.canSeeChest()) {
                IItemHandler handler;
                if (entity instanceof IInventory) {
                    this.toggleChest((IInventory)entity, false);
                }
                if ((handler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) == null) {
                    return;
                }
                int slot = RatUtils.getItemSlotFromItemHandler(this.entity, handler, this.entity.field_70170_p.field_73012_v);
                int extractSize = this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLATTER) ? 64 : 1;
                ItemStack stack = ItemStack.field_190927_a;
                try {
                    if (handler.getSlots() > 0 && handler.extractItem(slot, extractSize, true) != ItemStack.field_190927_a) {
                        stack = handler.extractItem(slot, extractSize, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (slot == -1 || stack == ItemStack.field_190927_a) {
                    this.targetBlock = null;
                    this.func_75251_c();
                } else {
                    ItemStack duplicate = stack.func_77946_l();
                    if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && !this.entity.field_70170_p.field_72995_K) {
                        this.entity.func_70099_a(this.entity.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
                    }
                    this.entity.func_184611_a(EnumHand.MAIN_HAND, duplicate);
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            }
        }
    }

    public void toggleChest(IInventory te, boolean open) {
        if (te instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            if (open) {
                ++chest.field_145987_o;
                this.entity.field_70170_p.func_175641_c(this.targetBlock, chest.func_145838_q(), 1, chest.field_145987_o);
            } else if (chest.field_145987_o > 0) {
                chest.field_145987_o = 0;
                this.entity.field_70170_p.func_175641_c(this.targetBlock, chest.func_145838_q(), 1, chest.field_145987_o);
            }
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.field_70165_t - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.field_70163_u + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.field_70161_v - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

