/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityRatTrap
extends TileEntity
implements ITickable {
    public boolean isShut;
    public float shutProgress;
    private NonNullList<ItemStack> baitStack = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);

    public void func_73660_a() {
        boolean prevShut = this.isShut;
        if (this.isShut && this.shutProgress < 6.0f) {
            this.shutProgress += 1.5f;
        } else if (!this.isShut && this.shutProgress > 0.0f) {
            this.shutProgress -= 1.5f;
        }
        if (RatUtils.isRatFood((ItemStack)this.baitStack.get(0))) {
            this.killRats();
        }
    }

    private void killRats() {
        if (!this.isShut) {
            float i = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float j = (float)this.func_174877_v().func_177956_o() + 0.5f;
            float k = (float)this.func_174877_v().func_177952_p() + 0.5f;
            float d0 = 0.65f;
            for (EntityRat rat : this.field_145850_b.func_72872_a(EntityRat.class, new AxisAlignedBB((double)i - (double)d0, (double)j - (double)d0, (double)k - (double)d0, (double)i + (double)d0, (double)j + (double)d0, (double)k + (double)d0))) {
                if (rat.field_70128_L) continue;
                rat.setKilledInTrap();
                this.isShut = true;
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187614_cJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.decreaseBait();
            }
        }
    }

    private void decreaseBait() {
        ((ItemStack)this.baitStack.get(0)).func_190918_g(1);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.baitStack);
        compound.func_74757_a("IsShut", this.isShut);
        compound.func_74776_a("ShutProgress", this.shutProgress);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.baitStack = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.baitStack);
        this.isShut = compound.func_74767_n("IsShut");
        this.shutProgress = compound.func_74760_g("ShutProgress");
        super.func_145839_a(compound);
    }

    public void setBaitStack(ItemStack stack) {
        this.baitStack.set(0, (Object)stack);
    }

    public ItemStack getBait() {
        return (ItemStack)this.baitStack.get(0);
    }

    public int calculateRedstone() {
        if (this.isShut) {
            return 15;
        }
        return 0;
    }

    public void onRedstonePulse() {
        this.isShut = true;
    }
}

