/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.server.blocks.BlockRatTube;
import com.github.alexthe666.rats.server.entity.EntityRat;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class TileEntityRatTube
extends TileEntity
implements ITickable {
    private static PropertyBool[] allOpenVars = new PropertyBool[]{BlockRatTube.OPEN_DOWN, BlockRatTube.OPEN_EAST, BlockRatTube.OPEN_NORTH, BlockRatTube.OPEN_SOUTH, BlockRatTube.OPEN_UP, BlockRatTube.OPEN_WEST};
    public EnumFacing opening = null;
    public boolean isNode = false;

    public void func_73660_a() {
        if (this.isOpen()) {
            float i = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float j = (float)this.func_174877_v().func_177956_o() + 0.2f;
            float k = (float)this.func_174877_v().func_177952_p() + 0.5f;
            float d0 = 0.4f;
            for (EntityRat rat : this.field_145850_b.func_72872_a(EntityRat.class, new AxisAlignedBB((double)i - (double)d0, (double)j - (double)d0, (double)k - (double)d0, (double)i + (double)d0, (double)j + (double)d0, (double)k + (double)d0))) {
                rat.field_70159_w *= 1.75;
                rat.field_70179_y *= 1.75;
                this.updateRat(rat);
            }
        }
    }

    private Vec3d offsetTubePos() {
        if (this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockRatTube) {
            IBlockState actualState = this.func_145838_q().func_176221_a(this.func_145831_w().func_180495_p(this.field_174879_c), (IBlockAccess)this.func_145831_w(), this.field_174879_c);
            BlockPos pos = new BlockPos(0, 0, 0);
            if (((Boolean)actualState.func_177229_b((IProperty)BlockRatTube.UP)).booleanValue()) {
                pos = pos.func_177972_a(EnumFacing.UP);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)BlockRatTube.DOWN)).booleanValue()) {
                pos = pos.func_177972_a(EnumFacing.DOWN);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)BlockRatTube.EAST)).booleanValue()) {
                pos = pos.func_177972_a(EnumFacing.EAST);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)BlockRatTube.WEST)).booleanValue()) {
                pos = pos.func_177972_a(EnumFacing.WEST);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)BlockRatTube.NORTH)).booleanValue()) {
                pos = pos.func_177972_a(EnumFacing.NORTH);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)BlockRatTube.SOUTH)).booleanValue()) {
                pos = pos.func_177972_a(EnumFacing.SOUTH);
            }
            return new Vec3d((double)pos.func_177958_n() * 0.25, (double)pos.func_177956_o() * 0.25, (double)pos.func_177952_p() * 0.25);
        }
        return Vec3d.field_186680_a;
    }

    private void updateRat(EntityRat rat) {
    }

    private boolean isOpen() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockRatTube) {
            for (PropertyBool opened : allOpenVars) {
                if (!((Boolean)state.func_177229_b((IProperty)opened)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("Node", this.isNode);
        compound.func_74768_a("OpenSide", this.opening == null ? -1 : this.opening.ordinal());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.isNode = compound.func_74767_n("Node");
        int i = compound.func_74762_e("OpenSide");
        this.opening = i == -1 ? null : EnumFacing.values()[MathHelper.func_76125_a((int)i, (int)0, (int)(EnumFacing.values().length - 1))];
        super.func_145839_a(compound);
    }

    public void setEntranceData(EnumFacing side, boolean open) {
        if (open) {
            this.opening = side;
            this.isNode = true;
        } else {
            this.opening = null;
            this.isNode = false;
        }
    }
}

