/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.server.items.ItemRatUpgrade;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class ItemRatUpgradeBucket
extends ItemRatUpgrade {
    public ItemRatUpgradeBucket(String name, int rarity, int textLength) {
        super(name, rarity, textLength);
    }

    public static ItemStack getBucketFromFluid(FluidStack ingredient) {
        ItemStack filledBucket;
        FluidStack fluidContained;
        if (ingredient == null) {
            return new ItemStack(Items.field_151133_ar);
        }
        if (ingredient.getFluid() == FluidRegistry.WATER) {
            return new ItemStack(Items.field_151131_as);
        }
        if (ingredient.getFluid() == FluidRegistry.LAVA) {
            return new ItemStack(Items.field_151129_at);
        }
        if (ingredient.getFluid().getName().equals("milk")) {
            return new ItemStack(Items.field_151117_aB);
        }
        if (FluidRegistry.isUniversalBucketEnabled() && (fluidContained = FluidUtil.getFluidContained((ItemStack)(filledBucket = FluidUtil.getFilledBucket((FluidStack)ingredient)))) != null && fluidContained.isFluidEqual(ingredient)) {
            return filledBucket;
        }
        return new ItemStack(Items.field_151133_ar);
    }

    public static int getMbTransferRate(Item item) {
        if (item == RatsItemRegistry.RAT_UPGRADE_BUCKET || item == RatsItemRegistry.RAT_UPGRADE_MILKER) {
            return 1000;
        }
        if (item == RatsItemRegistry.RAT_UPGRADE_BIG_BUCKET) {
            return 5000;
        }
        return 0;
    }
}

